/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.bulk.DeleteRequest;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.List;
import org.bson.io.BsonOutput;

class DeleteMessage
extends RequestMessage {
    private final List<DeleteRequest> deleteRequests;

    public DeleteMessage(String collectionName, List<DeleteRequest> deletes, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_DELETE, settings);
        this.deleteRequests = deletes;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        this.writeDelete(this.deleteRequests.get(0), bsonOutput);
        if (this.deleteRequests.size() == 1) {
            return null;
        }
        return new DeleteMessage(this.getCollectionName(), this.deleteRequests.subList(1, this.deleteRequests.size()), this.getSettings());
    }

    private void writeDelete(DeleteRequest deleteRequest, BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        if (deleteRequest.isMulti()) {
            bsonOutput.writeInt32(0);
        } else {
            bsonOutput.writeInt32(1);
        }
        this.addDocument(deleteRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
    }
}

