/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.OraclePreparedStatement;

abstract class ByteCopyingBinder
extends Binder {
    ByteCopyingBinder() {
    }

    Binder copyingBinder() {
        return this;
    }

    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) {
        int len;
        int fromByteOffset;
        byte[] fromBytes;
        if (rankInBuffer == 0) {
            fromBytes = stmt.lastBoundBytes;
            fromByteOffset = stmt.lastBoundByteOffsets[bindPosition];
            bindIndicators[indoffset] = stmt.lastBoundInds[bindPosition];
            bindIndicators[lenoffset] = stmt.lastBoundLens[bindPosition];
            if (fromBytes == bindBytes && fromByteOffset == byteoffset) {
                return;
            }
            len = stmt.lastBoundByteLens[bindPosition];
            if (len > bytePitch) {
                len = bytePitch;
            }
        } else {
            fromBytes = bindBytes;
            fromByteOffset = byteoffset - bytePitch;
            bindIndicators[indoffset] = bindIndicators[indoffset - 1];
            bindIndicators[lenoffset] = bindIndicators[lenoffset - 1];
            len = bytePitch;
        }
        System.arraycopy(fromBytes, fromByteOffset, bindBytes, byteoffset, len);
    }
}

