/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;

class IntervaldsAccessor
extends Accessor {
    static final int maxLength = 11;

    IntervaldsAccessor(OracleStatement stmt, int max_len, short form, int external_type, boolean forBind) throws SQLException {
        this.init(stmt, 183, 183, form, forBind);
        this.initForDataAccess(external_type, max_len, null);
    }

    IntervaldsAccessor(OracleStatement stmt, int max_len, boolean nullable, int flags, int precision, int scale, int contflag, int total_elems, short form) throws SQLException {
        this.init(stmt, 183, 183, form, false);
        this.initForDescribe(183, max_len, nullable, flags, precision, scale, contflag, total_elems, form, null);
        this.initForDataAccess(0, max_len, null);
    }

    void initForDataAccess(int external_type, int max_len, String typeName) throws SQLException {
        if (external_type != 0) {
            this.externalType = external_type;
        }
        this.internalTypeMaxLength = 11;
        if (max_len > 0 && max_len < this.internalTypeMaxLength) {
            this.internalTypeMaxLength = max_len;
        }
        this.byteLength = this.internalTypeMaxLength;
    }

    String getString(int currentRow) throws SQLException {
        String result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            int offset = this.columnIndex + this.byteLength * currentRow;
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            byte[] data = new byte[len];
            System.arraycopy(this.rowSpaceByte, offset, data, 0, len);
            result = new INTERVALDS(data).toString();
        }
        return result;
    }

    Object getObject(int currentRow) throws SQLException {
        return this.getINTERVALDS(currentRow);
    }

    Datum getOracleObject(int currentRow) throws SQLException {
        return this.getINTERVALDS(currentRow);
    }

    Object getObject(int currentRow, Map map) throws SQLException {
        return this.getINTERVALDS(currentRow);
    }

    INTERVALDS getINTERVALDS(int currentRow) throws SQLException {
        INTERVALDS result = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + currentRow] != -1) {
            int offset = this.columnIndex + this.byteLength * currentRow;
            short len = this.rowSpaceIndicator[this.lengthIndex + currentRow];
            byte[] data = new byte[len];
            System.arraycopy(this.rowSpaceByte, offset, data, 0, len);
            result = new INTERVALDS(data);
        }
        return result;
    }
}

