/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.sql.SQLException;
import javax.sql.rowset.FilteredRowSet;
import javax.sql.rowset.Predicate;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.rowset.OracleWebRowSet;

public class OracleFilteredRowSet
extends OracleWebRowSet
implements FilteredRowSet {
    private Predicate predicate;

    public void setFilter(Predicate p) throws SQLException {
        this.predicate = p;
    }

    public Predicate getFilter() {
        return this.predicate;
    }

    public boolean next() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleFilteredRowSet.next()");
            OracleLog.print(this, 1, 256, 64, "OracleFilteredRowSet.next(), rowCount=" + this.rowCount + ", fetchDirection=" + this.fetchDirection + ", presentRow=" + this.presentRow);
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow >= this.rowCount) {
            return false;
        }
        boolean isPresentRowQualified = false;
        do {
            ++this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            isPresentRowQualified = true;
            break;
        } while (this.presentRow <= this.rowCount);
        if (isPresentRowQualified) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean previous() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleFilteredRowSet.previous()");
            OracleLog.print(this, 1, 256, 64, "OracleFilteredRowSet.previous(), rowCount=" + this.rowCount + ", fetchDirection=" + this.fetchDirection + ", presentRow=" + this.presentRow);
        }
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (this.rowCount <= 0) {
            return false;
        }
        if (this.presentRow <= 1) {
            return false;
        }
        boolean isPresentRowQualified = false;
        do {
            --this.presentRow;
            if (this.predicate != null && (this.predicate == null || !this.predicate.evaluate(this))) continue;
            isPresentRowQualified = true;
            break;
        } while (this.presentRow >= 1);
        if (isPresentRowQualified) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    public boolean absolute(int row) throws SQLException {
        int num;
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleFilteredRowSet.absolute(" + row + ")");
            OracleLog.print(this, 1, 256, 64, "OracleFilteredRowSet.absolute(" + row + "), rowsetType=" + this.rowsetType + ", presentRow=" + this.presentRow);
        }
        if (this.rowsetType == 1003) {
            throw new SQLException("The RowSet type is TYPE_FORWARD_ONLY");
        }
        if (row == 0 || Math.abs(row) > this.rowCount) {
            return false;
        }
        int positiveRow = row < 0 ? this.rowCount + row + 1 : row;
        this.presentRow = 0;
        for (num = 0; num < positiveRow && this.presentRow <= this.rowCount; ++num) {
            if (this.next()) {
                continue;
            }
            return false;
        }
        if (num == positiveRow) {
            this.notifyCursorMoved();
            return true;
        }
        return false;
    }

    protected void checkAndFilterObject(int columnIndex, Object obj) throws SQLException {
        if (this.predicate != null && !this.predicate.evaluate(obj, columnIndex)) {
            throw new SQLException("The object does not satisfy filtering criterion");
        }
    }
}

