/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.rowset;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.SQLException;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;

public class OracleSerialBlob
implements Blob,
Serializable,
Cloneable {
    private byte[] buffer;
    private long length;

    public OracleSerialBlob(byte[] bytes) throws SQLException {
        this.length = bytes.length;
        this.buffer = new byte[(int)this.length];
        int i = 0;
        while ((long)i < this.length) {
            this.buffer[i] = bytes[i];
            ++i;
        }
    }

    public OracleSerialBlob(Blob blob) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 16, "OracleSerialBlob.OracleSerialBlob(" + blob + ")");
        }
        this.length = blob.length();
        this.buffer = new byte[(int)this.length];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(blob.getBinaryStream());
        try {
            int bytesRead = 0;
            int offset = 0;
            do {
                if (OracleLog.TRACE) {
                    OracleLog.print(this, 1, 256, 64, "OracleSerialBlob.OracleSerialBlob(Blob), inside do-while loop, bytesRead=" + bytesRead + ", offset=" + offset);
                }
                bytesRead = bufferedInputStream.read(this.buffer, offset, (int)(this.length - (long)offset));
                offset += bytesRead;
            } while (bytesRead > 0);
        }
        catch (IOException ioexception) {
            throw new SQLException("SerialBlob: " + ioexception.getMessage());
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleSerialBlob.getBinaryStream()");
        }
        return new ByteArrayInputStream(this.buffer);
    }

    public byte[] getBytes(long l, int i) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleSerialBlob.getBytes(" + l + ", " + i + ")");
            OracleLog.print(this, 1, 256, 64, "OracleSerialBlob.getBytes(" + l + ", " + i + "), length=" + this.length);
        }
        if (l < 0L || (long)i > this.length || l + (long)i > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        byte[] b = new byte[i];
        System.arraycopy(this.buffer, (int)l, b, 0, i);
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 64, "OracleSerialBlob.getBytes(" + l + ", " + i + "), return " + OracleLog.bytesToPrintableForm("byte array=", b));
        }
        return b;
    }

    public long length() throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleSerialBlob.length()");
            OracleLog.print(this, 1, 256, 16, "OracleSerialBlob.length(), return " + this.length);
        }
        return this.length;
    }

    public long position(byte[] ac, long l) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleSerialBlob.position(byte[] ac, " + l + ")");
            OracleLog.print(this, 1, 256, 64, "OracleSerialBlob.position(" + OracleLog.bytesToPrintableForm("byte array=", ac) + ", " + l + "), length=" + this.length);
        }
        if (l < 0L || l > this.length || l + (long)ac.length > this.length) {
            throw new SQLException("Invalid Arguments");
        }
        int i = (int)(l - 1L);
        boolean flag = false;
        long l2 = ac.length;
        if (l < 0L || l > this.length) {
            return -1L;
        }
        while ((long)i < this.length) {
            int j = 0;
            long l1 = i + 1;
            while (ac[j++] == this.buffer[i++]) {
                if ((long)j != l2) continue;
                return l1;
            }
        }
        return -1L;
    }

    public long position(Blob blob, long l) throws SQLException {
        if (OracleLog.TRACE) {
            OracleLog.print(this, 1, 256, 1, "OracleSerialBlob.position(" + blob + ", " + l + ")");
        }
        return this.position(blob.getBytes(0L, (int)blob.length()), l);
    }

    public int setBytes(long pos, byte[] bytes) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return -1;
    }

    public OutputStream setBinaryStream(long pos) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
        return null;
    }

    public void truncate(long len) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }
}

