/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class CustomSSLSocketFactory
extends SSLSocketFactory {
    private static final boolean DEBUG = false;
    private static SSLSocketFactory ossl = null;

    protected static boolean isFactorySet() {
        return null != ossl;
    }

    protected static void setFactory(SSLSocketFactory sSLSocketFactory) {
        if (null == ossl) {
            ossl = sSLSocketFactory;
        }
    }

    protected void setDefaultFactory() {
        CustomSSLSocketFactory.setFactory((SSLSocketFactory)SSLSocketFactory.getDefault());
    }

    protected CustomSSLSocketFactory() {
    }

    public static SocketFactory getDefault() {
        CustomSSLSocketFactory customSSLSocketFactory = null;
        try {
            Class<?> clazz = Class.forName("oracle.net.jndi.TrustManagerSSLSocketFactory");
            Class.forName("javax.net.ssl.TrustManagerFactory");
            customSSLSocketFactory = (CustomSSLSocketFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            customSSLSocketFactory = new CustomSSLSocketFactory();
        }
        customSSLSocketFactory.setDefaultFactory();
        return customSSLSocketFactory;
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n);
        return this.init(sSLSocket);
    }

    public Socket createSocket(String string, int n, InetAddress inetAddress, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(string, n, inetAddress, n2);
        return this.init(sSLSocket);
    }

    public Socket createSocket(InetAddress inetAddress, int n, InetAddress inetAddress2, int n2) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(inetAddress, n, inetAddress2, n2);
        return this.init(sSLSocket);
    }

    public Socket createSocket(Socket socket, String string, int n, boolean bl) throws IOException {
        SSLSocket sSLSocket = (SSLSocket)ossl.createSocket(socket, string, n, bl);
        return this.init(sSLSocket);
    }

    public String[] getDefaultCipherSuites() {
        return ossl.getDefaultCipherSuites();
    }

    public String[] getSupportedCipherSuites() {
        return ossl.getSupportedCipherSuites();
    }

    private SSLSocket init(SSLSocket sSLSocket) throws IOException {
        sSLSocket.setUseClientMode(true);
        String[] stringArray = new String[]{"SSL_DH_anon_WITH_3DES_EDE_CBC_SHA"};
        sSLSocket.setEnabledCipherSuites(stringArray);
        sSLSocket.startHandshake();
        return sSLSocket;
    }
}

