/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import oracle.sql.CharacterSet;
import oracle.sql.CharacterSet12Byte;
import oracle.sql.CharacterSet1Byte;
import oracle.sql.CharacterSet2ByteFixed;
import oracle.sql.CharacterSetGB18030;
import oracle.sql.CharacterSetJAEUC;
import oracle.sql.CharacterSetLCFixed;
import oracle.sql.CharacterSetSJIS;
import oracle.sql.CharacterSetShift;
import oracle.sql.CharacterSetZHTEUC;
import oracle.sql.converter.CharacterConverterFactory;
import oracle.sql.converter.CharacterConverterFactoryJDBC;
import oracle.sql.converter.CharacterConverters;

public abstract class CharacterSetWithConverter
extends CharacterSet {
    public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
    CharacterConverters m_converter;

    CharacterSetWithConverter(int oracleId, CharacterConverters charConverter) {
        super(oracleId);
        this.m_converter = charConverter;
    }

    static CharacterSet getInstance(int oracleId) {
        CharacterConverters charConverter = ccFactory.make(oracleId);
        if (charConverter == null) {
            return null;
        }
        CharacterSetWithConverter charSetInstance = null;
        charSetInstance = CharacterSet1Byte.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetSJIS.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetShift.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSet2ByteFixed.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetGB18030.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSet12Byte.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetJAEUC.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        charSetInstance = CharacterSetZHTEUC.getInstance(oracleId, charConverter);
        if (charSetInstance != null) {
            return charSetInstance;
        }
        return CharacterSetLCFixed.getInstance(oracleId, charConverter);
    }

    public boolean isLossyFrom(CharacterSet from) {
        return from.getOracleId() != this.getOracleId();
    }

    public boolean isConvertibleFrom(CharacterSet source) {
        return source.getOracleId() == this.getOracleId();
    }

    public String toStringWithReplacement(byte[] bytes, int offset, int count) {
        return this.m_converter.toUnicodeStringWithReplacement(bytes, offset, count);
    }

    public String toString(byte[] bytes, int offset, int count) throws SQLException {
        return this.m_converter.toUnicodeString(bytes, offset, count);
    }

    public byte[] convert(String s) throws SQLException {
        return this.m_converter.toOracleString(s);
    }

    public byte[] convertWithReplacement(String s) {
        return this.m_converter.toOracleStringWithReplacement(s);
    }

    public byte[] convert(CharacterSet from, byte[] source, int offset, int count) throws SQLException {
        if (from.getOracleId() == this.getOracleId()) {
            return CharacterSetWithConverter.useOrCopy(source, offset, count);
        }
        return this.convert(from.toString(source, offset, count));
    }
}

