/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql.converter;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.jdbc.driver.DatabaseError;
import oracle.sql.converter.CharacterConverterJDBC;

public class CharacterConverter1Byte
extends CharacterConverterJDBC {
    static final int ORACHARMASK = 255;
    static final int UCSCHARWIDTH = 16;
    public int m_ucsReplacement = 0;
    public int[] m_ucsChar = null;
    public char[] m_oraCharLevel1 = null;
    public char[] m_oraCharSurrogateLevel = null;
    public char[] m_oraCharLevel2 = null;
    public byte m_oraCharReplacement = 0;
    protected transient boolean noSurrogate = true;
    protected transient boolean strictASCII = true;
    protected transient int m_oraCharLevel2Size = 0;

    public CharacterConverter1Byte() {
        this.m_groupId = 0;
    }

    int toUnicode(byte srcChar) throws SQLException {
        int ucsChar = this.m_ucsChar[srcChar & 0xFF];
        if (ucsChar == -1) {
            DatabaseError.throwSqlException(154);
            return -1;
        }
        return ucsChar;
    }

    int toUnicodeWithReplacement(byte srcChar) {
        int ucsChar = this.m_ucsChar[srcChar & 0xFF];
        if (ucsChar == -1) {
            return this.m_ucsReplacement;
        }
        return ucsChar;
    }

    byte toOracleCharacter(char srcChar, char lowSurrogate) throws SQLException {
        int l1Key = srcChar >>> 8 & 0xFF;
        int l2Key = srcChar & 0xFF;
        int l3Key = lowSurrogate >>> 8 & 0xFF;
        int l4Key = lowSurrogate & 0xFF;
        if (this.m_oraCharLevel1[l1Key] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key];
        }
        DatabaseError.throwSqlException(155);
        return 0;
    }

    byte toOracleCharacter(char srcChar) throws SQLException {
        int l3Key = srcChar >>> 8;
        int l4Key = srcChar & 0xFF;
        char ret = this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key];
        if (ret != '\uffff') {
            return (byte)ret;
        }
        DatabaseError.throwSqlException(155);
        return 0;
    }

    byte toOracleCharacterWithReplacement(char srcChar, char lowSurrogate) {
        int l1Key = srcChar >>> 8 & 0xFF;
        int l2Key = srcChar & 0xFF;
        int l3Key = lowSurrogate >>> 8 & 0xFF;
        int l4Key = lowSurrogate & 0xFF;
        if (this.m_oraCharLevel1[l1Key] != (char)this.m_oraCharLevel2Size && this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] != '\uffff' && this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] != '\uffff' && this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') {
            return (byte)this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key];
        }
        return this.m_oraCharReplacement;
    }

    byte toOracleCharacterWithReplacement(char srcChar) {
        int l3Key = srcChar >>> 8;
        int l4Key = srcChar & 0xFF;
        char ret = this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key];
        if (ret != '\uffff') {
            return (byte)ret;
        }
        return this.m_oraCharReplacement;
    }

    public String toUnicodeString(byte[] srcChar, int offset, int count) throws SQLException {
        int endPos = offset + count;
        StringBuffer ucsChars = new StringBuffer(count);
        int ucs2 = 0;
        for (int i = offset; i < endPos; ++i) {
            ucs2 = this.m_ucsChar[srcChar[i] & 0xFF];
            if (ucs2 == this.m_ucsReplacement) {
                DatabaseError.throwSqlException(154);
            }
            if (((long)ucs2 & 0xFFFFFFFFL) > 65535L) {
                ucsChars.append((char)(ucs2 >>> 16));
                ucsChars.append((char)(ucs2 & 0xFFFF));
                continue;
            }
            ucsChars.append((char)ucs2);
        }
        return ucsChars.toString();
    }

    public String toUnicodeStringWithReplacement(byte[] srcChar, int offset, int count) {
        int endPos = offset + count;
        StringBuffer ucsChars = new StringBuffer(count);
        int ucs2 = 0;
        for (int i = offset; i < endPos; ++i) {
            ucs2 = this.m_ucsChar[srcChar[i] & 0xFF];
            if (ucs2 == -1) {
                ucsChars.append((char)this.m_ucsReplacement);
                continue;
            }
            ucsChars.append((char)ucs2);
        }
        return ucsChars.toString();
    }

    public byte[] toOracleString(String srcString) throws SQLException {
        int srcLength = srcString.length();
        if (srcLength == 0) {
            return new byte[0];
        }
        char[] srcChars = new char[srcLength];
        srcString.getChars(0, srcLength, srcChars, 0);
        byte[] oracleChars = new byte[srcLength * 4];
        int oraCharIdx = 0;
        for (int i = 0; i < srcLength; ++i) {
            if (srcChars[i] >= '\ud800' && srcChars[i] < '\udc00') {
                if (i + 1 < srcLength && srcChars[i + 1] >= '\udc00' && srcChars[i + 1] <= '\udfff') {
                    if (this.noSurrogate) {
                        DatabaseError.throwSqlException(155);
                    } else {
                        oracleChars[oraCharIdx++] = this.toOracleCharacter(srcChars[i], srcChars[i + 1]);
                    }
                    ++i;
                    continue;
                }
                DatabaseError.throwSqlException(155);
                continue;
            }
            oracleChars[oraCharIdx++] = srcChars[i] < '\u0080' && this.strictASCII ? (byte)srcChars[i] : this.toOracleCharacter(srcChars[i]);
        }
        if (oraCharIdx < oracleChars.length) {
            byte[] returnArray = new byte[oraCharIdx];
            System.arraycopy(oracleChars, 0, returnArray, 0, oraCharIdx);
            return returnArray;
        }
        return oracleChars;
    }

    public byte[] toOracleStringWithReplacement(String srcString) {
        int srcLength = srcString.length();
        if (srcLength == 0) {
            return new byte[0];
        }
        char[] srcChars = new char[srcLength];
        srcString.getChars(0, srcLength, srcChars, 0);
        byte[] oracleChars = new byte[srcLength * 4];
        int oraCharIdx = 0;
        for (int i = 0; i < srcLength; ++i) {
            if (srcChars[i] >= '\ud800' && srcChars[i] < '\udc00') {
                if (i + 1 < srcLength && srcChars[i + 1] >= '\udc00' && srcChars[i + 1] <= '\udfff') {
                    oracleChars[oraCharIdx++] = this.noSurrogate ? this.m_oraCharReplacement : this.toOracleCharacterWithReplacement(srcChars[i], srcChars[i + 1]);
                    ++i;
                    continue;
                }
                oracleChars[oraCharIdx++] = this.m_oraCharReplacement;
                continue;
            }
            oracleChars[oraCharIdx++] = srcChars[i] < '\u0080' && this.strictASCII ? (byte)srcChars[i] : this.toOracleCharacterWithReplacement(srcChars[i]);
        }
        if (oraCharIdx < oracleChars.length) {
            byte[] returnArray = new byte[oraCharIdx];
            System.arraycopy(oracleChars, 0, returnArray, 0, oraCharIdx);
            return returnArray;
        }
        return oracleChars;
    }

    public void buildUnicodeToOracleMapping() {
        int l4Key;
        int l3Key;
        int l2Key;
        int l1Key;
        char[] range;
        Object key;
        int ucsCodePt;
        int i;
        this.m_oraCharLevel1 = new char[256];
        this.m_oraCharSurrogateLevel = null;
        this.m_oraCharLevel2 = null;
        Vector<int[]> mapStore = new Vector<int[]>(45055, 12287);
        Hashtable htable = new Hashtable();
        Hashtable htable2 = new Hashtable();
        int mapCount = this.m_ucsChar.length;
        char lev2Freeptr = '\u0000';
        char surLevFreeptr = '\u0000';
        for (i = 0; i < 256; ++i) {
            this.m_oraCharLevel1[i] = 65535;
        }
        for (i = 0; i < mapCount; ++i) {
            ucsCodePt = this.m_ucsChar[i];
            if (ucsCodePt == -1) continue;
            int[] store = new int[]{ucsCodePt, i};
            mapStore.addElement(store);
            this.storeMappingRange(ucsCodePt, htable, htable2);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            mapCount = this.extraUnicodeToOracleMapping.length;
            for (i = 0; i < mapCount; ++i) {
                ucsCodePt = this.extraUnicodeToOracleMapping[i][0];
                this.storeMappingRange(ucsCodePt, htable, htable2);
            }
        }
        Enumeration enumeration = htable.keys();
        int surLevSize = 0;
        int oraCharLevel2Size = 0;
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            range = (char[])htable.get(key);
            if (range == null) continue;
            surLevSize += 256;
        }
        enumeration = htable2.keys();
        while (enumeration.hasMoreElements()) {
            key = enumeration.nextElement();
            range = (char[])htable2.get(key);
            if (range == null) continue;
            oraCharLevel2Size += 256;
        }
        if (surLevSize != 0) {
            this.m_oraCharSurrogateLevel = new char[surLevSize];
        }
        if (oraCharLevel2Size != 0) {
            this.m_oraCharLevel2 = new char[oraCharLevel2Size + 256];
        }
        for (i = 0; i < surLevSize; ++i) {
            this.m_oraCharSurrogateLevel[i] = 65535;
        }
        for (i = 0; i < oraCharLevel2Size + 256; ++i) {
            this.m_oraCharLevel2[i] = 65535;
        }
        for (i = 0; i < mapStore.size(); ++i) {
            int[] store = (int[])mapStore.elementAt(i);
            l1Key = store[0] >> 24 & 0xFF;
            l2Key = store[0] >> 16 & 0xFF;
            l3Key = store[0] >> 8 & 0xFF;
            l4Key = store[0] & 0xFF;
            if (l1Key >= 216 && l1Key < 220) {
                if (this.m_oraCharLevel1[l1Key] == '\uffff') {
                    this.m_oraCharLevel1[l1Key] = surLevFreeptr;
                    surLevFreeptr = (char)(surLevFreeptr + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] = surLevFreeptr;
                    surLevFreeptr = (char)(surLevFreeptr + 256);
                }
                if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] == '\uffff') {
                    this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] = lev2Freeptr;
                    lev2Freeptr = (char)(lev2Freeptr + 256);
                }
                if (this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] != '\uffff') continue;
                this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] = (char)(store[1] & 0xFFFF);
                continue;
            }
            if (this.m_oraCharLevel1[l3Key] == '\uffff') {
                this.m_oraCharLevel1[l3Key] = lev2Freeptr;
                lev2Freeptr = (char)(lev2Freeptr + 256);
            }
            if (this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] != '\uffff') continue;
            this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] = (char)(store[1] & 0xFFFF);
        }
        if (this.extraUnicodeToOracleMapping != null) {
            mapCount = this.extraUnicodeToOracleMapping.length;
            for (i = 0; i < mapCount; ++i) {
                ucsCodePt = this.extraUnicodeToOracleMapping[i][0];
                l1Key = ucsCodePt >>> 24 & 0xFF;
                l2Key = ucsCodePt >>> 16 & 0xFF;
                l3Key = ucsCodePt >>> 8 & 0xFF;
                l4Key = ucsCodePt & 0xFF;
                if (l1Key >= 216 && l1Key < 220) {
                    if (this.m_oraCharLevel1[l1Key] == '\uffff') {
                        this.m_oraCharLevel1[l1Key] = surLevFreeptr;
                        surLevFreeptr = (char)(surLevFreeptr + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] = surLevFreeptr;
                        surLevFreeptr = (char)(surLevFreeptr + 256);
                    }
                    if (this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] == '\uffff') {
                        this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] = lev2Freeptr;
                        lev2Freeptr = (char)(lev2Freeptr + 256);
                    }
                    this.m_oraCharLevel2[this.m_oraCharSurrogateLevel[this.m_oraCharSurrogateLevel[this.m_oraCharLevel1[l1Key] + l2Key] + l3Key] + l4Key] = (char)(this.extraUnicodeToOracleMapping[i][1] & 0xFF);
                    continue;
                }
                if (this.m_oraCharLevel1[l3Key] == '\uffff') {
                    this.m_oraCharLevel1[l3Key] = lev2Freeptr;
                    lev2Freeptr = (char)(lev2Freeptr + 256);
                }
                this.m_oraCharLevel2[this.m_oraCharLevel1[l3Key] + l4Key] = (char)(this.extraUnicodeToOracleMapping[i][1] & 0xFFFF);
            }
        }
        this.noSurrogate = this.m_oraCharSurrogateLevel == null;
        this.strictASCII = true;
        for (i = 0; i < 128; ++i) {
            if (this.m_oraCharLevel2[i] == i) continue;
            this.strictASCII = false;
            break;
        }
        for (i = 0; i < 256; ++i) {
            if (this.m_oraCharLevel1[i] != '\uffff') continue;
            this.m_oraCharLevel1[i] = (char)oraCharLevel2Size;
        }
        this.m_oraCharLevel2Size = oraCharLevel2Size;
    }

    public void extractCodepoints(Vector vtable) {
        int begin = 0;
        int end = 255;
        for (int x = begin; x <= end; ++x) {
            try {
                int[] codepointPair = new int[]{x, this.toUnicode((byte)x)};
                vtable.addElement(codepointPair);
                continue;
            }
            catch (SQLException ex) {
                // empty catch block
            }
        }
    }

    public void extractExtraMappings(Vector vtable) {
        if (this.extraUnicodeToOracleMapping == null) {
            return;
        }
        for (int x = 0; x < this.extraUnicodeToOracleMapping.length; ++x) {
            int[] codepointPair = new int[]{this.extraUnicodeToOracleMapping[x][0], this.extraUnicodeToOracleMapping[x][1]};
            vtable.addElement(codepointPair);
        }
    }

    public boolean hasExtraMappings() {
        return this.extraUnicodeToOracleMapping != null;
    }

    public char getOraChar1ByteRep() {
        return (char)this.m_oraCharReplacement;
    }

    public char getOraChar2ByteRep() {
        return '\u0000';
    }

    public int getUCS2CharRep() {
        return this.m_ucsReplacement;
    }
}

