/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.quartz;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import javax.sql.DataSource;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SchedulerFactory;
import org.quartz.impl.RemoteScheduler;
import org.quartz.impl.SchedulerRepository;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.quartz.AdaptableJobFactory;
import org.springframework.scheduling.quartz.LocalDataSourceJobStore;
import org.springframework.scheduling.quartz.LocalTaskExecutorThreadPool;
import org.springframework.scheduling.quartz.ResourceLoaderClassLoadHelper;
import org.springframework.scheduling.quartz.SchedulerAccessor;
import org.springframework.scheduling.quartz.SchedulerContextAware;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SchedulerFactoryBean
extends SchedulerAccessor
implements FactoryBean<Scheduler>,
BeanNameAware,
ApplicationContextAware,
InitializingBean,
DisposableBean,
SmartLifecycle {
    public static final String PROP_THREAD_COUNT = "org.quartz.threadPool.threadCount";
    public static final int DEFAULT_THREAD_COUNT = 10;
    private static final ThreadLocal<ResourceLoader> configTimeResourceLoaderHolder = new ThreadLocal();
    private static final ThreadLocal<Executor> configTimeTaskExecutorHolder = new ThreadLocal();
    private static final ThreadLocal<DataSource> configTimeDataSourceHolder = new ThreadLocal();
    private static final ThreadLocal<DataSource> configTimeNonTransactionalDataSourceHolder = new ThreadLocal();
    private Class<? extends SchedulerFactory> schedulerFactoryClass = StdSchedulerFactory.class;
    private String schedulerName;
    private Resource configLocation;
    private Properties quartzProperties;
    private Executor taskExecutor;
    private DataSource dataSource;
    private DataSource nonTransactionalDataSource;
    private Map<String, ?> schedulerContextMap;
    private ApplicationContext applicationContext;
    private String applicationContextSchedulerContextKey;
    private JobFactory jobFactory;
    private boolean jobFactorySet = false;
    private boolean autoStartup = true;
    private int startupDelay = 0;
    private int phase = Integer.MAX_VALUE;
    private boolean exposeSchedulerInRepository = false;
    private boolean waitForJobsToCompleteOnShutdown = false;
    private Scheduler scheduler;

    public static ResourceLoader getConfigTimeResourceLoader() {
        return configTimeResourceLoaderHolder.get();
    }

    public static Executor getConfigTimeTaskExecutor() {
        return configTimeTaskExecutorHolder.get();
    }

    public static DataSource getConfigTimeDataSource() {
        return configTimeDataSourceHolder.get();
    }

    public static DataSource getConfigTimeNonTransactionalDataSource() {
        return configTimeNonTransactionalDataSourceHolder.get();
    }

    public void setSchedulerFactoryClass(Class<? extends SchedulerFactory> schedulerFactoryClass) {
        Assert.isAssignable(SchedulerFactory.class, schedulerFactoryClass);
        this.schedulerFactoryClass = schedulerFactoryClass;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setQuartzProperties(Properties quartzProperties) {
        this.quartzProperties = quartzProperties;
    }

    public void setTaskExecutor(Executor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setNonTransactionalDataSource(DataSource nonTransactionalDataSource) {
        this.nonTransactionalDataSource = nonTransactionalDataSource;
    }

    public void setSchedulerContextAsMap(Map<String, ?> schedulerContextAsMap) {
        this.schedulerContextMap = schedulerContextAsMap;
    }

    public void setApplicationContextSchedulerContextKey(String applicationContextSchedulerContextKey) {
        this.applicationContextSchedulerContextKey = applicationContextSchedulerContextKey;
    }

    public void setJobFactory(JobFactory jobFactory) {
        this.jobFactory = jobFactory;
        this.jobFactorySet = true;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setStartupDelay(int startupDelay) {
        this.startupDelay = startupDelay;
    }

    public void setExposeSchedulerInRepository(boolean exposeSchedulerInRepository) {
        this.exposeSchedulerInRepository = exposeSchedulerInRepository;
    }

    public void setWaitForJobsToCompleteOnShutdown(boolean waitForJobsToCompleteOnShutdown) {
        this.waitForJobsToCompleteOnShutdown = waitForJobsToCompleteOnShutdown;
    }

    public void setBeanName(String name) {
        if (this.schedulerName == null) {
            this.schedulerName = name;
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null && this.nonTransactionalDataSource != null) {
            this.dataSource = this.nonTransactionalDataSource;
        }
        if (this.applicationContext != null && this.resourceLoader == null) {
            this.resourceLoader = this.applicationContext;
        }
        SchedulerFactory schedulerFactory = (SchedulerFactory)BeanUtils.instantiateClass(this.schedulerFactoryClass);
        this.initSchedulerFactory(schedulerFactory);
        if (this.resourceLoader != null) {
            configTimeResourceLoaderHolder.set(this.resourceLoader);
        }
        if (this.taskExecutor != null) {
            configTimeTaskExecutorHolder.set(this.taskExecutor);
        }
        if (this.dataSource != null) {
            configTimeDataSourceHolder.set(this.dataSource);
        }
        if (this.nonTransactionalDataSource != null) {
            configTimeNonTransactionalDataSourceHolder.set(this.nonTransactionalDataSource);
        }
        try {
            this.scheduler = this.createScheduler(schedulerFactory, this.schedulerName);
            this.populateSchedulerContext();
            if (!this.jobFactorySet && !(this.scheduler instanceof RemoteScheduler)) {
                this.jobFactory = new AdaptableJobFactory();
            }
            if (this.jobFactory != null) {
                if (this.jobFactory instanceof SchedulerContextAware) {
                    ((SchedulerContextAware)this.jobFactory).setSchedulerContext(this.scheduler.getContext());
                }
                this.scheduler.setJobFactory(this.jobFactory);
            }
        }
        finally {
            if (this.resourceLoader != null) {
                configTimeResourceLoaderHolder.remove();
            }
            if (this.taskExecutor != null) {
                configTimeTaskExecutorHolder.remove();
            }
            if (this.dataSource != null) {
                configTimeDataSourceHolder.remove();
            }
            if (this.nonTransactionalDataSource != null) {
                configTimeNonTransactionalDataSourceHolder.remove();
            }
        }
        this.registerListeners();
        this.registerJobsAndTriggers();
    }

    private void initSchedulerFactory(SchedulerFactory schedulerFactory) throws SchedulerException, IOException {
        if (!(schedulerFactory instanceof StdSchedulerFactory)) {
            if (this.configLocation != null || this.quartzProperties != null || this.taskExecutor != null || this.dataSource != null) {
                throw new IllegalArgumentException("StdSchedulerFactory required for applying Quartz properties: " + schedulerFactory);
            }
            return;
        }
        Properties mergedProps = new Properties();
        if (this.resourceLoader != null) {
            mergedProps.setProperty("org.quartz.scheduler.classLoadHelper.class", ResourceLoaderClassLoadHelper.class.getName());
        }
        if (this.taskExecutor != null) {
            mergedProps.setProperty("org.quartz.threadPool.class", LocalTaskExecutorThreadPool.class.getName());
        } else {
            mergedProps.setProperty("org.quartz.threadPool.class", SimpleThreadPool.class.getName());
            mergedProps.setProperty(PROP_THREAD_COUNT, Integer.toString(10));
        }
        if (this.configLocation != null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Loading Quartz config from [" + this.configLocation + "]"));
            }
            PropertiesLoaderUtils.fillProperties((Properties)mergedProps, (Resource)this.configLocation);
        }
        CollectionUtils.mergePropertiesIntoMap((Properties)this.quartzProperties, (Map)mergedProps);
        if (this.dataSource != null) {
            mergedProps.put("org.quartz.jobStore.class", LocalDataSourceJobStore.class.getName());
        }
        if (this.schedulerName != null) {
            mergedProps.put("org.quartz.scheduler.instanceName", this.schedulerName);
        }
        ((StdSchedulerFactory)schedulerFactory).initialize(mergedProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Scheduler createScheduler(SchedulerFactory schedulerFactory, String schedulerName) throws SchedulerException {
        boolean overrideClassLoader;
        Thread currentThread = Thread.currentThread();
        ClassLoader threadContextClassLoader = currentThread.getContextClassLoader();
        boolean bl = overrideClassLoader = this.resourceLoader != null && !this.resourceLoader.getClassLoader().equals(threadContextClassLoader);
        if (overrideClassLoader) {
            currentThread.setContextClassLoader(this.resourceLoader.getClassLoader());
        }
        try {
            SchedulerRepository repository;
            SchedulerRepository schedulerRepository = repository = SchedulerRepository.getInstance();
            synchronized (schedulerRepository) {
                Scheduler existingScheduler = schedulerName != null ? repository.lookup(schedulerName) : null;
                Scheduler newScheduler = schedulerFactory.getScheduler();
                if (newScheduler == existingScheduler) {
                    throw new IllegalStateException("Active Scheduler of name '" + schedulerName + "' already registered " + "in Quartz SchedulerRepository. Cannot create a new Spring-managed Scheduler of the same name!");
                }
                if (!this.exposeSchedulerInRepository) {
                    SchedulerRepository.getInstance().remove(newScheduler.getSchedulerName());
                }
                Scheduler scheduler = newScheduler;
                return scheduler;
            }
        }
        finally {
            if (overrideClassLoader) {
                currentThread.setContextClassLoader(threadContextClassLoader);
            }
        }
    }

    private void populateSchedulerContext() throws SchedulerException {
        if (this.schedulerContextMap != null) {
            this.scheduler.getContext().putAll(this.schedulerContextMap);
        }
        if (this.applicationContextSchedulerContextKey != null) {
            if (this.applicationContext == null) {
                throw new IllegalStateException("SchedulerFactoryBean needs to be set up in an ApplicationContext to be able to handle an 'applicationContextSchedulerContextKey'");
            }
            this.scheduler.getContext().put((Object)this.applicationContextSchedulerContextKey, (Object)this.applicationContext);
        }
    }

    protected void startScheduler(final Scheduler scheduler, final int startupDelay) throws SchedulerException {
        if (startupDelay <= 0) {
            this.logger.info((Object)"Starting Quartz Scheduler now");
            scheduler.start();
        } else {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Will start Quartz Scheduler [" + scheduler.getSchedulerName() + "] in " + startupDelay + " seconds"));
            }
            Thread schedulerThread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(startupDelay * 1000);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (SchedulerFactoryBean.this.logger.isInfoEnabled()) {
                        SchedulerFactoryBean.this.logger.info((Object)("Starting Quartz Scheduler now, after delay of " + startupDelay + " seconds"));
                    }
                    try {
                        scheduler.start();
                    }
                    catch (SchedulerException ex) {
                        throw new SchedulingException("Could not start Quartz Scheduler after delay", (Throwable)ex);
                    }
                }
            };
            schedulerThread.setName("Quartz Scheduler [" + scheduler.getSchedulerName() + "]");
            schedulerThread.setDaemon(true);
            schedulerThread.start();
        }
    }

    @Override
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public Scheduler getObject() {
        return this.scheduler;
    }

    public Class<? extends Scheduler> getObjectType() {
        return this.scheduler != null ? this.scheduler.getClass() : Scheduler.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                this.startScheduler(this.scheduler, this.startupDelay);
            }
            catch (SchedulerException ex) {
                throw new SchedulingException("Could not start Quartz Scheduler", (Throwable)ex);
            }
        }
    }

    public void stop() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                this.scheduler.standby();
            }
            catch (SchedulerException ex) {
                throw new SchedulingException("Could not stop Quartz Scheduler", (Throwable)ex);
            }
        }
    }

    public void stop(Runnable callback) throws SchedulingException {
        this.stop();
        callback.run();
    }

    public boolean isRunning() throws SchedulingException {
        if (this.scheduler != null) {
            try {
                return !this.scheduler.isInStandbyMode();
            }
            catch (SchedulerException ex) {
                return false;
            }
        }
        return false;
    }

    public void destroy() throws SchedulerException {
        this.logger.info((Object)"Shutting down Quartz Scheduler");
        this.scheduler.shutdown(this.waitForJobsToCompleteOnShutdown);
    }
}

