/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.query.AbstractStringBasedJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;

final class SimpleJpaQuery
extends AbstractStringBasedJpaQuery {
    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em) {
        this(method, em, method.getAnnotatedQuery());
    }

    public SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString) {
        super(method, em, queryString);
        this.validateQuery(this.getQuery().getQueryString(), String.format("Validation failed for query for method %s!", new Object[]{method}));
        if (method.isPageQuery()) {
            this.validateQuery(this.getCountQuery().getQueryString(), String.format("Count query validation failed for method %s!", new Object[]{method}));
        }
    }

    private final void validateQuery(String query, String errorMessage) {
        if (this.getQueryMethod().isProcedureQuery()) {
            return;
        }
        EntityManager validatingEm = null;
        try {
            validatingEm = this.getEntityManager().getEntityManagerFactory().createEntityManager();
            validatingEm.createQuery(query);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException(errorMessage, e);
        }
        finally {
            if (validatingEm != null) {
                validatingEm.close();
            }
        }
    }
}

