/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PrefixMethodInvocationUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PrefixMethodInvocationUtil.class);
    private static final String DEFAULT_INVOCATION_METHODNAME = "execute";
    private static final Class[] EMPTY_CLASS_ARRAY = new Class[0];

    public static void invokePrefixMethod(ActionInvocation actionInvocation, String[] prefixes) throws InvocationTargetException, IllegalAccessException {
        Method method;
        Object action = actionInvocation.getAction();
        String methodName = actionInvocation.getProxy().getMethod();
        if (methodName == null) {
            methodName = DEFAULT_INVOCATION_METHODNAME;
        }
        if ((method = PrefixMethodInvocationUtil.getPrefixedMethod(prefixes, methodName, action)) != null) {
            method.invoke(action, new Object[0]);
        }
    }

    public static Method getPrefixedMethod(String[] prefixes, String methodName, Object action) {
        assert (prefixes != null);
        String capitalizedMethodName = PrefixMethodInvocationUtil.capitalizeMethodName(methodName);
        for (String prefixe : prefixes) {
            String prefixedMethodName = prefixe + capitalizedMethodName;
            try {
                return action.getClass().getMethod(prefixedMethodName, EMPTY_CLASS_ARRAY);
            }
            catch (NoSuchMethodException e) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("cannot find method [#0] in action [#1]", prefixedMethodName, action.toString());
            }
        }
        return null;
    }

    public static String capitalizeMethodName(String methodName) {
        assert (methodName != null);
        return methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
    }
}

