/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util.profiling;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ProfilingTimerBean
implements Serializable {
    private static final long serialVersionUID = -6180672043920208784L;
    List<ProfilingTimerBean> children = new ArrayList<ProfilingTimerBean>();
    ProfilingTimerBean parent = null;
    String resource;
    long startTime;
    long totalTime;

    public ProfilingTimerBean(String resource) {
        this.resource = resource;
    }

    protected void addParent(ProfilingTimerBean parent) {
        this.parent = parent;
    }

    public ProfilingTimerBean getParent() {
        return this.parent;
    }

    public void addChild(ProfilingTimerBean child) {
        this.children.add(child);
        child.addParent(this);
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void setEndTime() {
        this.totalTime = System.currentTimeMillis() - this.startTime;
    }

    public String getResource() {
        return this.resource;
    }

    public String getPrintable(long minTime) {
        return this.getPrintable("", minTime);
    }

    protected String getPrintable(String indent, long minTime) {
        if (this.totalTime >= minTime) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(indent);
            buffer.append("[" + this.totalTime + "ms] - " + this.resource);
            buffer.append("\n");
            for (ProfilingTimerBean aChildren : this.children) {
                buffer.append(aChildren.getPrintable(indent + "  ", minTime));
            }
            return buffer.toString();
        }
        return "";
    }
}

