/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.openplatform.service;

import com.yihu.openplatform.service.AppKeyService;
import com.yihu.openplatform.service.UrlCheck;
import com.yihu.openplatform.utils.DictConfigUtil;
import com.yihu.openplatform.utils.MsgCrypt;
import com.yihu.wsgw.api.ServiceBus;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class SignAndPost
implements Runnable {
    private Map<String, String> oriParamMap = null;
    private String encryptType = null;
    private String url;
    private String appId;
    private String secret;
    private String httpResponseText;

    public String getHttpResponseText() {
        return this.httpResponseText;
    }

    public SignAndPost(String url, String appId, String secret, Map<String, String> oriParamMap, String encryptType) {
        this.oriParamMap = oriParamMap;
        this.encryptType = encryptType;
        this.url = url;
        this.appId = appId;
        this.secret = secret;
    }

    public static String pushMsg(String encryptType, String url, String appId, String secret, Map<String, String> oriParamMap, String sourceAppId) throws Exception {
        String result = "";
        if (url != null && url.startsWith("api://")) {
            String apiName = url.substring("api://".length());
            JSONObject jsonParam = JSONObject.fromObject(oriParamMap);
            result = ServiceBus.getInstance((String)DictConfigUtil.getInstance().getCenterServerUrl().toString(), (String)sourceAppId).call(apiName, jsonParam.toString());
        } else {
            result = encryptType != null && "AES".equals(encryptType) ? SignAndPost.aesPost(url, appId, secret, oriParamMap) : SignAndPost.plaintPost(url, appId, secret, oriParamMap);
        }
        return result;
    }

    public static String plaintPost(String url, String appId, String secret, Map<String, String> oriParamMap) throws Exception {
        String timestamp = Long.toString(System.currentTimeMillis());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(oriParamMap);
        paramMap.remove("appId");
        paramMap.remove("sign");
        paramMap.remove("timestamp");
        String newUrl = url;
        if (url.indexOf("?") > 0) {
            newUrl = url.substring(0, url.indexOf("?"));
            String[] otherParams = url.substring(url.indexOf("?") + 1).split("&");
            int i = 0;
            while (i < otherParams.length) {
                String[] pam = otherParams[i].split("=");
                if (pam.length == 2) {
                    paramMap.put(pam[0], pam[1]);
                }
                ++i;
            }
        }
        if ("9000038".equals(appId)) {
            paramMap.put("verifyToken", SignAndPost.MD5(String.valueOf(String.valueOf(System.currentTimeMillis() / 100000L)) + "KnB2I2lkbioo"));
        }
        paramMap.put("timestamp", timestamp);
        StringBuilder stringBuilder = new StringBuilder();
        Object[] keyArray = paramMap.keySet().toArray(new String[0]);
        Arrays.sort(keyArray);
        stringBuilder.append(appId);
        Object[] objectArray = keyArray;
        int n = keyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            stringBuilder.append((String)key).append((String)paramMap.get(key));
            ++n2;
        }
        String codes = stringBuilder.append(secret).toString();
        DigestUtils.sha1Hex((String)"1");
        String sign = DigestUtils.shaHex((String)codes).toUpperCase();
        paramMap.put("appId", appId);
        paramMap.put("sign", sign);
        String rep = "";
        try {
            rep = SignAndPost.httpPost(newUrl, paramMap);
            UrlCheck.removeErrorUrl(url);
        }
        catch (Exception e) {
            UrlCheck.addUrlErrorNum(url);
            throw e;
        }
        return rep;
    }

    public static String aesPost(String url, String appId, String encodingAesKey, Map<String, String> oriParamMap) throws Exception {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(oriParamMap);
        paramMap.remove("appId");
        paramMap.remove("sign");
        paramMap.remove("timestamp");
        String newUrl = url;
        if (url.indexOf("?") > 0) {
            newUrl = url.substring(0, url.indexOf("?"));
            String[] otherParams = url.substring(url.indexOf("?") + 1).split("&");
            int i = 0;
            while (i < otherParams.length) {
                String[] pam = otherParams[i].split("=");
                if (pam.length == 2) {
                    paramMap.put(pam[0], pam[1]);
                }
                ++i;
            }
        }
        if ("9000038".equals(appId)) {
            paramMap.put("verifyToken", SignAndPost.MD5(String.valueOf(String.valueOf(System.currentTimeMillis() / 100000L)) + "KnB2I2lkbioo"));
        }
        JSONObject jsonParam = new JSONObject();
        jsonParam.putAll(paramMap);
        String replyMsg = jsonParam.toString();
        String timestamp = Long.toString(System.currentTimeMillis());
        MsgCrypt pc = new MsgCrypt(encodingAesKey, appId);
        Map<String, String> miwen = pc.encryptMsg(replyMsg, timestamp);
        String encrypt = miwen.get("encrypt");
        String sign = miwen.get("sign");
        String result2 = "";
        if (AppKeyService.isDebug) {
            System.out.println(miwen);
        }
        String rep = "";
        try {
            rep = SignAndPost.httpPost(newUrl, miwen);
            UrlCheck.removeErrorUrl(url);
        }
        catch (Exception e) {
            UrlCheck.addUrlErrorNum(url);
            throw e;
        }
        JSONObject jsonRep = JSONObject.fromObject((Object)rep);
        sign = jsonRep.getString("sign");
        encrypt = jsonRep.getString("encrypt");
        timestamp = jsonRep.getString("timestamp");
        result2 = pc.decryptMsg(sign, timestamp, encrypt);
        return result2;
    }

    public static String httpPost(String url, Map<String, String> params) throws Exception {
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            String string;
            HttpPost httpPost = new HttpPost(url);
            RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(10000).setConnectTimeout(10000).build();
            httpPost.setConfig(requestConfig);
            if (params != null && params.size() > 0) {
                ArrayList<BasicNameValuePair> valuePairs = new ArrayList<BasicNameValuePair>(params.size());
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    BasicNameValuePair nameValuePair = new BasicNameValuePair(entry.getKey(), String.valueOf(entry.getValue()));
                    valuePairs.add(nameValuePair);
                }
                UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(valuePairs, "UTF-8");
                httpPost.setEntity((HttpEntity)formEntity);
            }
            CloseableHttpResponse resp = httpclient.execute((HttpUriRequest)httpPost);
            try {
                String respContent;
                HttpEntity entity = resp.getEntity();
                string = respContent = EntityUtils.toString((HttpEntity)entity, (String)"UTF-8").trim();
            }
            catch (Throwable throwable) {
                resp.close();
                throw throwable;
            }
            resp.close();
            return string;
        }
        finally {
            httpclient.close();
        }
    }

    @Override
    public void run() {
        int i = 0;
        while (i < AppKeyService.tryTime) {
            try {
                String result = null;
                result = this.encryptType != null && this.encryptType.equals("AES") ? SignAndPost.aesPost(this.url, this.appId, this.secret, this.oriParamMap) : SignAndPost.plaintPost(this.url, this.appId, this.secret, this.oriParamMap);
                if (this.httpResponseText == null) {
                    this.httpResponseText = result;
                    break;
                }
                if (AppKeyService.isDebug) {
                    System.out.println(result);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public static final String MD5(String s) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        try {
            byte[] btInput = s.getBytes();
            MessageDigest mdInst = MessageDigest.getInstance("MD5");
            mdInst.update(btInput);
            byte[] md = mdInst.digest();
            int j = md.length;
            char[] str = new char[j * 2];
            int k = 0;
            int i = 0;
            while (i < j) {
                byte byte0 = md[i];
                str[k++] = hexDigits[byte0 >>> 4 & 0xF];
                str[k++] = hexDigits[byte0 & 0xF];
                ++i;
            }
            return new String(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

