/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.service.NodeService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesStatsAction
extends TransportNodesAction<NodesStatsRequest, NodesStatsResponse, NodeStatsRequest, NodeStats> {
    private final NodeService nodeService;

    @Inject
    public TransportNodesStatsAction(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, NodeService nodeService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/nodes/stats", clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, NodesStatsRequest.class, NodeStatsRequest.class, "management");
        this.nodeService = nodeService;
    }

    @Override
    protected NodesStatsResponse newResponse(NodesStatsRequest nodesInfoRequest, AtomicReferenceArray responses) {
        ArrayList<NodeStats> nodeStats = new ArrayList<NodeStats>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (!(resp instanceof NodeStats)) continue;
            nodeStats.add((NodeStats)resp);
        }
        return new NodesStatsResponse(this.clusterName, nodeStats.toArray(new NodeStats[nodeStats.size()]));
    }

    @Override
    protected NodeStatsRequest newNodeRequest(String nodeId, NodesStatsRequest request) {
        return new NodeStatsRequest(nodeId, request);
    }

    @Override
    protected NodeStats newNodeResponse() {
        return new NodeStats();
    }

    @Override
    protected NodeStats nodeOperation(NodeStatsRequest nodeStatsRequest) {
        NodesStatsRequest request = nodeStatsRequest.request;
        return this.nodeService.stats(request.indices(), request.os(), request.process(), request.jvm(), request.threadPool(), request.fs(), request.transport(), request.http(), request.breaker(), request.script());
    }

    @Override
    protected boolean accumulateExceptions() {
        return false;
    }

    public static class NodeStatsRequest
    extends BaseNodeRequest {
        NodesStatsRequest request;

        public NodeStatsRequest() {
        }

        NodeStatsRequest(String nodeId, NodesStatsRequest request) {
            super(request, nodeId);
            this.request = request;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new NodesStatsRequest();
            this.request.readFrom(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

