/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.standard.ClassicTokenizer;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.assistedinject.Assisted;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.analysis.AbstractTokenizerFactory;
import org.elasticsearch.index.settings.IndexSettingsService;

public class ClassicTokenizerFactory
extends AbstractTokenizerFactory {
    private final int maxTokenLength;

    @Inject
    public ClassicTokenizerFactory(Index index, IndexSettingsService indexSettingsService, @Assisted String name, @Assisted Settings settings) {
        super(index, indexSettingsService.getSettings(), name, settings);
        this.maxTokenLength = settings.getAsInt("max_token_length", (Integer)255);
    }

    @Override
    public Tokenizer create() {
        ClassicTokenizer tokenizer = new ClassicTokenizer();
        tokenizer.setMaxTokenLength(this.maxTokenLength);
        return tokenizer;
    }
}

