/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.profile;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class ProfileBreakdown {
    private final long[] timings = new long[TimingType.values().length];
    private TimingType currentTimingType;
    private long scratch;

    public void startTime(TimingType timing) {
        assert (this.currentTimingType == null);
        assert (this.scratch == 0L);
        this.currentTimingType = timing;
        this.scratch = System.nanoTime();
    }

    public long stopAndRecordTime() {
        long time = Math.max(1L, System.nanoTime() - this.scratch);
        int n = this.currentTimingType.ordinal();
        this.timings[n] = this.timings[n] + time;
        this.currentTimingType = null;
        this.scratch = 0L;
        return time;
    }

    public Map<String, Long> toTimingMap() {
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (TimingType timingType : TimingType.values()) {
            map.put(timingType.toString(), this.timings[timingType.ordinal()]);
        }
        return Collections.unmodifiableMap(map);
    }

    public void merge(ProfileBreakdown other) {
        assert (this.timings.length == other.timings.length);
        for (int i = 0; i < this.timings.length; ++i) {
            int n = i;
            this.timings[n] = this.timings[n] + other.timings[i];
        }
    }

    public static enum TimingType {
        CREATE_WEIGHT,
        BUILD_SCORER,
        NEXT_DOC,
        ADVANCE,
        MATCH,
        SCORE;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

