/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.connector;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.EISSystemException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.SecurityException;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.sql.DataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import oracle.jdbc.connector.OracleConnectionRequestInfo;
import oracle.jdbc.connector.OracleManagedConnection;
import oracle.jdbc.driver.OracleLog;

public class OracleManagedConnectionFactory
implements ManagedConnectionFactory {
    private XADataSource xaDataSource = null;
    private String xaDataSourceName = null;
    private static final String RAERR_MCF_SET_XADS = "invalid xads";
    private static final String RAERR_MCF_GET_PCRED = "no password credential";
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:57_PDT_2005";
    static /* synthetic */ Class class$javax$resource$spi$security$PasswordCredential;

    public OracleManagedConnectionFactory() throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.OracleManagedConnectionFactory()", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public OracleManagedConnectionFactory(XADataSource xads) throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.OracleManagedConnectionFactory(xads = " + xads + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.xaDataSource = xads;
        this.xaDataSourceName = "XADataSource";
    }

    public void setXADataSourceName(String xadsName) {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.setXADataSourceName(xadsName = " + xadsName + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.xaDataSourceName = xadsName;
    }

    public String getXADataSourceName() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.getXADataSourceName() returns: " + this.xaDataSourceName, this);
            OracleLog.recursiveTrace = false;
        }
        return this.xaDataSourceName;
    }

    public Object createConnectionFactory(ConnectionManager cxManager) throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.createConnectionFactory(cxManager = " + cxManager + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (this.xaDataSource == null) {
            this.setupXADataSource();
        }
        return (DataSource)((Object)this.xaDataSource);
    }

    public Object createConnectionFactory() throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.createConnectionFactory()", this);
            OracleLog.recursiveTrace = false;
        }
        return this.createConnectionFactory(null);
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.createManagedConnection(subject = " + subject + ", cxRequestInfo = " + cxRequestInfo + ")", this);
            OracleLog.recursiveTrace = false;
        }
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            XAConnection xaconn = null;
            PasswordCredential pcred = this.getPasswordCredential(subject, cxRequestInfo);
            xaconn = pcred == null ? this.xaDataSource.getXAConnection() : this.xaDataSource.getXAConnection(pcred.getUserName(), new String(pcred.getPassword()));
            OracleManagedConnection omc = new OracleManagedConnection(xaconn);
            omc.setPasswordCredential(pcred);
            omc.setLogWriter(this.getLogWriter());
            return omc;
        }
        catch (SQLException exc) {
            EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
            rexc.setLinkedException((Exception)exc);
            throw rexc;
        }
    }

    public ManagedConnection matchManagedConnections(Set connectionSet, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.matchManagedConnection(connectionSet = " + connectionSet + ", subject = " + subject + ", cxRequestInfo = " + cxRequestInfo + ")", this);
            OracleLog.recursiveTrace = false;
        }
        PasswordCredential pcred = this.getPasswordCredential(subject, cxRequestInfo);
        Iterator iter = connectionSet.iterator();
        while (iter.hasNext()) {
            OracleManagedConnection omc;
            Object obj = iter.next();
            if (!(obj instanceof OracleManagedConnection) || !(omc = (OracleManagedConnection)obj).getPasswordCredential().equals((Object)pcred)) continue;
            return omc;
        }
        return null;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.setLogWriter(out = " + out + ")", this);
            OracleLog.recursiveTrace = false;
        }
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            this.xaDataSource.setLogWriter(out);
        }
        catch (SQLException exc) {
            EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
            rexc.setLinkedException((Exception)exc);
            throw rexc;
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.INFO, "OracleManagedConnectionFactory.getLogWriter()", this);
            OracleLog.recursiveTrace = false;
        }
        try {
            if (this.xaDataSource == null) {
                this.setupXADataSource();
            }
            return this.xaDataSource.getLogWriter();
        }
        catch (SQLException exc) {
            EISSystemException rexc = new EISSystemException("SQLException: " + exc.getMessage());
            rexc.setLinkedException((Exception)exc);
            throw rexc;
        }
    }

    private void setupXADataSource() throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleManagedConnectionFactory.setupXADataSource()", this);
            OracleLog.recursiveTrace = false;
        }
        try {
            XADataSource xads;
            InitialContext ic = null;
            try {
                Properties props = System.getProperties();
                ic = new InitialContext(props);
            }
            catch (java.lang.SecurityException exc) {
                // empty catch block
            }
            if (ic == null) {
                ic = new InitialContext();
            }
            if ((xads = (XADataSource)ic.lookup(this.xaDataSourceName)) == null) {
                throw new ResourceAdapterInternalException("Invalid XADataSource object");
            }
            this.xaDataSource = xads;
        }
        catch (NamingException exc) {
            ResourceException rexc = new ResourceException("NamingException: " + exc.getMessage());
            rexc.setLinkedException((Exception)exc);
            throw rexc;
        }
    }

    private PasswordCredential getPasswordCredential(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "OracleManagedConnectionFactory.getPasswordCredential(subject = " + subject + ", cxRequestInfo = " + cxRequestInfo + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (subject != null) {
            Set creds = subject.getPrivateCredentials(class$javax$resource$spi$security$PasswordCredential == null ? (class$javax$resource$spi$security$PasswordCredential = OracleManagedConnectionFactory.class$("javax.resource.spi.security.PasswordCredential")) : class$javax$resource$spi$security$PasswordCredential);
            Iterator iter = creds.iterator();
            while (iter.hasNext()) {
                PasswordCredential pcred = (PasswordCredential)iter.next();
                if (!pcred.getManagedConnectionFactory().equals(this)) continue;
                return pcred;
            }
            throw new SecurityException("Can not find user/password information", RAERR_MCF_GET_PCRED);
        }
        if (cxRequestInfo == null) {
            return null;
        }
        OracleConnectionRequestInfo info = (OracleConnectionRequestInfo)cxRequestInfo;
        PasswordCredential pcred = new PasswordCredential(info.getUser(), info.getPassword().toCharArray());
        pcred.setManagedConnectionFactory((ManagedConnectionFactory)this);
        return pcred;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.connector.OracleManagedConnectionFactory"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

