/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleBlobInputStream;
import oracle.jdbc.driver.OracleBlobOutputStream;
import oracle.jdbc.driver.OracleClobInputStream;
import oracle.jdbc.driver.OracleClobOutputStream;
import oracle.jdbc.driver.OracleClobReader;
import oracle.jdbc.driver.OracleClobWriter;
import oracle.jdbc.driver.OracleConversionInputStream;
import oracle.jdbc.driver.OracleConversionReader;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CError;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.pool.OracleOCIConnectionPool;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.ClobDBAccess;
import oracle.sql.LobPlsqlUtil;
import oracle.sql.SQLName;
import oracle.sql.converter.CharacterSetMetaData;

public class T2CConnection
extends PhysicalConnection
implements BfileDBAccess,
BlobDBAccess,
ClobDBAccess {
    short[] queryMetaData1 = null;
    byte[] queryMetaData2 = null;
    int queryMetaData1Offset = 0;
    int queryMetaData2Offset = 0;
    private String password;
    int fatalErrorNumber = 0;
    String fatalErrorMessage = null;
    static final int QMD_dbtype = 0;
    static final int QMD_dbsize = 1;
    static final int QMD_nullok = 2;
    static final int QMD_precision = 3;
    static final int QMD_scale = 4;
    static final int QMD_formOfUse = 5;
    static final int QMD_columnNameLength = 6;
    static final int QMD_tdo0 = 7;
    static final int QMD_tdo1 = 8;
    static final int QMD_tdo2 = 9;
    static final int QMD_tdo3 = 10;
    static final int QMD_charLength = 11;
    static final int QMD_typeNameLength = 12;
    static final int T2C_LOCATOR_MAX_LEN = 16;
    static final int T2C_LINEARIZED_LOCATOR_MAX_LEN = 4000;
    static final int T2C_LINEARIZED_BFILE_LOCATOR_MAX_LEN = 530;
    static final int METADATA1_INDICES_PER_COLUMN = 13;
    protected static final int SIZEOF_QUERYMETADATA2 = 8;
    int queryMetaData1Size = 100;
    int queryMetaData2Size = 800;
    long m_nativeState;
    short m_clientCharacterSet;
    byte byteAlign;
    private static final int EOJ_SUCCESS = 0;
    private static final int EOJ_ERROR = -1;
    private static final int EOJ_WARNING = 1;
    private static final String OCILIBRARY = "ocijdbc10";
    private int logon_mode = 0;
    static final int LOGON_MODE_DEFAULT = 0;
    static final int LOGON_MODE_SYSDBA = 2;
    static final int LOGON_MODE_SYSOPER = 4;
    static final int LOGON_MODE_CONNECTION_POOL = 5;
    static final int LOGON_MODE_CONNPOOL_CONNECTION = 6;
    static final int LOGON_MODE_CONNPOOL_PROXY_CONNECTION = 7;
    static final int LOGON_MODE_CONNPOOL_ALIASED_CONNECTION = 8;
    static final int T2C_PROXYTYPE_NONE = 0;
    static final int T2C_PROXYTYPE_USER_NAME = 1;
    static final int T2C_PROXYTYPE_DISTINGUISHED_NAME = 2;
    static final int T2C_PROXYTYPE_CERTIFICATE = 3;
    private static boolean isLibraryLoaded;
    OracleOCIFailover appCallback = null;
    Object appCallbackObject = null;
    private Properties nativeInfo;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_;
    public static boolean TRACE;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jun_22_11:30:52_PDT_2005";
    static /* synthetic */ Class class$oracle$jdbc$driver$T2CConnection;

    protected T2CConnection(String ur, String us, String p, String db, Properties info, OracleDriverExtension ext) throws SQLException {
        super(ur, us, p, db, info, ext);
        this.initialize();
    }

    final void initializePassword(String p) throws SQLException {
        this.password = p;
    }

    protected void initialize() {
        this.allocQueryMetaDataBuffers();
    }

    private void allocQueryMetaDataBuffers() {
        this.queryMetaData1Offset = 0;
        this.queryMetaData1 = new short[this.queryMetaData1Size * 13];
        this.queryMetaData2Offset = 0;
        this.queryMetaData2 = new byte[this.queryMetaData2Size];
        this.namedTypeAccessorByteLen = 0;
        this.refTypeAccessorByteLen = 0;
    }

    void reallocateQueryMetaData(int numColumns, int charSize) {
        this.queryMetaData1 = null;
        this.queryMetaData2 = null;
        this.queryMetaData1Size = Math.max(numColumns, this.queryMetaData1Size);
        this.queryMetaData2Size = Math.max(charSize, this.queryMetaData2Size);
        this.allocQueryMetaDataBuffers();
    }

    protected void logon() throws SQLException {
        if (this.database == null) {
            DatabaseError.throwSqlException(64);
        }
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(this.connectionProperties);
        }
        if (this.connectionProperties.getProperty("is_connection_pooling") == "true") {
            this.processOCIConnectionPooling();
        } else {
            String envString;
            long OCISvcCtxHandle = 0L;
            long OCIEnvHandle = 0L;
            long OCIErrHandle = 0L;
            String svcCtxString = this.connectionProperties.getProperty("OCISvcCtxHandle");
            if (svcCtxString != null && (envString = this.connectionProperties.getProperty("OCIEnvHandle")) != null) {
                String sDriverCharSetId;
                OCISvcCtxHandle = Long.parseLong(svcCtxString);
                OCIEnvHandle = Long.parseLong(envString);
                String errString = this.connectionProperties.getProperty("OCIErrHandle");
                if (errString != null) {
                    OCIErrHandle = Long.parseLong(errString);
                }
                if ((sDriverCharSetId = this.connectionProperties.getProperty("JDBCDriverCharSetId")) != null) {
                    this.m_clientCharacterSet = new Integer(sDriverCharSetId).shortValue();
                } else {
                    DatabaseError.throwSqlException(89);
                }
                this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
                short[] csids = new short[3];
                this.sqlWarning = this.checkError(this.t2cUseConnection(this.m_nativeState, OCIEnvHandle, OCISvcCtxHandle, OCIErrHandle, csids), this.sqlWarning);
                this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
                this.byteAlign = (byte)(csids[2] & 0xFF);
                return;
            }
            String mode = this.connectionProperties.getProperty("internal_logon");
            if (mode == null) {
                this.logon_mode = 0;
            } else if (mode.equalsIgnoreCase("SYSDBA")) {
                this.logon_mode = 2;
            } else if (mode.equalsIgnoreCase("SYSOPER")) {
                this.logon_mode = 4;
            }
            String propNlsLangBackdoor = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            byte[] l_userName = null;
            byte[] l_password = null;
            String newPassword = null;
            byte[] newPasswordBytes = new byte[]{};
            if (this.connectionProperties != null) {
                newPassword = (String)this.connectionProperties.get("OCINewPassword");
            }
            this.m_clientCharacterSet = propNlsLangBackdoor != null && propNlsLangBackdoor.equalsIgnoreCase("true") ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.connectionProperties) : T2CConnection.getClientCharSetId();
            if (newPassword != null) {
                newPasswordBytes = DBConversion.stringToAsciiBytes(newPassword);
            }
            l_userName = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            l_password = this.password == null ? new byte[]{} : DBConversion.stringToAsciiBytes(this.password);
            byte[] l_database = DBConversion.stringToAsciiBytes(this.database);
            short[] csids = new short[3];
            byte[] nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
            byte[] nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.m_nativeState == 0L ? this.checkError(this.t2cCreateState(l_userName, l_userName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, csids, nlslanguage, nlsterritory), this.sqlWarning) : this.checkError(this.t2cLogon(this.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, newPasswordBytes, newPasswordBytes.length, l_database, l_database.length, this.logon_mode, csids, nlslanguage, nlsterritory), this.sqlWarning);
            this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
            this.byteAlign = (byte)(csids[2] & 0xFF);
        }
    }

    protected void logoff() throws SQLException {
        block3: {
            try {
                if (this.m_nativeState != 0L) {
                    this.checkError(this.t2cLogoff(this.m_nativeState));
                }
            }
            catch (NullPointerException ea) {
                if (!TRACE || OracleLog.recursiveTrace) break block3;
                OracleLog.recursiveTrace = true;
                OracleLog.driverLogger.log(Level.FINE, "T2CConnection.logoff() got NullPointerException, " + ea, this);
                OracleLog.recursiveTrace = false;
            }
        }
    }

    public void open(OracleStatement stmt) throws SQLException {
        byte[] l_sqlString = stmt.sqlObject.getSql(stmt.processEscapes, stmt.convertNcharLiterals).getBytes();
        this.checkError(this.t2cCreateStatement(this.m_nativeState, 0L, l_sqlString, l_sqlString.length, stmt, false, stmt.rowPrefetch));
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "T2CConnection.open(" + stmt + "), c_state = 0x" + Long.toString(stmt.c_state, 16), this);
            OracleLog.recursiveTrace = false;
        }
    }

    void doCancel() throws SQLException {
        this.checkError(this.t2cCancel(this.m_nativeState));
    }

    native int t2cAbort(long var1);

    void doAbort() throws SQLException {
        this.checkError(this.t2cAbort(this.m_nativeState));
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.doAbort", this);
            OracleLog.recursiveTrace = false;
        }
    }

    protected void doSetAutoCommit(boolean autoCommit) throws SQLException {
        this.checkError(this.t2cSetAutoCommit(this.m_nativeState, autoCommit));
    }

    protected void doCommit() throws SQLException {
        this.checkError(this.t2cCommit(this.m_nativeState));
    }

    protected void doRollback() throws SQLException {
        this.checkError(this.t2cRollback(this.m_nativeState));
    }

    protected String doGetDatabaseProductVersion() throws SQLException {
        byte[] l_version = this.t2cGetProductionVersion(this.m_nativeState);
        return this.conversion.CharBytesToString(l_version, l_version.length);
    }

    protected short doGetVersionNumber() throws SQLException {
        short version_num = 0;
        try {
            String ver_str = this.doGetDatabaseProductVersion();
            StringTokenizer st = new StringTokenizer(ver_str.trim(), " .", false);
            String tk = null;
            int ct = 0;
            short num = 0;
            while (st.hasMoreTokens()) {
                tk = st.nextToken();
                try {
                    num = Integer.decode(tk).shortValue();
                    version_num = (short)(version_num * 10 + num);
                    if (++ct != 4) continue;
                    break;
                }
                catch (NumberFormatException nfe) {
                }
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (version_num == -1) {
            version_num = 0;
        }
        return version_num;
    }

    public ClobDBAccess createClobDBAccess() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.driverLogger.log(Level.FINE, "T2CConnection.createClobDBAccess()", this);
            OracleLog.recursiveTrace = false;
        }
        return this;
    }

    public BlobDBAccess createBlobDBAccess() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createBlobDBAccess()", this);
            OracleLog.recursiveTrace = false;
        }
        return this;
    }

    public BfileDBAccess createBfileDBAccess() {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createBfileDBAccess()", this);
            OracleLog.recursiveTrace = false;
        }
        return this;
    }

    public CLOB createClob(byte[] locator_bytes) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createClob()" + OracleLog.bytesToPrintableForm("locator_bytes=", locator_bytes), this);
            OracleLog.recursiveTrace = false;
        }
        return new CLOB(this, locator_bytes);
    }

    public CLOB createClob(byte[] locator_bytes, short csform) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createClob() csform = " + csform + OracleLog.bytesToPrintableForm("locator_bytes=", locator_bytes), this);
            OracleLog.recursiveTrace = false;
        }
        return new CLOB(this, locator_bytes, csform);
    }

    public BLOB createBlob(byte[] locator_bytes) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createBlob()" + OracleLog.bytesToPrintableForm("locator_bytes=", locator_bytes), this);
            OracleLog.recursiveTrace = false;
        }
        return new BLOB(this, locator_bytes);
    }

    public BFILE createBfile(byte[] locator_bytes) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createClob()", this);
            OracleLog.recursiveTrace = false;
        }
        return new BFILE(this, locator_bytes);
    }

    protected SQLWarning checkError(int errStatus) throws SQLException {
        return this.checkError(errStatus, null);
    }

    protected SQLWarning checkError(int errStatus, SQLWarning warning) throws SQLException {
        switch (errStatus) {
            case 0: {
                break;
            }
            case -1: 
            case 1: {
                int msgLength;
                T2CError l_error = new T2CError();
                int l_status = -1;
                if (this.m_nativeState != 0L) {
                    l_status = this.t2cDescribeError(this.m_nativeState, l_error, l_error.m_errorMessage);
                } else if (this.fatalErrorNumber != 0) {
                    String l_sqlstate = DatabaseError.ErrorToSQLState(this.fatalErrorNumber);
                    DatabaseError.throwSqlException(this.fatalErrorMessage, l_sqlstate, l_error.m_errorNumber);
                } else {
                    DatabaseError.throwSqlException(8);
                }
                switch (l_error.m_errorNumber) {
                    case 28: 
                    case 600: 
                    case 1012: 
                    case 1041: 
                    case 3113: 
                    case 3114: {
                        this.internalClose();
                    }
                }
                if (l_status == -1) {
                    DatabaseError.throwSqlException(1, "Fetch error message failed!");
                }
                for (msgLength = 0; msgLength < l_error.m_errorMessage.length && l_error.m_errorMessage[msgLength] != 0; ++msgLength) {
                }
                String l_reason = this.conversion.CharBytesToString(l_error.m_errorMessage, msgLength, true);
                String l_sqlstate = DatabaseError.ErrorToSQLState(l_error.m_errorNumber);
                if (errStatus == -1) {
                    DatabaseError.throwSqlException(l_reason, l_sqlstate, l_error.m_errorNumber);
                    break;
                }
                warning = DatabaseError.addSqlWarning(warning, l_reason, l_sqlstate, l_error.m_errorNumber);
                break;
            }
        }
        return warning;
    }

    OracleStatement RefCursorBytesToStatement(byte[] bytes, OracleStatement parent) throws SQLException {
        T2CStatement stmt = new T2CStatement(this, 1, this.defaultRowPrefetch, -1, -1);
        stmt.needToParse = false;
        stmt.serverCursor = true;
        stmt.isOpen = true;
        stmt.processEscapes = false;
        stmt.prepareForNewResults(true, false);
        stmt.sqlObject.initialize("select unknown as ref cursor from whatever");
        stmt.sqlKind = 0;
        this.checkError(this.t2cCreateStatement(this.m_nativeState, parent.c_state, bytes, bytes.length, stmt, true, this.defaultRowPrefetch));
        return stmt;
    }

    public void getForm(OracleTypeADT otypeADT, OracleTypeCLOB otype, int attrIndex) throws SQLException {
        boolean value = false;
        if (otype != null) {
            String[] schema = new String[1];
            String[] type = new String[1];
            SQLName.parse(otypeADT.getFullName(), schema, type, true);
            String fullname = "\"" + schema[0] + "\".\"" + type[0] + "\"";
            byte[] utf8bytes = this.conversion.StringToCharBytes(fullname);
            int formOfUse = this.t2cGetFormOfUse(this.m_nativeState, otype, utf8bytes, utf8bytes.length, attrIndex);
            if (formOfUse < 0) {
                this.checkError(formOfUse);
            }
            otype.setForm(formOfUse);
        } else if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.SEVERE, "T2CConnecion.getFrom(otype, attrIndex = " + attrIndex + "): otype is null", this);
            OracleLog.recursiveTrace = false;
        }
    }

    public long getTdoCState(String schemaName, String typeName) throws SQLException {
        int[] err;
        String fullNameWithQuotes = "\"" + schemaName + "\".\"" + typeName + "\"";
        byte[] dbcsbytes = this.conversion.StringToCharBytes(fullNameWithQuotes);
        long tdoCState = this.t2cGetTDO(this.m_nativeState, dbcsbytes, dbcsbytes.length, err = new int[1]);
        if (tdoCState == 0L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "T2CConnecion.get_tdoCState(fullName = " + fullNameWithQuotes + ") got error " + err[0], this);
                OracleLog.recursiveTrace = false;
            }
            this.checkError(err[0]);
        }
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnecion.get_tdoCState(fullName = " + fullNameWithQuotes + ") got : " + tdoCState, this);
            OracleLog.recursiveTrace = false;
        }
        return tdoCState;
    }

    public Properties getDBAccessProperties() throws SQLException {
        return this.getOCIHandles();
    }

    public synchronized Properties getOCIHandles() throws SQLException {
        if (this.nativeInfo == null) {
            long[] handles = new long[3];
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.FINE, "T2CConnection.getOCIHandles()", this);
                OracleLog.recursiveTrace = false;
            }
            this.checkError(this.t2cGetHandles(this.m_nativeState, handles));
            this.nativeInfo = new Properties();
            this.nativeInfo.put("OCIEnvHandle", String.valueOf(handles[0]));
            this.nativeInfo.put("OCISvcCtxHandle", String.valueOf(handles[1]));
            this.nativeInfo.put("OCIErrHandle", String.valueOf(handles[2]));
            this.nativeInfo.put("ClientCharSet", String.valueOf(this.m_clientCharacterSet));
        }
        return this.nativeInfo;
    }

    public Properties getServerSessionInfo() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        Properties info = new Properties();
        this.checkError(T2CConnection.t2cGetServerSessionInfo(this.m_nativeState, info));
        return info;
    }

    public Properties getConnectionPoolInfo() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        Properties info = new Properties();
        this.checkError(this.t2cGetConnPoolInfo(this.m_nativeState, info));
        return info;
    }

    public void setConnectionPoolInfo(int cpool_min, int cpool_max, int cpool_incr, int cpool_timeout, int cpool_nowait, int cpool_dist_txn) throws SQLException {
        this.checkError(this.t2cSetConnPoolInfo(this.m_nativeState, cpool_min, cpool_max, cpool_incr, cpool_timeout, cpool_nowait, cpool_dist_txn));
    }

    public void ociPasswordChange(String user, String oldPassword, String newPassword) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        byte[] l_userName = user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(user, this.m_clientCharacterSet);
        byte[] l_oldPwd = oldPassword == null ? new byte[]{} : DBConversion.stringToAsciiBytes(oldPassword);
        byte[] l_newPwd = newPassword == null ? new byte[]{} : DBConversion.stringToAsciiBytes(newPassword);
        this.sqlWarning = this.checkError(this.t2cPasswordChange(this.m_nativeState, l_userName, l_userName.length, l_oldPwd, l_oldPwd.length, l_newPwd, l_newPwd.length), this.sqlWarning);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processOCIConnectionPooling() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        byte[] l_userName = null;
        byte[] l_password = this.password == null ? new byte[]{} : DBConversion.stringToAsciiBytes(this.password);
        byte[] l_database = DBConversion.stringToAsciiBytes(this.database);
        byte[] nlslanguage = CharacterSetMetaData.getNLSLanguage(Locale.getDefault()).getBytes();
        byte[] nlsterritory = CharacterSetMetaData.getNLSTerritory(Locale.getDefault()).getBytes();
        String prop = this.connectionProperties.getProperty("connection_pool");
        short[] csids = new short[3];
        if (prop == "connection_pool") {
            String propNlsLangBackdoor = this.connectionProperties.getProperty("oracle.jdbc.ociNlsLangBackwardCompatible");
            this.m_clientCharacterSet = propNlsLangBackdoor != null && propNlsLangBackdoor.equalsIgnoreCase("true") ? T2CConnection.getDriverCharSetIdFromNLS_LANG(this.connectionProperties) : T2CConnection.getClientCharSetId();
            l_userName = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.logon_mode = 5;
            if (this.m_nativeState != 0L) throw DatabaseError.newSqlException(0, "Internal Error: ");
            int[] p = new int[6];
            OracleOCIConnectionPool.readPoolConfig(this.connectionProperties, p);
            this.sqlWarning = this.checkError(this.t2cCreateConnPool(l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.m_clientCharacterSet, this.logon_mode, p[0], p[1], p[2], p[3], p[4], p[5]), this.sqlWarning);
            this.versionNumber = (short)10000;
        } else if (prop == "connpool_connection") {
            this.logon_mode = 6;
            T2CConnection m_conn_pool = (T2CConnection)this.connectionProperties.get("connpool_object");
            this.m_clientCharacterSet = m_conn_pool.m_clientCharacterSet;
            l_userName = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, null, 0, csids, nlslanguage, nlsterritory), this.sqlWarning);
        } else if (prop == "connpool_alias_connection") {
            this.logon_mode = 8;
            byte[] connection_id = null;
            connection_id = (byte[])this.connectionProperties.get("connection_id");
            T2CConnection m_conn_pool = (T2CConnection)this.connectionProperties.get("connpool_object");
            this.m_clientCharacterSet = m_conn_pool.m_clientCharacterSet;
            l_userName = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.logon_mode, 0, 0, null, null, 0, null, 0, null, 0, null, 0, connection_id, connection_id == null ? 0 : connection_id.length, csids, nlslanguage, nlsterritory), this.sqlWarning);
        } else if (prop == "connpool_proxy_connection") {
            this.logon_mode = 7;
            String proxyType = this.connectionProperties.getProperty("proxytype");
            Integer num = (Integer)this.connectionProperties.get("proxy_num_roles");
            int num_proxy_roles = num;
            String[] proxy_roles = null;
            if (num_proxy_roles > 0) {
                proxy_roles = (String[])this.connectionProperties.get("proxy_roles");
            }
            byte[] proxy_un = null;
            byte[] proxy_pd = null;
            byte[] proxy_dn = null;
            byte[] proxy_cf = null;
            int proxy_type = 0;
            if (proxyType == "proxytype_user_name") {
                proxy_type = 1;
                String p = this.connectionProperties.getProperty("proxy_user_name");
                if (p != null) {
                    proxy_un = p.getBytes();
                }
                if ((p = this.connectionProperties.getProperty("proxy_password")) != null) {
                    proxy_pd = p.getBytes();
                }
            } else if (proxyType == "proxytype_distinguished_name") {
                proxy_type = 2;
                String p = this.connectionProperties.getProperty("proxy_distinguished_name");
                if (p != null) {
                    proxy_dn = p.getBytes();
                }
            } else if (proxyType == "proxytype_certificate") {
                proxy_type = 3;
                proxy_cf = (byte[])this.connectionProperties.get("proxy_certificate");
            } else {
                DatabaseError.throwSqlException(107);
            }
            T2CConnection m_conn_pool = (T2CConnection)this.connectionProperties.get("connpool_object");
            this.m_clientCharacterSet = m_conn_pool.m_clientCharacterSet;
            l_userName = this.user == null ? new byte[]{} : DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
            this.conversion = new DBConversion(this.m_clientCharacterSet, this.m_clientCharacterSet, this.m_clientCharacterSet);
            this.sqlWarning = this.checkError(this.t2cConnPoolLogon(m_conn_pool.m_nativeState, l_userName, l_userName.length, l_password, l_password.length, l_database, l_database.length, this.logon_mode, proxy_type, num_proxy_roles, proxy_roles, proxy_un, proxy_un == null ? 0 : proxy_un.length, proxy_pd, proxy_pd == null ? 0 : proxy_pd.length, proxy_dn, proxy_dn == null ? 0 : proxy_dn.length, proxy_cf, proxy_cf == null ? 0 : proxy_cf.length, null, 0, csids, nlslanguage, nlsterritory), this.sqlWarning);
        } else {
            DatabaseError.throwSqlException(23, "connection-pool-logon");
        }
        this.conversion = new DBConversion(csids[0], this.m_clientCharacterSet, csids[1]);
        this.byteAlign = (byte)(csids[2] & 0xFF);
    }

    public boolean isDescriptorSharable(OracleConnection conn) throws SQLException {
        T2CConnection c1 = this;
        PhysicalConnection c2 = (PhysicalConnection)conn.getPhysicalConnection();
        return c1 == c2;
    }

    native int blobRead(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9);

    native int clobRead(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, boolean var10);

    native int blobWrite(long var1, byte[] var3, int var4, long var5, int var7, byte[] var8, int var9, byte[][] var10);

    native int clobWrite(long var1, byte[] var3, int var4, long var5, int var7, char[] var8, int var9, byte[][] var10, boolean var11);

    native long lobGetLength(long var1, byte[] var3, int var4);

    native int bfileOpen(long var1, byte[] var3, int var4, byte[][] var5);

    native int bfileIsOpen(long var1, byte[] var3, int var4, boolean[] var5);

    native int bfileExists(long var1, byte[] var3, int var4, boolean[] var5);

    native String bfileGetName(long var1, byte[] var3, int var4);

    native String bfileGetDirAlias(long var1, byte[] var3, int var4);

    native int bfileClose(long var1, byte[] var3, int var4, byte[][] var5);

    native int lobGetChunkSize(long var1, byte[] var3, int var4);

    native int lobTrim(long var1, int var3, long var4, byte[] var6, int var7, byte[][] var8);

    native int lobCreateTemporary(long var1, int var3, boolean var4, int var5, short var6, byte[][] var7);

    native int lobFreeTemporary(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    native int lobIsTemporary(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int lobOpen(long var1, int var3, byte[] var4, int var5, int var6, byte[][] var7);

    native int lobIsOpen(long var1, int var3, byte[] var4, int var5, boolean[] var6);

    native int lobClose(long var1, int var3, byte[] var4, int var5, byte[][] var6);

    private long lobLength(byte[] locator) throws SQLException {
        long result = 0L;
        result = this.lobGetLength(this.m_nativeState, locator, locator.length);
        this.checkError((int)result);
        return result;
    }

    private int blobRead(byte[] locator, long offset, int amount, byte[] buffer) throws SQLException {
        int result = 0;
        result = this.blobRead(this.m_nativeState, locator, locator.length, offset, amount, buffer, buffer.length);
        this.checkError(result);
        return result;
    }

    private int blobWrite(byte[] locator, long offset, byte[] buffer, byte[][] newLocatorHolder, int bytesOffset, int amount) throws SQLException {
        int result = 0;
        result = this.blobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, bytesOffset, newLocatorHolder);
        this.checkError(result);
        return result;
    }

    private int clobWrite(byte[] locator, long offset, char[] buffer, byte[][] newLocatorHolder, boolean isNclob, int charsOffset, int amount) throws SQLException {
        int result = 0;
        result = this.clobWrite(this.m_nativeState, locator, locator.length, offset, amount, buffer, charsOffset, newLocatorHolder, isNclob);
        this.checkError(result);
        return result;
    }

    private int lobGetChunkSize(byte[] locator) throws SQLException {
        int result = 0;
        result = this.lobGetChunkSize(this.m_nativeState, locator, locator.length);
        this.checkError(result);
        return result;
    }

    public long length(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.Length(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        return this.lobLength(locator);
    }

    public long position(BFILE bfile, byte[] pattern, long start) throws SQLException {
        long result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.position( " + bfile + ", " + pattern + ", " + start + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (start < 1L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "oracle.jdbc.driver.T2CConnection.position: Invalid argument, 'start' should not be <1.", this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(68, "position()");
        }
        long l = result = (result = LobPlsqlUtil.hasPattern(bfile, pattern, start)) == 0L ? -1L : result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.position:return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public long position(BFILE bfile, BFILE pattern, long start) throws SQLException {
        long result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.position( " + bfile + ", " + pattern + ", " + start + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (start < 1L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "oracle.jdbc.driver.T2CConnection.position: Invalid argument, 'start' should not be <1.", this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(68, "position()");
        }
        long l = result = (result = LobPlsqlUtil.isSubLob(bfile, pattern, start)) == 0L ? -1L : result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.position:return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public int getBytes(BFILE bfile, long offset, int amount, byte[] buffer) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.getBytes(bfile = " + bfile + ", offset = " + offset + ", amount = " + amount + ", buffer = " + buffer + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        if (amount <= 0 || buffer == null) {
            return 0;
        }
        if (amount > buffer.length) {
            amount = buffer.length;
        }
        return this.blobRead(locator, offset, amount, buffer);
    }

    public String getName(BFILE bfile) throws SQLException {
        byte[] locator = null;
        String fileName = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.GetName(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        fileName = this.bfileGetName(this.m_nativeState, locator, locator.length);
        this.checkError(fileName.length());
        return fileName;
    }

    public String getDirAlias(BFILE bfile) throws SQLException {
        byte[] locator = null;
        String aliasName = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.fileGetDirAlias(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        aliasName = this.bfileGetDirAlias(this.m_nativeState, locator, locator.length);
        this.checkError(aliasName.length());
        return aliasName;
    }

    public void openFile(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.openFile(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.bfileOpen(this.m_nativeState, locator, locator.length, newLocatorHolder));
        bfile.setLocator(newLocatorHolder[0]);
    }

    public boolean isFileOpen(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.isFileOpen(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.bfileIsOpen(this.m_nativeState, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public boolean fileExists(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.fileExists(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.bfileExists(this.m_nativeState, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public void closeFile(BFILE bfile) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.closeFile(bfile = " + bfile + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(bfile != null && (locator = bfile.getLocator()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.bfileClose(this.m_nativeState, locator, locator.length, newLocatorHolder));
        bfile.setLocator(newLocatorHolder[0]);
    }

    public void open(BFILE lob, int mode) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.open( lob = " + lob + ", mode = " + mode + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobOpen(this.m_nativeState, 114, locator, locator.length, mode, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
    }

    public void close(BFILE lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.close(lob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobClose(this.m_nativeState, 114, locator, locator.length, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
    }

    public boolean isOpen(BFILE lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.isOpen(lob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.lobIsOpen(this.m_nativeState, 114, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public InputStream newInputStream(BFILE bfile, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.newInputStream(" + bfile + ", " + chunkSize + ", " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleBlobInputStream(bfile, chunkSize);
        }
        return new OracleBlobInputStream(bfile, chunkSize, pos);
    }

    public InputStream newConversionInputStream(BFILE bfile, int conversionType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.newConversionInputStream(" + bfile + ", " + conversionType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
        OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, bfile.getBinaryStream(), conversionType);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.newConversionInputStream: return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public Reader newConversionReader(BFILE bfile, int conversionType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.newConversionReader(" + bfile + ", " + conversionType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(bfile != null && bfile.shareBytes() != null, 54);
        OracleConversionReader result = new OracleConversionReader(this.conversion, bfile.getBinaryStream(), conversionType);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newConversionReader: return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public long length(BLOB blob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.Length(blob = " + blob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
        return this.lobLength(locator);
    }

    public long position(BLOB blob, byte[] pattern, long start) throws SQLException {
        long result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.position(blob = " + blob + ", pattern = " + pattern + ", start = " + start + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(blob != null && blob.shareBytes() != null, 54);
        if (start < 1L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "T2CConnection.position: Invalid argument, 'start' should not be <1.", this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(68, "position()");
        }
        long l = result = (result = LobPlsqlUtil.hasPattern(blob, pattern, start)) == 0L ? -1L : result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position:return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public long position(BLOB blob, BLOB pattern, long start) throws SQLException {
        long result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position( " + blob + ", " + pattern + ", " + start + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(blob != null && blob.shareBytes() != null, 54);
        this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
        if (start < 1L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "T2CConnection.position: Invalid argument, 'start' should not be <1.", this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(68, "position()");
        }
        long l = result = (result = LobPlsqlUtil.isSubLob(blob, pattern, start)) == 0L ? -1L : result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position:return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public int getBytes(BLOB blob, long offset, int amount, byte[] buffer) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.getBytes(blob = " + blob + ", offset = " + offset + ", amount = " + amount + ", buffer = " + buffer + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
        if (amount <= 0 || buffer == null) {
            return 0;
        }
        if (amount > buffer.length) {
            amount = buffer.length;
        }
        return this.blobRead(locator, offset, amount, buffer);
    }

    public int putBytes(BLOB blob, long offset, byte[] buffer, int bytesOffset, int length) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.putbytes(blob = " + blob + ", offset = " + offset + ", buffer = " + buffer + ", length = " + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(offset >= 0L, 68);
        int ret = 0;
        if (buffer == null || buffer.length == 0 || length <= 0) {
            ret = 0;
        } else {
            byte[] locator = null;
            this.checkTrue(this.m_nativeState != 0L, 8);
            this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
            if (buffer == null) {
                return 0;
            }
            byte[][] newLocatorHolder = new byte[1][];
            ret = this.blobWrite(locator, offset, buffer, newLocatorHolder, bytesOffset, length);
            blob.setLocator(newLocatorHolder[0]);
        }
        return ret;
    }

    public int getChunkSize(BLOB blob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.getChunkSize(blob = " + blob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(blob != null && (locator = blob.getLocator()) != null, 54);
        return this.lobGetChunkSize(locator);
    }

    public void trim(BLOB lob, long newlen) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.trim(lob = " + lob + ", newlen = " + newlen + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobTrim(this.m_nativeState, 113, newlen, locator, locator.length, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
    }

    public BLOB createTemporaryBlob(Connection conn, boolean cache, int duration) throws SQLException {
        BLOB lob = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createTemporaryBlob(conn = " + conn + ", cache = " + cache + ", duration = " + duration + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        lob = new BLOB((PhysicalConnection)conn);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobCreateTemporary(this.m_nativeState, 113, cache, duration, (short)0, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
        return lob;
    }

    public void freeTemporary(BLOB temp_lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.freeTemporary(temp_lob = " + temp_lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobFreeTemporary(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
        temp_lob.setShareBytes(newLocatorHolder[0]);
    }

    public boolean isTemporary(BLOB lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.isTemporary(lob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.lobIsTemporary(this.m_nativeState, 113, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public void open(BLOB blob, int mode) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.open(blob  = " + blob + ", mode = " + mode + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(blob != null && (locator = blob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobOpen(this.m_nativeState, 113, locator, locator.length, mode, newLocatorHolder));
        blob.setShareBytes(newLocatorHolder[0]);
    }

    public void close(BLOB lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.close(blob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobClose(this.m_nativeState, 113, locator, locator.length, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
    }

    public boolean isOpen(BLOB lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.isOpen(blob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.lobIsOpen(this.m_nativeState, 113, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public InputStream newInputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.newInputStream(blob = " + blob + ", chunkSize = " + chunkSize + ", pos = " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleBlobInputStream(blob, chunkSize);
        }
        return new OracleBlobInputStream(blob, chunkSize, pos);
    }

    public OutputStream newOutputStream(BLOB blob, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "oracle.jdbc.driver.T2CConnection.newOutputStream(blob = " + blob + ", chunkSize = " + chunkSize + ", pos = " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleBlobOutputStream(blob, chunkSize);
        }
        return new OracleBlobOutputStream(blob, chunkSize, pos);
    }

    public InputStream newConversionInputStream(BLOB blob, int conversionType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newConversionInputStream(blob = " + blob + ", oracle.jdbc.driver. = " + conversionType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(blob != null && blob.shareBytes() != null, 54);
        OracleConversionInputStream result = new OracleConversionInputStream(this.conversion, blob.getBinaryStream(), conversionType);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newConversionInputStream: return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public Reader newConversionReader(BLOB blob, int conversionType) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newConversionReader(blob = " + blob + ", conversionType = " + conversionType + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(blob != null && blob.shareBytes() != null, 54);
        OracleConversionReader result = new OracleConversionReader(this.conversion, blob.getBinaryStream(), conversionType);
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newConversionReader: return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public long length(CLOB clob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConneciton.Length(clob = " + clob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
        return this.lobLength(locator);
    }

    public long position(CLOB clob, String pattern, long start) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position(clob = " + clob + ", pattern = " + pattern + ", start = " + start + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pattern == null) {
            throw new SQLException("pattern cannot be null.");
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(clob != null && clob.shareBytes() != null, 54);
        if (start < 1L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "T2CConnection.position: Invalid argument, 'start' should not be <1.", this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(68, "position()");
        }
        char[] chars = new char[pattern.length()];
        pattern.getChars(0, chars.length, chars, 0);
        long result = LobPlsqlUtil.hasPattern(clob, chars, start);
        long l = result = result == 0L ? -1L : result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position:return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public long position(CLOB clob, CLOB pattern, long start) throws SQLException {
        long result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position(clob = " + clob + ", pattern =" + pattern + ", start = " + start + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(clob != null && clob.shareBytes() != null, 54);
        this.checkTrue(pattern != null && pattern.shareBytes() != null, 54);
        if (start < 1L) {
            if (TRACE && !OracleLog.recursiveTrace) {
                OracleLog.recursiveTrace = true;
                OracleLog.ociLogger.log(Level.SEVERE, "T2CConnection.position: Invalid argument, 'start' should not be <1.", this);
                OracleLog.recursiveTrace = false;
            }
            DatabaseError.throwSqlException(68, "position()");
        }
        long l = result = (result = LobPlsqlUtil.isSubLob(clob, pattern, start)) == 0L ? -1L : result;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.position:return: " + result, this);
            OracleLog.recursiveTrace = false;
        }
        return result;
    }

    public int getChars(CLOB clob, long offset, int amount, char[] buffer) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.getChars(clob = " + clob + ", offset = " + offset + ", amount = " + amount + ", buffer = " + buffer + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
        if (amount <= 0 || buffer == null) {
            return 0;
        }
        if (amount > buffer.length) {
            amount = buffer.length;
        }
        int result = 0;
        result = this.clobRead(this.m_nativeState, locator, locator.length, offset, amount, buffer, buffer.length, clob.isNCLOB());
        this.checkError(result);
        return result;
    }

    public int putChars(CLOB clob, long offset, char[] buffer, int charsOffset, int length) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.putChars(clob = " + clob + ", offset = " + offset + ", buffer = " + buffer + ", charsOffset = " + charsOffset + ", length = " + length + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(offset >= 0L, 68);
        this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
        if (buffer == null) {
            return 0;
        }
        byte[][] newLocatorHolder = new byte[1][];
        int result = this.clobWrite(locator, offset, buffer, newLocatorHolder, clob.isNCLOB(), charsOffset, length);
        clob.setLocator(newLocatorHolder[0]);
        return result;
    }

    public int getChunkSize(CLOB clob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.getChunkSize(clob = " + clob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(clob != null && (locator = clob.getLocator()) != null, 54);
        return this.lobGetChunkSize(locator);
    }

    public void trim(CLOB clob, long newlen) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.trim(clob = " + clob + ", newlen = " + newlen + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(clob != null && (locator = clob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobTrim(this.m_nativeState, 112, newlen, locator, locator.length, newLocatorHolder));
        clob.setShareBytes(newLocatorHolder[0]);
    }

    public CLOB createTemporaryClob(Connection conn, boolean cache, int duration, short form_of_use) throws SQLException {
        CLOB lob = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.createTemporaryClob(conn = " + conn + ", cache = " + cache + ", duration = " + duration + ", form_of_use = " + form_of_use + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        lob = new CLOB((PhysicalConnection)conn);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobCreateTemporary(this.m_nativeState, 112, cache, duration, form_of_use, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
        return lob;
    }

    public void freeTemporary(CLOB temp_lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.freeTemporary(temp_lob = " + temp_lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(temp_lob != null && (locator = temp_lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobFreeTemporary(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
        temp_lob.setShareBytes(newLocatorHolder[0]);
    }

    public boolean isTemporary(CLOB lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.isTemporary(lob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.lobIsTemporary(this.m_nativeState, 112, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public void open(CLOB lob, int mode) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.open(lob = " + lob + ", mode = " + mode + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobOpen(this.m_nativeState, 112, locator, locator.length, mode, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
    }

    public void close(CLOB lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.close(lob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        byte[][] newLocatorHolder = new byte[1][];
        this.checkError(this.lobClose(this.m_nativeState, 112, locator, locator.length, newLocatorHolder));
        lob.setShareBytes(newLocatorHolder[0]);
    }

    public boolean isOpen(CLOB lob) throws SQLException {
        byte[] locator = null;
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.isOpen(lob = " + lob + ")", this);
            OracleLog.recursiveTrace = false;
        }
        this.checkTrue(this.m_nativeState != 0L, 8);
        this.checkTrue(lob != null && (locator = lob.shareBytes()) != null, 54);
        boolean[] flagHolder = new boolean[1];
        this.checkError(this.lobIsOpen(this.m_nativeState, 112, locator, locator.length, flagHolder));
        return flagHolder[0];
    }

    public InputStream newInputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newInputStream(clob = " + clob + ", chunkSize = " + chunkSize + ", pos = " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleClobInputStream(clob, chunkSize);
        }
        return new OracleClobInputStream(clob, chunkSize, pos);
    }

    public OutputStream newOutputStream(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newOutputStream(clob = " + clob + ", chunkSize = " + chunkSize + ", pos = " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleClobOutputStream(clob, chunkSize);
        }
        return new OracleClobOutputStream(clob, chunkSize, pos);
    }

    public Reader newReader(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newReader(CLOB = " + clob + ", chunkSize = " + chunkSize + ", pos = " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleClobReader(clob, chunkSize);
        }
        return new OracleClobReader(clob, chunkSize, pos);
    }

    public Writer newWriter(CLOB clob, int chunkSize, long pos) throws SQLException {
        if (TRACE && !OracleLog.recursiveTrace) {
            OracleLog.recursiveTrace = true;
            OracleLog.ociLogger.log(Level.FINE, "T2CConnection.newWriter(clob = " + clob + ", chunkSize = " + chunkSize + ", pos = " + pos + ")", this);
            OracleLog.recursiveTrace = false;
        }
        if (pos == 0L) {
            return new OracleClobWriter(clob, chunkSize);
        }
        return new OracleClobWriter(clob, chunkSize, pos);
    }

    public synchronized void registerTAFCallback(OracleOCIFailover cbk, Object obj) throws SQLException {
        this.appCallback = cbk;
        this.appCallbackObject = obj;
        this.checkError(this.t2cRegisterTAFCallback(this.m_nativeState));
    }

    synchronized int callTAFCallbackMethod(int type, int event) {
        int retCode = 0;
        if (this.appCallback != null) {
            retCode = this.appCallback.callbackFn(this, this.appCallbackObject, type, event);
        }
        return retCode;
    }

    public int getHeapAllocSize() throws SQLException {
        int size;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if ((size = this.t2cGetHeapAllocSize(this.m_nativeState)) < 0) {
            if (size == -999) {
                DatabaseError.throwSqlException(23);
            }
            DatabaseError.throwSqlException(89);
        }
        return size;
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        int size;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if ((size = this.t2cGetOciEnvHeapAllocSize(this.m_nativeState)) < 0) {
            if (size == -999) {
                DatabaseError.throwSqlException(23);
            } else {
                this.checkError(size);
            }
            DatabaseError.throwSqlException(89);
        }
        return size;
    }

    public static final short getClientCharSetId() {
        return 871;
    }

    public static short getDriverCharSetIdFromNLS_LANG(Properties props) throws SQLException {
        short driverCharSetId;
        if (!isLibraryLoaded) {
            T2CConnection.loadNativeLibrary(props);
        }
        if ((driverCharSetId = T2CConnection.t2cGetDriverCharSetFromNlsLang()) < 0) {
            DatabaseError.throwSqlException(8);
        }
        return driverCharSetId;
    }

    void doProxySession(int type, Properties prop) throws SQLException {
        byte[] cfBytes;
        Object roles = null;
        int numProxyRoles = 0;
        this.savedUser = this.user;
        this.user = null;
        byte[] dnBytes = cfBytes = new byte[0];
        byte[] pwdBytes = cfBytes;
        byte[] userBytes = cfBytes;
        switch (type) {
            case 1: {
                this.user = prop.getProperty("PROXY_USER_NAME");
                String pwd = prop.getProperty("PROXY_USER_PASSWORD");
                if (this.user != null) {
                    userBytes = DBConversion.stringToDriverCharBytes(this.user, this.m_clientCharacterSet);
                }
                if (pwd == null) break;
                pwdBytes = DBConversion.stringToAsciiBytes(pwd);
                break;
            }
            case 2: {
                String distName = prop.getProperty("PROXY_DISTINGUISHED_NAME");
                if (distName == null) break;
                dnBytes = DBConversion.stringToDriverCharBytes(distName, this.m_clientCharacterSet);
                break;
            }
            case 3: {
                Object certif = prop.get("PROXY_CERTIFICATE");
                cfBytes = (byte[])certif;
            }
        }
        String[] strRoles = (String[])prop.get("PROXY_ROLES");
        if (strRoles != null) {
            numProxyRoles = strRoles.length;
            roles = new byte[numProxyRoles][];
            for (int i = 0; i < numProxyRoles; ++i) {
                if (strRoles[i] == null) {
                    DatabaseError.throwSqlException(150);
                }
                roles[i] = DBConversion.stringToDriverCharBytes(strRoles[i], this.m_clientCharacterSet);
            }
        }
        this.sqlWarning = this.checkError(this.t2cDoProxySession(this.m_nativeState, type, userBytes, userBytes.length, pwdBytes, pwdBytes.length, dnBytes, dnBytes.length, cfBytes, cfBytes.length, numProxyRoles, (byte[][])roles), this.sqlWarning);
        this.isProxy = true;
    }

    void closeProxySession() throws SQLException {
        this.checkError(this.t2cCloseProxySession(this.m_nativeState));
        this.user = this.savedUser;
    }

    protected void doDescribeTable(AutoKeyInfo info) throws SQLException {
        int numColumns;
        String tableName = info.getTableName();
        byte[] bytesTableName = DBConversion.stringToDriverCharBytes(tableName, this.m_clientCharacterSet);
        boolean tryAgain = false;
        do {
            if ((numColumns = T2CConnection.t2cDescribeTable(this.m_nativeState, bytesTableName, bytesTableName.length, this.queryMetaData1, this.queryMetaData2, this.queryMetaData1Offset, this.queryMetaData2Offset, this.queryMetaData1Size, this.queryMetaData2Size)) == -1) {
                this.checkError(numColumns);
            }
            if (numColumns != T2CStatement.T2C_EXTEND_BUFFER) continue;
            tryAgain = true;
            this.reallocateQueryMetaData(this.queryMetaData1Size * 2, this.queryMetaData2Size * 2);
        } while (tryAgain);
        this.processDescribeTableData(numColumns, info);
    }

    private void processDescribeTableData(int numColumns, AutoKeyInfo info) throws SQLException {
        short[] s = this.queryMetaData1;
        byte[] c = this.queryMetaData2;
        int currentShort = this.queryMetaData1Offset;
        int currentChar = this.queryMetaData2Offset;
        info.allocateSpaceForDescribedData(numColumns);
        for (int i = 0; i < numColumns; ++i) {
            short type = s[currentShort + 0];
            short columnNameLen = s[currentShort + 6];
            String columnName = T2CConnection.bytes2String(c, currentChar, columnNameLen, this.conversion);
            short maxLength = s[currentShort + 1];
            short maxCharLength = s[currentShort + 11];
            boolean nullable = s[currentShort + 2] != 0;
            short formOfUse = s[currentShort + 5];
            short precision = s[currentShort + 3];
            short scale = s[currentShort + 4];
            short typeNameLen = s[currentShort + 12];
            currentChar += columnNameLen;
            currentShort += 13;
            String typeName = null;
            if (typeNameLen > 0) {
                typeName = T2CConnection.bytes2String(c, currentChar, typeNameLen, this.conversion);
                currentChar += typeNameLen;
            }
            info.fillDescribedData(i, columnName, type, maxCharLength > 0 ? maxCharLength : maxLength, nullable, formOfUse, precision, scale, typeName);
        }
    }

    void doSetApplicationContext(String nameSpace, String attribute, String value) throws SQLException {
        this.checkError(this.t2cSetApplicationContext(this.m_nativeState, nameSpace, attribute, value));
    }

    void doClearAllApplicationContext(String nameSpace) throws SQLException {
        this.checkError(this.t2cClearAllApplicationContext(this.m_nativeState, nameSpace));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void loadNativeLibrary(Properties props) throws SQLException {
        String dll_str = null;
        if (props != null) {
            dll_str = props.getProperty("oracle.jdbc.ocinativelibrary");
        }
        if (dll_str == null || dll_str.equals(OCILIBRARY)) {
            Class clazz = class$oracle$jdbc$driver$T2CConnection == null ? (class$oracle$jdbc$driver$T2CConnection = T2CConnection.class$("oracle.jdbc.driver.T2CConnection")) : class$oracle$jdbc$driver$T2CConnection;
            synchronized (clazz) {
                if (!isLibraryLoaded) {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            System.loadLibrary(T2CConnection.OCILIBRARY);
                            return null;
                        }
                    });
                    isLibraryLoaded = true;
                }
            }
        }
        Class clazz = class$oracle$jdbc$driver$T2CConnection == null ? (class$oracle$jdbc$driver$T2CConnection = T2CConnection.class$("oracle.jdbc.driver.T2CConnection")) : class$oracle$jdbc$driver$T2CConnection;
        synchronized (clazz) {
            block11: {
                try {
                    System.loadLibrary(dll_str);
                    isLibraryLoaded = true;
                }
                catch (SecurityException e) {
                    if (isLibraryLoaded) break block11;
                    System.loadLibrary(dll_str);
                    isLibraryLoaded = true;
                }
            }
        }
    }

    private final void checkTrue(boolean assertion, int errCode) throws SQLException {
        if (!assertion) {
            DatabaseError.throwSqlException(errCode);
        }
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return this.t2cPlatformIsLittleEndian(this.m_nativeState);
    }

    public void getPropertyForPooledConnection(OraclePooledConnection pc) throws SQLException {
        super.getPropertyForPooledConnection(pc, this.password);
    }

    static final char[] getCharArray(String s) {
        char[] r = null;
        if (s == null) {
            r = new char[]{};
        } else {
            r = new char[s.length()];
            s.getChars(0, s.length(), r, 0);
        }
        return r;
    }

    static String bytes2String(byte[] bytes, int offset, int size, DBConversion conversion) throws SQLException {
        byte[] tmp = new byte[size];
        System.arraycopy(bytes, offset, tmp, 0, size);
        return conversion.CharBytesToString(tmp, size);
    }

    static native short t2cGetServerSessionInfo(long var0, Properties var2);

    static native short t2cGetDriverCharSetFromNlsLang();

    native int t2cDescribeError(long var1, T2CError var3, byte[] var4);

    native int t2cCreateState(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, short var9, int var10, short[] var11, byte[] var12, byte[] var13);

    native int t2cLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, byte[] var9, int var10, int var11, short[] var12, byte[] var13, byte[] var14);

    private native int t2cLogoff(long var1);

    private native int t2cCancel(long var1);

    private native int t2cCreateStatement(long var1, long var3, byte[] var5, int var6, OracleStatement var7, boolean var8, int var9);

    private native int t2cSetAutoCommit(long var1, boolean var3);

    private native int t2cCommit(long var1);

    private native int t2cRollback(long var1);

    private native byte[] t2cGetProductionVersion(long var1);

    private native int t2cGetVersionNumber(long var1);

    private native int t2cGetDefaultStreamChunkSize(long var1);

    native int t2cGetFormOfUse(long var1, OracleTypeCLOB var3, byte[] var4, int var5, int var6);

    native long t2cGetTDO(long var1, byte[] var3, int var4, int[] var5);

    native int t2cCreateConnPool(byte[] var1, int var2, byte[] var3, int var4, byte[] var5, int var6, short var7, int var8, int var9, int var10, int var11, int var12, int var13, int var14);

    native int t2cConnPoolLogon(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8, int var9, int var10, int var11, String[] var12, byte[] var13, int var14, byte[] var15, int var16, byte[] var17, int var18, byte[] var19, int var20, byte[] var21, int var22, short[] var23, byte[] var24, byte[] var25);

    native int t2cGetConnPoolInfo(long var1, Properties var3);

    native int t2cSetConnPoolInfo(long var1, int var3, int var4, int var5, int var6, int var7, int var8);

    native int t2cPasswordChange(long var1, byte[] var3, int var4, byte[] var5, int var6, byte[] var7, int var8);

    protected native byte[] t2cGetConnectionId(long var1);

    native int t2cGetHandles(long var1, long[] var3);

    native int t2cUseConnection(long var1, long var3, long var5, long var7, short[] var9);

    native boolean t2cPlatformIsLittleEndian(long var1);

    native int t2cRegisterTAFCallback(long var1);

    native int t2cGetHeapAllocSize(long var1);

    native int t2cGetOciEnvHeapAllocSize(long var1);

    native int t2cDoProxySession(long var1, int var3, byte[] var4, int var5, byte[] var6, int var7, byte[] var8, int var9, byte[] var10, int var11, int var12, byte[][] var13);

    native int t2cCloseProxySession(long var1);

    static native int t2cDescribeTable(long var0, byte[] var2, int var3, short[] var4, byte[] var5, int var6, int var7, int var8, int var9);

    native int t2cSetApplicationContext(long var1, String var3, String var4, String var5);

    native int t2cClearAllApplicationContext(long var1, String var3);

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T2CConnection"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

