/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.ehcache;

import java.io.IOException;
import java.io.InputStream;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;

public class EhCacheManagerFactoryBean
implements FactoryBean<CacheManager>,
InitializingBean,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource configLocation;
    private String cacheManagerName;
    private boolean acceptExisting = false;
    private boolean shared = false;
    private CacheManager cacheManager;
    private boolean locallyManaged = true;

    public void setConfigLocation(Resource configLocation) {
        this.configLocation = configLocation;
    }

    public void setCacheManagerName(String cacheManagerName) {
        this.cacheManagerName = cacheManagerName;
    }

    public void setAcceptExisting(boolean acceptExisting) {
        this.acceptExisting = acceptExisting;
    }

    public void setShared(boolean shared) {
        this.shared = shared;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void afterPropertiesSet() throws IOException, CacheException {
        this.logger.info((Object)"Initializing EhCache CacheManager");
        InputStream is = this.configLocation != null ? this.configLocation.getInputStream() : null;
        try {
            Configuration configuration;
            Configuration configuration2 = configuration = is != null ? ConfigurationFactory.parseConfiguration((InputStream)is) : ConfigurationFactory.parseConfiguration();
            if (this.cacheManagerName != null) {
                configuration.setName(this.cacheManagerName);
            }
            if (this.shared) {
                this.cacheManager = CacheManager.create((Configuration)configuration);
                return;
            }
            if (this.acceptExisting) {
                Class<CacheManager> clazz = CacheManager.class;
                synchronized (CacheManager.class) {
                    this.cacheManager = CacheManager.getCacheManager((String)this.cacheManagerName);
                    if (this.cacheManager == null) {
                        this.cacheManager = new CacheManager(configuration);
                    } else {
                        this.locallyManaged = false;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
            }
            this.cacheManager = new CacheManager(configuration);
            return;
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }

    public CacheManager getObject() {
        return this.cacheManager;
    }

    public Class<? extends CacheManager> getObjectType() {
        return this.cacheManager != null ? this.cacheManager.getClass() : CacheManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.locallyManaged) {
            this.logger.info((Object)"Shutting down EhCache CacheManager");
            this.cacheManager.shutdown();
        }
    }
}

