/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db.impl;

import com.coreframework.db.impl.TimeoutHandler;
import com.coreframework.log.Logger;
import java.sql.Connection;
import oracle.jdbc.OracleConnection;

public class OracleTimeout
implements TimeoutHandler {
    @Override
    public boolean handle(Connection conn) throws Throwable {
        if (conn.isWrapperFor(OracleConnection.class)) {
            conn.unwrap(OracleConnection.class).cancel();
            return true;
        }
        return false;
    }

    @Override
    public boolean validDriver() {
        Class<?> clz = null;
        try {
            clz = Class.forName("oracle.jdbc.OracleConnection");
        }
        catch (Throwable e) {
            Logger.get().console("oracle timeout disabled because you did not use oracle");
            return false;
        }
        try {
            clz.getMethod("cancel", new Class[0]);
            return true;
        }
        catch (Throwable e) {
            Logger.get().console("oracle timeout disabled because your oracle driver is small than 11g");
            return false;
        }
    }
}

