/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.MappedPropertyDescriptor;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.beanutils.WeakFastHashMap;
import org.apache.commons.beanutils.WrapDynaBean;
import org.apache.commons.beanutils.expression.DefaultResolver;
import org.apache.commons.beanutils.expression.Resolver;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PropertyUtilsBean {
    private Resolver resolver = new DefaultResolver();
    private WeakFastHashMap descriptorsCache = null;
    private WeakFastHashMap mappedDescriptorsCache = null;
    private static final Class[] EMPTY_CLASS_PARAMETERS = new Class[0];
    private static final Class[] LIST_CLASS_PARAMETER = new Class[]{List.class};
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private Log log = LogFactory.getLog(PropertyUtils.class);

    protected static PropertyUtilsBean getInstance() {
        return BeanUtilsBean.getInstance().getPropertyUtils();
    }

    public PropertyUtilsBean() {
        this.descriptorsCache = new WeakFastHashMap();
        this.descriptorsCache.setFast(true);
        this.mappedDescriptorsCache = new WeakFastHashMap();
        this.mappedDescriptorsCache.setFast(true);
    }

    public Resolver getResolver() {
        return this.resolver;
    }

    public void setResolver(Resolver resolver) {
        this.resolver = resolver == null ? new DefaultResolver() : resolver;
    }

    public void clearDescriptors() {
        this.descriptorsCache.clear();
        this.mappedDescriptorsCache.clear();
        Introspector.flushCaches();
    }

    public void copyProperties(Object dest, Object orig) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (dest == null) {
            throw new IllegalArgumentException("No destination bean specified");
        }
        if (orig == null) {
            throw new IllegalArgumentException("No origin bean specified");
        }
        if (orig instanceof DynaBean) {
            DynaProperty[] origDescriptors = ((DynaBean)orig).getDynaClass().getDynaProperties();
            int i = 0;
            while (i < origDescriptors.length) {
                block22: {
                    String name = origDescriptors[i].getName();
                    if (this.isReadable(orig, name) && this.isWriteable(dest, name)) {
                        try {
                            Object value = ((DynaBean)orig).get(name);
                            if (dest instanceof DynaBean) {
                                ((DynaBean)dest).set(name, value);
                            } else {
                                this.setSimpleProperty(dest, name, value);
                            }
                        }
                        catch (NoSuchMethodException e) {
                            if (!this.log.isDebugEnabled()) break block22;
                            this.log.debug((Object)("Error writing to '" + name + "' on class '" + dest.getClass() + "'"), (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        } else if (orig instanceof Map) {
            for (Map.Entry entry : ((Map)orig).entrySet()) {
                String name = (String)entry.getKey();
                if (!this.isWriteable(dest, name)) continue;
                try {
                    if (dest instanceof DynaBean) {
                        ((DynaBean)dest).set(name, entry.getValue());
                        continue;
                    }
                    this.setSimpleProperty(dest, name, entry.getValue());
                }
                catch (NoSuchMethodException e) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Error writing to '" + name + "' on class '" + dest.getClass() + "'"), (Throwable)e);
                }
            }
        } else {
            PropertyDescriptor[] origDescriptors = this.getPropertyDescriptors(orig);
            int i = 0;
            while (i < origDescriptors.length) {
                block23: {
                    String name = origDescriptors[i].getName();
                    if (this.isReadable(orig, name) && this.isWriteable(dest, name)) {
                        try {
                            Object value = this.getSimpleProperty(orig, name);
                            if (dest instanceof DynaBean) {
                                ((DynaBean)dest).set(name, value);
                            } else {
                                this.setSimpleProperty(dest, name, value);
                            }
                        }
                        catch (NoSuchMethodException e) {
                            if (!this.log.isDebugEnabled()) break block23;
                            this.log.debug((Object)("Error writing to '" + name + "' on class '" + dest.getClass() + "'"), (Throwable)e);
                        }
                    }
                }
                ++i;
            }
        }
    }

    public Map describe(Object bean) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        HashMap<String, Object> description = new HashMap<String, Object>();
        if (bean instanceof DynaBean) {
            DynaProperty[] descriptors = ((DynaBean)bean).getDynaClass().getDynaProperties();
            int i = 0;
            while (i < descriptors.length) {
                String name = descriptors[i].getName();
                description.put(name, this.getProperty(bean, name));
                ++i;
            }
        } else {
            PropertyDescriptor[] descriptors = this.getPropertyDescriptors(bean);
            int i = 0;
            while (i < descriptors.length) {
                String name = descriptors[i].getName();
                if (descriptors[i].getReadMethod() != null) {
                    description.put(name, this.getProperty(bean, name));
                }
                ++i;
            }
        }
        return description;
    }

    public Object getIndexedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getIndexedProperty(bean, name, index);
    }

    public Object getIndexedProperty(Object bean, String name, int index) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean.getClass().isArray()) {
                return Array.get(bean, index);
            }
            if (bean instanceof List) {
                return ((List)bean).get(index);
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            return ((DynaBean)bean).get(name, index);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            readMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod != null) {
                Object[] subscript = new Object[]{new Integer(index)};
                try {
                    return this.invokeMethod(readMethod, bean, subscript);
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof IndexOutOfBoundsException) {
                        throw (IndexOutOfBoundsException)e.getTargetException();
                    }
                    throw e;
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no " + "getter method on bean class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!value.getClass().isArray()) {
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            }
            return ((List)value).get(index);
        }
        try {
            return Array.get(value, index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ArrayIndexOutOfBoundsException("Index: " + index + ", Size: " + Array.getLength(value) + " for property '" + name + "'");
        }
    }

    public Object getMappedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "' " + e.getMessage());
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        return this.getMappedProperty(bean, name, key);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getMappedProperty(Object bean, String name, String key) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class " + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor != null) return ((DynaBean)bean).get(name, key);
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        Object result = null;
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "'+ on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method readMethod = ((MappedPropertyDescriptor)descriptor).getMappedReadMethod();
            readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object[] keyArray = new Object[]{key};
            return this.invokeMethod(readMethod, bean, keyArray);
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
        Object invokeResult = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!(invokeResult instanceof Map)) return result;
        return ((Map)invokeResult).get(key);
    }

    public FastHashMap getMappedPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            return null;
        }
        return (FastHashMap)this.mappedDescriptorsCache.get(beanClass);
    }

    public FastHashMap getMappedPropertyDescriptors(Object bean) {
        if (bean == null) {
            return null;
        }
        return this.getMappedPropertyDescriptors(bean.getClass());
    }

    /*
     * Unable to fully structure code
     */
    public Object getNestedProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name != null) ** GOTO lbl12
        throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
lbl-1000:
        // 1 sources

        {
            next = this.resolver.next(name);
            nestedBean = null;
            nestedBean = bean instanceof Map != false ? this.getPropertyOfMapBean((Map)bean, next) : (this.resolver.isMapped(next) != false ? this.getMappedProperty(bean, next) : (this.resolver.isIndexed(next) != false ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
lbl12:
            // 2 sources

            ** while (this.resolver.hasNested((String)name))
        }
lbl13:
        // 1 sources

        bean = bean instanceof Map != false ? this.getPropertyOfMapBean((Map)bean, name) : (this.resolver.isMapped(name) != false ? this.getMappedProperty(bean, name) : (this.resolver.isIndexed(name) != false ? this.getIndexedProperty(bean, name) : this.getSimpleProperty(bean, name)));
        return bean;
    }

    protected Object getPropertyOfMapBean(Map bean, String propertyName) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        return bean.get(propertyName);
    }

    public Object getProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return this.getNestedProperty(bean, name);
    }

    /*
     * Unable to fully structure code
     */
    public PropertyDescriptor getPropertyDescriptor(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name != null) ** GOTO lbl11
        throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
lbl-1000:
        // 1 sources

        {
            next = this.resolver.next(name);
            nestedBean = this.getProperty(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
lbl11:
            // 2 sources

            ** while (this.resolver.hasNested((String)name))
        }
lbl12:
        // 1 sources

        if ((name = this.resolver.getProperty(name)) == null) {
            return null;
        }
        descriptors = this.getPropertyDescriptors(bean);
        if (descriptors != null) {
            i = 0;
            while (i < descriptors.length) {
                if (name.equalsIgnoreCase(descriptors[i].getName())) {
                    return descriptors[i];
                }
                ++i;
            }
        }
        result = null;
        mappedDescriptors = this.getMappedPropertyDescriptors(bean);
        if (mappedDescriptors == null) {
            mappedDescriptors = new FastHashMap();
            mappedDescriptors.setFast(true);
            this.mappedDescriptorsCache.put(bean.getClass(), mappedDescriptors);
        }
        if ((result = (PropertyDescriptor)mappedDescriptors.get(name)) == null) {
            try {
                result = new MappedPropertyDescriptor(name, (Class)bean.getClass());
            }
            catch (IntrospectionException var6_7) {
                // empty catch block
            }
            if (result != null) {
                mappedDescriptors.put(name, result);
            }
        }
        return result;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class beanClass) {
        if (beanClass == null) {
            throw new IllegalArgumentException("No bean class specified");
        }
        PropertyDescriptor[] descriptors = null;
        descriptors = (PropertyDescriptor[])this.descriptorsCache.get(beanClass);
        if (descriptors != null) {
            return descriptors;
        }
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return new PropertyDescriptor[0];
        }
        descriptors = beanInfo.getPropertyDescriptors();
        if (descriptors == null) {
            descriptors = new PropertyDescriptor[]{};
        }
        int i = 0;
        while (i < descriptors.length) {
            if (descriptors[i] instanceof IndexedPropertyDescriptor) {
                String methodName;
                Method readMethod;
                IndexedPropertyDescriptor descriptor = (IndexedPropertyDescriptor)descriptors[i];
                String propName = String.valueOf(descriptor.getName().substring(0, 1).toUpperCase()) + descriptor.getName().substring(1);
                if (descriptor.getReadMethod() == null && (readMethod = MethodUtils.getMatchingAccessibleMethod(beanClass, methodName = descriptor.getIndexedReadMethod() != null ? descriptor.getIndexedReadMethod().getName() : "get" + propName, EMPTY_CLASS_PARAMETERS)) != null) {
                    try {
                        descriptor.setReadMethod(readMethod);
                    }
                    catch (Exception e) {
                        this.log.error((Object)"Error setting indexed property read method", (Throwable)e);
                    }
                }
                if (descriptor.getWriteMethod() == null) {
                    methodName = descriptor.getIndexedWriteMethod() != null ? descriptor.getIndexedWriteMethod().getName() : "set" + propName;
                    Method writeMethod = MethodUtils.getMatchingAccessibleMethod(beanClass, methodName, LIST_CLASS_PARAMETER);
                    if (writeMethod == null) {
                        Method[] methods = beanClass.getMethods();
                        int j = 0;
                        while (j < methods.length) {
                            Class<?>[] parameterTypes;
                            if (methods[j].getName().equals(methodName) && (parameterTypes = methods[j].getParameterTypes()).length == 1 && List.class.isAssignableFrom(parameterTypes[0])) {
                                writeMethod = methods[j];
                                break;
                            }
                            ++j;
                        }
                    }
                    if (writeMethod != null) {
                        try {
                            descriptor.setWriteMethod(writeMethod);
                        }
                        catch (Exception e) {
                            this.log.error((Object)"Error setting indexed property write method", (Throwable)e);
                        }
                    }
                }
            }
            ++i;
        }
        this.descriptorsCache.put(beanClass, descriptors);
        return descriptors;
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object bean) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        return this.getPropertyDescriptors(bean.getClass());
    }

    public Class getPropertyEditorClass(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor != null) {
            return descriptor.getPropertyEditorClass();
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Class getPropertyType(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name != null) ** GOTO lbl11
        throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
lbl-1000:
        // 1 sources

        {
            next = this.resolver.next(name);
            nestedBean = this.getProperty(bean, next);
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
lbl11:
            // 2 sources

            ** while (this.resolver.hasNested((String)name))
        }
lbl12:
        // 1 sources

        name = this.resolver.getProperty(name);
        if (bean instanceof DynaBean) {
            descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                return null;
            }
            type = descriptor.getType();
            if (type == null) {
                return null;
            }
            if (type.isArray()) {
                return type.getComponentType();
            }
            return type;
        }
        descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            return null;
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            return ((IndexedPropertyDescriptor)descriptor).getIndexedPropertyType();
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            return ((MappedPropertyDescriptor)descriptor).getMappedPropertyType();
        }
        return descriptor.getPropertyType();
    }

    public Method getReadMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getReadMethod());
    }

    Method getReadMethod(Class clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getReadMethod());
    }

    public Object getSimpleProperty(Object bean, String name) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            return ((DynaBean)bean).get(name);
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
        if (readMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method in class '" + bean.getClass() + "'");
        }
        Object value = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        return value;
    }

    public Method getWriteMethod(PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(descriptor.getWriteMethod());
    }

    Method getWriteMethod(Class clazz, PropertyDescriptor descriptor) {
        return MethodUtils.getAccessibleMethod(clazz, descriptor.getWriteMethod());
    }

    /*
     * Unable to fully structure code
     */
    public boolean isReadable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name != null) ** GOTO lbl20
        throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
lbl-1000:
        // 1 sources

        {
            next = this.resolver.next(name);
            nestedBean = null;
            try {
                nestedBean = this.getProperty(bean, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
lbl20:
            // 2 sources

            ** while (this.resolver.hasNested((String)name))
        }
lbl21:
        // 1 sources

        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                readMethod = this.getReadMethod(bean.getClass(), desc);
                if (readMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        readMethod = ((MappedPropertyDescriptor)desc).getMappedReadMethod();
                    }
                    readMethod = MethodUtils.getAccessibleMethod(bean.getClass(), readMethod);
                }
                return readMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean isWriteable(Object bean, String name) {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name != null) ** GOTO lbl20
        throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
lbl-1000:
        // 1 sources

        {
            next = this.resolver.next(name);
            nestedBean = null;
            try {
                nestedBean = this.getProperty(bean, next);
            }
            catch (IllegalAccessException e) {
                return false;
            }
            catch (InvocationTargetException e) {
                return false;
            }
            catch (NoSuchMethodException e) {
                return false;
            }
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + next + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
lbl20:
            // 2 sources

            ** while (this.resolver.hasNested((String)name))
        }
lbl21:
        // 1 sources

        name = this.resolver.getProperty(name);
        if (bean instanceof WrapDynaBean) {
            bean = ((WrapDynaBean)bean).getInstance();
        }
        if (bean instanceof DynaBean) {
            return ((DynaBean)bean).getDynaClass().getDynaProperty(name) != null;
        }
        try {
            desc = this.getPropertyDescriptor(bean, name);
            if (desc != null) {
                writeMethod = this.getWriteMethod(bean.getClass(), desc);
                if (writeMethod == null) {
                    if (desc instanceof IndexedPropertyDescriptor) {
                        writeMethod = ((IndexedPropertyDescriptor)desc).getIndexedWriteMethod();
                    } else if (desc instanceof MappedPropertyDescriptor) {
                        writeMethod = ((MappedPropertyDescriptor)desc).getMappedWriteMethod();
                    }
                    writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
                }
                return writeMethod != null;
            }
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public void setIndexedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        int index = -1;
        try {
            index = this.resolver.getIndex(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Invalid indexed property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setIndexedProperty(bean, name, index, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIndexedProperty(Object bean, String name, int index, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method readMethod;
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null || name.length() == 0) {
            if (bean.getClass().isArray()) {
                Array.set(bean, index, value);
                return;
            }
            if (bean instanceof List) {
                ((List)bean).set(index, value);
                return;
            }
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, index, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof IndexedPropertyDescriptor) {
            Method writeMethod = ((IndexedPropertyDescriptor)descriptor).getIndexedWriteMethod();
            writeMethod = MethodUtils.getAccessibleMethod(bean.getClass(), writeMethod);
            if (writeMethod != null) {
                Object[] subscript = new Object[]{new Integer(index), value};
                try {
                    if (this.log.isTraceEnabled()) {
                        String valueClassName = value == null ? "<null>" : value.getClass().getName();
                        this.log.trace((Object)("setSimpleProperty: Invoking method " + writeMethod + " with index=" + index + ", value=" + value + " (class " + valueClassName + ")"));
                    }
                    this.invokeMethod(writeMethod, bean, subscript);
                    return;
                }
                catch (InvocationTargetException e) {
                    if (!(e.getTargetException() instanceof IndexOutOfBoundsException)) throw e;
                    throw (IndexOutOfBoundsException)e.getTargetException();
                }
            }
        }
        if ((readMethod = this.getReadMethod(bean.getClass(), descriptor)) == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no getter method on bean class '" + bean.getClass() + "'");
        }
        Object array = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
        if (!array.getClass().isArray()) {
            if (!(array instanceof List)) throw new IllegalArgumentException("Property '" + name + "' is not indexed on bean class '" + bean.getClass() + "'");
            ((List)array).set(index, value);
            return;
        } else {
            Array.set(array, index, value);
        }
    }

    public void setMappedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        String key = null;
        try {
            key = this.resolver.getKey(name);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("Invalid mapped property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        name = this.resolver.getProperty(name);
        this.setMappedProperty(bean, name, key, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMappedProperty(Object bean, String name, String key, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (key == null) {
            throw new IllegalArgumentException("No key specified for property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            ((DynaBean)bean).set(name, key, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (descriptor instanceof MappedPropertyDescriptor) {
            Method mappedWriteMethod = ((MappedPropertyDescriptor)descriptor).getMappedWriteMethod();
            mappedWriteMethod = MethodUtils.getAccessibleMethod(bean.getClass(), mappedWriteMethod);
            if (mappedWriteMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped setter method" + "on bean class '" + bean.getClass() + "'");
            Object[] params = new Object[]{key, value};
            if (this.log.isTraceEnabled()) {
                String valueClassName = value == null ? "<null>" : value.getClass().getName();
                this.log.trace((Object)("setSimpleProperty: Invoking method " + mappedWriteMethod + " with key=" + key + ", value=" + value + " (class " + valueClassName + ")"));
            }
            this.invokeMethod(mappedWriteMethod, bean, params);
            return;
        } else {
            Method readMethod = this.getReadMethod(bean.getClass(), descriptor);
            if (readMethod == null) throw new NoSuchMethodException("Property '" + name + "' has no mapped getter method on bean class '" + bean.getClass() + "'");
            Object invokeResult = this.invokeMethod(readMethod, bean, EMPTY_OBJECT_ARRAY);
            if (!(invokeResult instanceof Map)) return;
            ((Map)invokeResult).put(key, value);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void setNestedProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name != null) ** GOTO lbl12
        throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
lbl-1000:
        // 1 sources

        {
            next = this.resolver.next(name);
            nestedBean = null;
            nestedBean = bean instanceof Map != false ? this.getPropertyOfMapBean((Map)bean, next) : (this.resolver.isMapped(next) != false ? this.getMappedProperty(bean, next) : (this.resolver.isIndexed(next) != false ? this.getIndexedProperty(bean, next) : this.getSimpleProperty(bean, next)));
            if (nestedBean == null) {
                throw new NestedNullException("Null property value for '" + name + "' on bean class '" + bean.getClass() + "'");
            }
            bean = nestedBean;
            name = this.resolver.remove(name);
lbl12:
            // 2 sources

            ** while (this.resolver.hasNested((String)name))
        }
lbl13:
        // 1 sources

        if (bean instanceof Map) {
            this.setPropertyOfMapBean((Map)bean, name, value);
        } else if (this.resolver.isMapped(name)) {
            this.setMappedProperty(bean, name, value);
        } else if (this.resolver.isIndexed(name)) {
            this.setIndexedProperty(bean, name, value);
        } else {
            this.setSimpleProperty(bean, name, value);
        }
    }

    protected void setPropertyOfMapBean(Map bean, String propertyName, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        String name;
        if (this.resolver.isMapped(propertyName) && ((name = this.resolver.getProperty(propertyName)) == null || name.length() == 0)) {
            propertyName = this.resolver.getKey(propertyName);
        }
        if (this.resolver.isIndexed(propertyName) || this.resolver.isMapped(propertyName)) {
            throw new IllegalArgumentException("Indexed or mapped properties are not supported on objects of type Map: " + propertyName);
        }
        bean.put(propertyName, value);
    }

    public void setProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        this.setNestedProperty(bean, name, value);
    }

    public void setSimpleProperty(Object bean, String name, Object value) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (bean == null) {
            throw new IllegalArgumentException("No bean specified");
        }
        if (name == null) {
            throw new IllegalArgumentException("No name specified for bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.hasNested(name)) {
            throw new IllegalArgumentException("Nested property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isIndexed(name)) {
            throw new IllegalArgumentException("Indexed property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (this.resolver.isMapped(name)) {
            throw new IllegalArgumentException("Mapped property names are not allowed: Property '" + name + "' on bean class '" + bean.getClass() + "'");
        }
        if (bean instanceof DynaBean) {
            DynaProperty descriptor = ((DynaBean)bean).getDynaClass().getDynaProperty(name);
            if (descriptor == null) {
                throw new NoSuchMethodException("Unknown property '" + name + "' on dynaclass '" + ((DynaBean)bean).getDynaClass() + "'");
            }
            ((DynaBean)bean).set(name, value);
            return;
        }
        PropertyDescriptor descriptor = this.getPropertyDescriptor(bean, name);
        if (descriptor == null) {
            throw new NoSuchMethodException("Unknown property '" + name + "' on class '" + bean.getClass() + "'");
        }
        Method writeMethod = this.getWriteMethod(bean.getClass(), descriptor);
        if (writeMethod == null) {
            throw new NoSuchMethodException("Property '" + name + "' has no setter method in class '" + bean.getClass() + "'");
        }
        Object[] values = new Object[]{value};
        if (this.log.isTraceEnabled()) {
            String valueClassName = value == null ? "<null>" : value.getClass().getName();
            this.log.trace((Object)("setSimpleProperty: Invoking method " + writeMethod + " with value " + value + " (class " + valueClassName + ")"));
        }
        this.invokeMethod(writeMethod, bean, values);
    }

    /*
     * Unable to fully structure code
     */
    private Object invokeMethod(Method method, Object bean, Object[] values) throws IllegalAccessException, InvocationTargetException {
        block17: {
            block16: {
                if (bean == null) {
                    throw new IllegalArgumentException("No bean specified - this should have been checked before reaching this method");
                }
                try {
                    return method.invoke(bean, values);
                }
                catch (NullPointerException cause) {
                    valueString = "";
                    if (values == null) break block16;
                    i = 0;
                    ** while (i < values.length)
                }
lbl-1000:
                // 1 sources

                {
                    if (i > 0) {
                        valueString = String.valueOf(valueString) + ", ";
                    }
                    valueString = values[i] == null ? String.valueOf(valueString) + "<null>" : String.valueOf(valueString) + values[i].getClass().getName();
                    ++i;
                    continue;
                }
            }
            expectedString = "";
            parTypes = method.getParameterTypes();
            if (parTypes != null) {
                i = 0;
                while (i < parTypes.length) {
                    if (i > 0) {
                        expectedString = String.valueOf(expectedString) + ", ";
                    }
                    expectedString = String.valueOf(expectedString) + parTypes[i].getName();
                    ++i;
                }
            }
            if (!BeanUtils.initCause(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
                this.log.error((Object)"Method invocation failed", (Throwable)cause);
            }
            throw e;
            catch (IllegalArgumentException cause) {
                valueString = "";
                if (values == null) break block17;
                i = 0;
                ** while (i < values.length)
            }
lbl-1000:
            // 1 sources

            {
                if (i > 0) {
                    valueString = String.valueOf(valueString) + ", ";
                }
                valueString = values[i] == null ? String.valueOf(valueString) + "<null>" : String.valueOf(valueString) + values[i].getClass().getName();
                ++i;
                continue;
            }
        }
        expectedString = "";
        parTypes = method.getParameterTypes();
        if (parTypes != null) {
            i = 0;
            while (i < parTypes.length) {
                if (i > 0) {
                    expectedString = String.valueOf(expectedString) + ", ";
                }
                expectedString = String.valueOf(expectedString) + parTypes[i].getName();
                ++i;
            }
        }
        if (!BeanUtils.initCause(e = new IllegalArgumentException("Cannot invoke " + method.getDeclaringClass().getName() + "." + method.getName() + " on bean class '" + bean.getClass() + "' - " + cause.getMessage() + " - had objects of type \"" + valueString + "\" but expected signature \"" + expectedString + "\""), cause)) {
            this.log.error((Object)"Method invocation failed", (Throwable)cause);
        }
        throw e;
    }
}

