/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.status;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.snapshots.status.SnapshotIndexShardStatus;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.BaseNodeResponse;
import org.elasticsearch.action.support.nodes.BaseNodesRequest;
import org.elasticsearch.action.support.nodes.BaseNodesResponse;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.SnapshotId;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.snapshots.SnapshotShardsService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesSnapshotsStatus
extends TransportNodesAction<Request, NodesSnapshotStatus, NodeRequest, NodeSnapshotStatus> {
    public static final String ACTION_NAME = "cluster:admin/snapshot/status[nodes]";
    private final SnapshotShardsService snapshotShardsService;

    @Inject
    public TransportNodesSnapshotsStatus(Settings settings, ClusterName clusterName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, SnapshotShardsService snapshotShardsService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, clusterName, threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, Request.class, NodeRequest.class, "generic");
        this.snapshotShardsService = snapshotShardsService;
    }

    @Override
    protected boolean transportCompress() {
        return true;
    }

    @Override
    protected NodeRequest newNodeRequest(String nodeId, Request request) {
        return new NodeRequest(nodeId, request);
    }

    @Override
    protected NodeSnapshotStatus newNodeResponse() {
        return new NodeSnapshotStatus();
    }

    @Override
    protected NodesSnapshotStatus newResponse(Request request, AtomicReferenceArray responses) {
        ArrayList<NodeSnapshotStatus> nodesList = new ArrayList<NodeSnapshotStatus>();
        ArrayList<FailedNodeException> failures = new ArrayList<FailedNodeException>();
        for (int i = 0; i < responses.length(); ++i) {
            Object resp = responses.get(i);
            if (resp instanceof NodeSnapshotStatus) {
                nodesList.add((NodeSnapshotStatus)resp);
                continue;
            }
            if (resp instanceof FailedNodeException) {
                failures.add((FailedNodeException)resp);
                continue;
            }
            this.logger.warn("unknown response type [{}], expected NodeSnapshotStatus or FailedNodeException", resp);
        }
        return new NodesSnapshotStatus(this.clusterName, nodesList.toArray(new NodeSnapshotStatus[nodesList.size()]), failures.toArray(new FailedNodeException[failures.size()]));
    }

    @Override
    protected NodeSnapshotStatus nodeOperation(NodeRequest request) {
        ImmutableMap.Builder snapshotMapBuilder = ImmutableMap.builder();
        try {
            String nodeId = this.clusterService.localNode().id();
            for (SnapshotId snapshotId : request.snapshotIds) {
                Map<ShardId, IndexShardSnapshotStatus> shardsStatus = this.snapshotShardsService.currentSnapshotShards(snapshotId);
                if (shardsStatus == null) continue;
                ImmutableMap.Builder shardMapBuilder = ImmutableMap.builder();
                for (Map.Entry<ShardId, IndexShardSnapshotStatus> shardEntry : shardsStatus.entrySet()) {
                    IndexShardSnapshotStatus.Stage stage = shardEntry.getValue().stage();
                    SnapshotIndexShardStatus shardStatus = stage != IndexShardSnapshotStatus.Stage.DONE && stage != IndexShardSnapshotStatus.Stage.FAILURE ? new SnapshotIndexShardStatus(shardEntry.getKey(), shardEntry.getValue(), nodeId) : new SnapshotIndexShardStatus(shardEntry.getKey(), shardEntry.getValue());
                    shardMapBuilder.put((Object)shardEntry.getKey(), (Object)shardStatus);
                }
                snapshotMapBuilder.put((Object)snapshotId, (Object)shardMapBuilder.build());
            }
            return new NodeSnapshotStatus(this.clusterService.localNode(), (ImmutableMap<SnapshotId, ImmutableMap<ShardId, SnapshotIndexShardStatus>>)snapshotMapBuilder.build());
        }
        catch (Exception e) {
            throw new ElasticsearchException("failed to load metadata", (Throwable)e, new Object[0]);
        }
    }

    @Override
    protected boolean accumulateExceptions() {
        return true;
    }

    public static class NodeSnapshotStatus
    extends BaseNodeResponse {
        private ImmutableMap<SnapshotId, ImmutableMap<ShardId, SnapshotIndexShardStatus>> status;

        NodeSnapshotStatus() {
        }

        public NodeSnapshotStatus(DiscoveryNode node, ImmutableMap<SnapshotId, ImmutableMap<ShardId, SnapshotIndexShardStatus>> status) {
            super(node);
            this.status = status;
        }

        public ImmutableMap<SnapshotId, ImmutableMap<ShardId, SnapshotIndexShardStatus>> status() {
            return this.status;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int numberOfSnapshots = in.readVInt();
            ImmutableMap.Builder snapshotMapBuilder = ImmutableMap.builder();
            for (int i = 0; i < numberOfSnapshots; ++i) {
                SnapshotId snapshotId = SnapshotId.readSnapshotId(in);
                ImmutableMap.Builder shardMapBuilder = ImmutableMap.builder();
                int numberOfShards = in.readVInt();
                for (int j = 0; j < numberOfShards; ++j) {
                    ShardId shardId = ShardId.readShardId(in);
                    SnapshotIndexShardStatus status = SnapshotIndexShardStatus.readShardSnapshotStatus(in);
                    shardMapBuilder.put((Object)shardId, (Object)status);
                }
                snapshotMapBuilder.put((Object)snapshotId, (Object)shardMapBuilder.build());
            }
            this.status = snapshotMapBuilder.build();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.status != null) {
                out.writeVInt(this.status.size());
                for (Map.Entry entry : this.status.entrySet()) {
                    ((SnapshotId)entry.getKey()).writeTo(out);
                    out.writeVInt(((ImmutableMap)entry.getValue()).size());
                    for (Map.Entry shardEntry : ((ImmutableMap)entry.getValue()).entrySet()) {
                        ((ShardId)shardEntry.getKey()).writeTo(out);
                        ((SnapshotIndexShardStatus)shardEntry.getValue()).writeTo(out);
                    }
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class NodeRequest
    extends BaseNodeRequest {
        private SnapshotId[] snapshotIds;

        public NodeRequest() {
        }

        NodeRequest(String nodeId, Request request) {
            super(request, nodeId);
            this.snapshotIds = request.snapshotIds;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            int n = in.readVInt();
            this.snapshotIds = new SnapshotId[n];
            for (int i = 0; i < n; ++i) {
                this.snapshotIds[i] = SnapshotId.readSnapshotId(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (this.snapshotIds != null) {
                out.writeVInt(this.snapshotIds.length);
                for (int i = 0; i < this.snapshotIds.length; ++i) {
                    this.snapshotIds[i].writeTo(out);
                }
            } else {
                out.writeVInt(0);
            }
        }
    }

    public static class NodesSnapshotStatus
    extends BaseNodesResponse<NodeSnapshotStatus> {
        private FailedNodeException[] failures;

        NodesSnapshotStatus() {
        }

        public NodesSnapshotStatus(ClusterName clusterName, NodeSnapshotStatus[] nodes, FailedNodeException[] failures) {
            super(clusterName, (BaseNodeResponse[])nodes);
            this.failures = failures;
        }

        @Override
        public FailedNodeException[] failures() {
            return this.failures;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.nodes = new NodeSnapshotStatus[in.readVInt()];
            for (int i = 0; i < ((NodeSnapshotStatus[])this.nodes).length; ++i) {
                ((NodeSnapshotStatus[])this.nodes)[i] = new NodeSnapshotStatus();
                ((NodeSnapshotStatus[])this.nodes)[i].readFrom(in);
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeVInt(((NodeSnapshotStatus[])this.nodes).length);
            for (NodeSnapshotStatus response : (NodeSnapshotStatus[])this.nodes) {
                response.writeTo(out);
            }
        }
    }

    public static class Request
    extends BaseNodesRequest<Request> {
        private SnapshotId[] snapshotIds;

        public Request() {
        }

        public Request(ActionRequest request, String[] nodesIds) {
            super(request, nodesIds);
        }

        public Request snapshotIds(SnapshotId[] snapshotIds) {
            this.snapshotIds = snapshotIds;
            return this;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            throw new UnsupportedOperationException("shouldn't be here");
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            throw new UnsupportedOperationException("shouldn't be here");
        }
    }
}

