/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.FieldDataType;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.TypeParsers;

public class RoutingFieldMapper
extends MetadataFieldMapper {
    public static final String NAME = "_routing";
    public static final String CONTENT_TYPE = "_routing";
    private boolean required;
    private final String path;

    private RoutingFieldMapper(Settings indexSettings, MappedFieldType existing) {
        this(existing == null ? Defaults.FIELD_TYPE.clone() : existing.clone(), false, Defaults.PATH, indexSettings);
    }

    private RoutingFieldMapper(MappedFieldType fieldType, boolean required, String path, Settings indexSettings) {
        super("_routing", fieldType, Defaults.FIELD_TYPE, indexSettings);
        this.required = required;
        this.path = path;
    }

    public void markAsRequired() {
        this.required = true;
    }

    public boolean required() {
        return this.required;
    }

    public String path() {
        return this.path;
    }

    public String value(Document document) {
        Field field = (Field)document.getField(this.fieldType().names().indexName());
        return field == null ? null : (String)this.fieldType().value(field);
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
    }

    @Override
    public Mapper parse(ParseContext context) throws IOException {
        return null;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<Field> fields) throws IOException {
        String routing;
        if (context.sourceToParse().routing() != null && (routing = context.sourceToParse().routing()) != null) {
            if (this.fieldType().indexOptions() == IndexOptions.NONE && !this.fieldType().stored()) {
                context.ignoredValue(this.fieldType().names().indexName(), routing);
                return;
            }
            fields.add(new Field(this.fieldType().names().indexName(), routing, (FieldType)this.fieldType()));
        }
    }

    @Override
    protected String contentType() {
        return "_routing";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        boolean indexedDefault;
        boolean includeDefaults = params.paramAsBoolean("include_defaults", false);
        boolean indexed = this.fieldType().indexOptions() != IndexOptions.NONE;
        boolean bl = indexedDefault = Defaults.FIELD_TYPE.indexOptions() != IndexOptions.NONE;
        if (!includeDefaults && indexed == indexedDefault && this.fieldType().stored() == Defaults.FIELD_TYPE.stored() && !this.required && this.path == Defaults.PATH) {
            return builder;
        }
        builder.startObject("_routing");
        if (this.indexCreatedBefore2x && (includeDefaults || indexed != indexedDefault)) {
            builder.field("index", RoutingFieldMapper.indexTokenizeOptionToString(indexed, this.fieldType().tokenized()));
        }
        if (this.indexCreatedBefore2x && (includeDefaults || this.fieldType().stored() != Defaults.FIELD_TYPE.stored())) {
            builder.field("store", this.fieldType().stored());
        }
        if (includeDefaults || this.required) {
            builder.field("required", this.required);
        }
        if (this.indexCreatedBefore2x && (includeDefaults || this.path != Defaults.PATH)) {
            builder.field("path", this.path);
        }
        builder.endObject();
        return builder;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
    }

    static final class RoutingFieldType
    extends MappedFieldType {
        public RoutingFieldType() {
            this.setFieldDataType(new FieldDataType("string"));
        }

        protected RoutingFieldType(RoutingFieldType ref) {
            super(ref);
        }

        @Override
        public MappedFieldType clone() {
            return new RoutingFieldType(this);
        }

        @Override
        public String typeName() {
            return "_routing";
        }

        @Override
        public String value(Object value) {
            if (value == null) {
                return null;
            }
            return value.toString();
        }
    }

    public static class TypeParser
    implements MetadataFieldMapper.TypeParser {
        public MetadataFieldMapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(parserContext.mapperService().fullName("_routing"));
            if (parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) {
                TypeParsers.parseField(builder, builder.name, node, parserContext);
            }
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("required")) {
                    builder.required(XContentMapValues.nodeBooleanValue(fieldNode));
                    iterator.remove();
                    continue;
                }
                if (!fieldName.equals("path") || !parserContext.indexVersionCreated().before(Version.V_2_0_0_beta1)) continue;
                builder.path(fieldNode.toString());
                iterator.remove();
            }
            return builder;
        }

        @Override
        public MetadataFieldMapper getDefault(Settings indexSettings, MappedFieldType fieldType, String typeName) {
            return new RoutingFieldMapper(indexSettings, fieldType);
        }
    }

    public static class Builder
    extends MetadataFieldMapper.Builder<Builder, RoutingFieldMapper> {
        private boolean required = false;
        private String path = Defaults.PATH;

        public Builder(MappedFieldType existing) {
            super("_routing", existing == null ? Defaults.FIELD_TYPE : existing, Defaults.FIELD_TYPE);
        }

        public Builder required(boolean required) {
            this.required = required;
            return (Builder)this.builder;
        }

        public Builder path(String path) {
            this.path = path;
            return (Builder)this.builder;
        }

        @Override
        public RoutingFieldMapper build(Mapper.BuilderContext context) {
            return new RoutingFieldMapper(this.fieldType, this.required, this.path, context.indexSettings());
        }
    }

    public static class Defaults {
        public static final String NAME = "_routing";
        public static final MappedFieldType FIELD_TYPE = new RoutingFieldType();
        public static final boolean REQUIRED = false;
        public static final String PATH;

        static {
            FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE.setTokenized(false);
            FIELD_TYPE.setStored(true);
            FIELD_TYPE.setOmitNorms(true);
            FIELD_TYPE.setIndexAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setSearchAnalyzer(Lucene.KEYWORD_ANALYZER);
            FIELD_TYPE.setNames(new MappedFieldType.Names("_routing"));
            FIELD_TYPE.freeze();
            PATH = null;
        }
    }
}

