/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import jxl.format.PageOrientation;
import jxl.format.PaperSize;

public final class SheetSettings {
    private PageOrientation orientation;
    private PaperSize paperSize;
    private boolean sheetProtected;
    private boolean hidden;
    private boolean selected;
    private double headerMargin;
    private double footerMargin;
    private int scaleFactor;
    private int pageStart;
    private int fitWidth;
    private int fitHeight;
    private int horizontalPrintResolution;
    private int verticalPrintResolution;
    private double leftMargin;
    private double rightMargin;
    private double topMargin;
    private double bottomMargin;
    private static final PageOrientation defaultOrientation = PageOrientation.PORTRAIT;
    private static final PaperSize defaultPaperSize = PaperSize.A4;
    private static final double defaultHeaderMargin = 0.5;
    private static final double defaultFooterMargin = 0.5;
    private static final int defaultPrintResolution = 300;
    private static final double defaultWidthMargin = 0.75;
    private static final double defaultHeightMargin = 1.0;

    public SheetSettings() {
        this.orientation = defaultOrientation;
        this.paperSize = defaultPaperSize;
        this.sheetProtected = false;
        this.hidden = false;
        this.selected = false;
        this.headerMargin = 0.5;
        this.footerMargin = 0.5;
        this.horizontalPrintResolution = 300;
        this.verticalPrintResolution = 300;
        this.leftMargin = 0.75;
        this.rightMargin = 0.75;
        this.topMargin = 1.0;
        this.bottomMargin = 1.0;
    }

    public SheetSettings(SheetSettings copy) {
        this.orientation = copy.orientation;
        this.paperSize = copy.paperSize;
        this.sheetProtected = copy.sheetProtected;
        this.hidden = copy.hidden;
        this.selected = false;
        this.headerMargin = copy.headerMargin;
        this.footerMargin = copy.footerMargin;
        this.scaleFactor = copy.scaleFactor;
        this.pageStart = copy.pageStart;
        this.fitWidth = copy.fitWidth;
        this.fitHeight = copy.fitHeight;
        this.horizontalPrintResolution = copy.horizontalPrintResolution;
        this.verticalPrintResolution = copy.verticalPrintResolution;
        this.leftMargin = copy.leftMargin;
        this.rightMargin = copy.rightMargin;
        this.topMargin = copy.topMargin;
        this.bottomMargin = copy.bottomMargin;
    }

    public void setOrientation(PageOrientation po) {
        this.orientation = po;
    }

    public PageOrientation getOrientation() {
        return this.orientation;
    }

    public void setPaperSize(PaperSize ps) {
        this.paperSize = ps;
    }

    public PaperSize getPaperSize() {
        return this.paperSize;
    }

    public boolean isProtected() {
        return this.sheetProtected;
    }

    public void setProtected(boolean p) {
        this.sheetProtected = p;
    }

    public void setHeaderMargin(double d) {
        this.headerMargin = d;
    }

    public double getHeaderMargin() {
        return this.headerMargin;
    }

    public void setFooterMargin(double d) {
        this.footerMargin = d;
    }

    public double getFooterMargin() {
        return this.footerMargin;
    }

    public void setHidden(boolean h) {
        this.hidden = h;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setSelected() {
        this.selected = true;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setScaleFactor(int sf) {
        this.scaleFactor = sf;
    }

    public int getScaleFactor() {
        return this.scaleFactor;
    }

    public void setPageStart(int ps) {
        this.pageStart = ps;
    }

    public int getPageStart() {
        return this.pageStart;
    }

    public void setFitWidth(int fw) {
        this.fitWidth = fw;
    }

    public int getFitWidth() {
        return this.fitWidth;
    }

    public void setFitHeight(int fh) {
        this.fitHeight = fh;
    }

    public int getFitHeight() {
        return this.fitHeight;
    }

    public void setHorizontalPrintResolution(int hpw) {
        this.horizontalPrintResolution = hpw;
    }

    public int getHorizontalPrintResolution() {
        return this.horizontalPrintResolution;
    }

    public void setVerticalPrintResolution(int vpw) {
        this.verticalPrintResolution = vpw;
    }

    public int getVerticalPrintResolution() {
        return this.verticalPrintResolution;
    }

    public void setRightMargin(double m) {
        this.rightMargin = m;
    }

    public double getRightMargin() {
        return this.rightMargin;
    }

    public void setLeftMargin(double m) {
        this.leftMargin = m;
    }

    public double getLeftMargin() {
        return this.leftMargin;
    }

    public void setTopMargin(double m) {
        this.topMargin = m;
    }

    public double getTopMargin() {
        return this.topMargin;
    }

    public void setBottomMargin(double m) {
        this.bottomMargin = m;
    }

    public double getBottomMargin() {
        return this.bottomMargin;
    }

    public double getDefaultWidthMargin() {
        return 0.75;
    }

    public double getDefaultHeightMargin() {
        return 1.0;
    }
}

