/*
 * Decompiled with CFR 0.152.
 */
package jxl;

import java.util.Locale;

public final class WorkbookSettings {
    private int initialFileSize;
    private int arrayGrowSize;
    private boolean chartsDisabled;
    private boolean namesDisabled;
    private boolean gcDisabled;
    private Locale locale;
    private static final int defaultInitialFileSize = 0x500000;
    private static final int defaultArrayGrowSize = 0x100000;

    public WorkbookSettings() {
        block5: {
            this.initialFileSize = 0x500000;
            this.arrayGrowSize = 0x100000;
            try {
                this.chartsDisabled = Boolean.getBoolean("jxl.nocharts");
                this.namesDisabled = Boolean.getBoolean("jxl.nonames");
                this.gcDisabled = Boolean.getBoolean("jxl.nogc");
            }
            catch (SecurityException e) {
                System.err.println("Warning:  error accessing system properties");
            }
            try {
                if (System.getProperty("jxl.lang") == null || System.getProperty("jxl.country") == null) {
                    this.locale = Locale.getDefault();
                    break block5;
                }
                this.locale = new Locale(System.getProperty("jxl.lang"), System.getProperty("jxl.country"));
                Locale.setDefault(this.locale);
            }
            catch (SecurityException e) {
                System.err.println("Warning:  error accessing system properties");
                this.locale = Locale.getDefault();
            }
        }
    }

    public void setArrayGrowSize(int sz) {
        this.arrayGrowSize = sz;
    }

    public int getArrayGrowSize() {
        return this.arrayGrowSize;
    }

    public void setInitialFileSize(int sz) {
        this.initialFileSize = sz;
    }

    public int getInitialFileSize() {
        return this.initialFileSize;
    }

    public boolean getChartsDisabled() {
        return this.chartsDisabled;
    }

    public boolean getGCDisabled() {
        return this.gcDisabled;
    }

    public boolean getNamesDisabled() {
        return this.namesDisabled;
    }

    public void setLocale(Locale l) {
        this.locale = l;
    }

    public Locale getLocale() {
        return this.locale;
    }
}

