/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.biff.DisplayFormat;
import jxl.biff.IntegerHelper;
import jxl.biff.StringHelper;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.read.biff.Record;

public class FormatRecord
extends WritableRecordData
implements DisplayFormat,
jxl.format.Format {
    private boolean initialized;
    private byte[] data;
    private int indexCode;
    private String formatString;
    private boolean date;
    private boolean number;
    private Format format;
    private static String[] dateStrings = new String[]{"dd", "mm", "yy", "hh", "ss", "m/", "/d"};
    public static final BiffType biff8 = new BiffType();
    public static final BiffType biff7 = new BiffType();

    FormatRecord(String fmt, int refno) {
        super(Type.FORMAT);
        this.formatString = fmt;
        this.indexCode = refno;
        this.initialized = true;
    }

    protected FormatRecord() {
        super(Type.FORMAT);
        this.initialized = false;
    }

    public FormatRecord(Record t, BiffType biffType) {
        super(t);
        int numchars;
        byte[] data = this.getRecord().getData();
        this.indexCode = IntegerHelper.getInt(data[0], data[1]);
        this.initialized = true;
        if (biffType == biff8) {
            numchars = IntegerHelper.getInt(data[2], data[3]);
            this.formatString = data[4] == 0 ? StringHelper.getString(data, numchars, 5) : StringHelper.getUnicodeString(data, numchars, 5);
        } else {
            numchars = data[2];
            byte[] chars = new byte[numchars];
            System.arraycopy(data, 3, chars, 0, chars.length);
            this.formatString = new String(chars);
        }
        this.date = false;
        this.number = false;
        int i = 0;
        while (i < dateStrings.length) {
            if (this.formatString.indexOf(dateStrings[i]) != -1) {
                this.date = true;
            }
            ++i;
        }
        if (!(this.date || this.formatString.indexOf(35) == -1 && this.formatString.indexOf(48) == -1)) {
            this.number = true;
        }
    }

    public byte[] getData() {
        this.data = new byte[this.formatString.length() * 2 + 3 + 2];
        IntegerHelper.getTwoBytes(this.indexCode, this.data, 0);
        IntegerHelper.getTwoBytes(this.formatString.length(), this.data, 2);
        this.data[4] = 1;
        StringHelper.getUnicodeBytes(this.formatString, this.data, 5);
        return this.data;
    }

    public int getFormatIndex() {
        return this.indexCode;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize(int pos) {
        this.indexCode = pos;
        this.initialized = true;
    }

    protected final String replace(String input, String search, String replace) {
        String formatString = input;
        int pos = formatString.indexOf(search);
        while (pos != -1) {
            StringBuffer tmp = new StringBuffer(formatString.substring(0, pos));
            tmp.append(replace);
            tmp.append(formatString.substring(pos + search.length()));
            formatString = tmp.toString();
            pos = formatString.indexOf(search);
        }
        return formatString;
    }

    protected final void setFormatString(String s) {
        this.formatString = s;
    }

    public final boolean isDate() {
        return this.date;
    }

    public final boolean isNumber() {
        return this.number;
    }

    public final NumberFormat getNumberFormat() {
        if (this.format != null && this.format instanceof NumberFormat) {
            return (NumberFormat)this.format;
        }
        try {
            String fs = this.formatString;
            fs = this.replace(fs, "E+", "E");
            fs = this.replace(fs, "_)", "");
            fs = this.replace(fs, "[Red]", "");
            fs = this.replace(fs, "\\", "");
            this.format = new DecimalFormat(fs);
        }
        catch (IllegalArgumentException e) {
            this.format = new DecimalFormat("#.###");
        }
        return (NumberFormat)this.format;
    }

    public final DateFormat getDateFormat() {
        StringBuffer sb;
        if (this.format != null && this.format instanceof DateFormat) {
            return (DateFormat)this.format;
        }
        String fmt = this.formatString;
        int pos = fmt.indexOf("AM/PM");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append('a');
            sb.append(fmt.substring(pos + 5));
            fmt = sb.toString();
            pos = fmt.indexOf("AM/PM");
        }
        pos = fmt.indexOf("ss.0");
        while (pos != -1) {
            sb = new StringBuffer(fmt.substring(0, pos));
            sb.append("ss.SSS");
            pos += 4;
            while (pos < fmt.length() && fmt.charAt(pos) == '0') {
                ++pos;
            }
            sb.append(fmt.substring(pos));
            fmt = sb.toString();
            pos = fmt.indexOf("ss.0");
        }
        sb = new StringBuffer();
        int i = 0;
        while (i < fmt.length()) {
            if (fmt.charAt(i) != '\\') {
                sb.append(fmt.charAt(i));
            }
            ++i;
        }
        fmt = sb.toString();
        char[] format = fmt.toCharArray();
        int i2 = 0;
        while (i2 < format.length) {
            if (format[i2] == 'm') {
                if (i2 > 0 && (format[i2 - 1] == 'm' || format[i2 - 1] == 'M')) {
                    format[i2] = format[i2 - 1];
                } else {
                    char ind;
                    int minuteDist = Integer.MAX_VALUE;
                    int j = i2 - 1;
                    while (j > 0) {
                        if (format[j] == 'h') {
                            minuteDist = i2 - j;
                            break;
                        }
                        --j;
                    }
                    int j2 = i2 + 1;
                    while (j2 < format.length) {
                        if (format[j2] == 'h') {
                            minuteDist = Math.min(minuteDist, j2 - i2);
                            break;
                        }
                        ++j2;
                    }
                    int j3 = i2 - 1;
                    while (j3 > 0) {
                        if (format[j3] == 'H') {
                            minuteDist = i2 - j3;
                            break;
                        }
                        --j3;
                    }
                    int j4 = i2 + 1;
                    while (j4 < format.length) {
                        if (format[j4] == 'H') {
                            minuteDist = Math.min(minuteDist, j4 - i2);
                            break;
                        }
                        ++j4;
                    }
                    int j5 = i2 - 1;
                    while (j5 > 0) {
                        if (format[j5] == 's') {
                            minuteDist = Math.min(minuteDist, i2 - j5);
                            break;
                        }
                        --j5;
                    }
                    int j6 = i2 + 1;
                    while (j6 < format.length) {
                        if (format[j6] == 's') {
                            minuteDist = Math.min(minuteDist, j6 - i2);
                            break;
                        }
                        ++j6;
                    }
                    int monthDist = Integer.MAX_VALUE;
                    int j7 = i2 - 1;
                    while (j7 > 0) {
                        if (format[j7] == 'd') {
                            monthDist = i2 - j7;
                            break;
                        }
                        --j7;
                    }
                    int j8 = i2 + 1;
                    while (j8 < format.length) {
                        if (format[j8] == 'd') {
                            monthDist = Math.min(monthDist, j8 - i2);
                            break;
                        }
                        ++j8;
                    }
                    int j9 = i2 - 1;
                    while (j9 > 0) {
                        if (format[j9] == 'y') {
                            monthDist = Math.min(monthDist, i2 - j9);
                            break;
                        }
                        --j9;
                    }
                    int j10 = i2 + 1;
                    while (j10 < format.length) {
                        if (format[j10] == 'y') {
                            monthDist = Math.min(monthDist, j10 - i2);
                            break;
                        }
                        ++j10;
                    }
                    if (monthDist < minuteDist) {
                        format[i2] = Character.toUpperCase(format[i2]);
                    } else if (monthDist == minuteDist && monthDist != Integer.MAX_VALUE && ((ind = format[i2 - monthDist]) == 'y' || ind == 'd')) {
                        format[i2] = Character.toUpperCase(format[i2]);
                    }
                }
            }
            ++i2;
        }
        try {
            this.format = new SimpleDateFormat(new String(format));
        }
        catch (IllegalArgumentException e) {
            this.format = new SimpleDateFormat("dd MM yyyy hh:mm:ss");
        }
        return (DateFormat)this.format;
    }

    public int getIndexCode() {
        return this.indexCode;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public boolean isBuiltIn() {
        return false;
    }

    private static class BiffType {
        private BiffType() {
        }
    }
}

