/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff;

import common.Assert;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import jxl.biff.BuiltInFormat;
import jxl.biff.DisplayFormat;
import jxl.biff.FontRecord;
import jxl.biff.Fonts;
import jxl.biff.FormattingRecords;
import jxl.biff.IntegerHelper;
import jxl.biff.NumFormatRecordsException;
import jxl.biff.Type;
import jxl.biff.WritableRecordData;
import jxl.format.Alignment;
import jxl.format.Border;
import jxl.format.BorderLineStyle;
import jxl.format.CellFormat;
import jxl.format.Colour;
import jxl.format.Font;
import jxl.format.Format;
import jxl.format.Orientation;
import jxl.format.Pattern;
import jxl.format.VerticalAlignment;
import jxl.read.biff.Record;

public class XFRecord
extends WritableRecordData
implements CellFormat {
    private int formatIndex;
    private boolean date;
    private boolean number;
    private DateFormat dateFormat;
    private NumberFormat numberFormat;
    private int fontIndex;
    private boolean locked;
    private boolean hidden;
    private Alignment align;
    private VerticalAlignment valign;
    private Orientation orientation;
    private boolean wrap;
    private BorderLineStyle leftBorder;
    private BorderLineStyle rightBorder;
    private BorderLineStyle topBorder;
    private BorderLineStyle bottomBorder;
    private Colour backgroundColour;
    private Pattern pattern;
    private int options;
    private int xfIndex;
    private FontRecord font;
    private DisplayFormat format;
    private boolean initialized;
    private boolean read;
    private Format excelFormat;
    private boolean formatInfoInitialized;
    private boolean copied;
    private FormattingRecords formattingRecords;
    private static int[] dateFormats = new int[]{14, 15, 16, 17, 18, 19, 20, 21, 22, 45, 46, 47};
    private static DateFormat[] javaDateFormats = new DateFormat[]{new SimpleDateFormat("M/d/yy"), new SimpleDateFormat("d-MMM-yy"), new SimpleDateFormat("d-MMM"), new SimpleDateFormat("MMM-yy"), new SimpleDateFormat("h:mm a"), new SimpleDateFormat("h:mm:ss a"), new SimpleDateFormat("H:mm"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("M/d/yy H:mm"), new SimpleDateFormat("mm:ss"), new SimpleDateFormat("H:mm:ss"), new SimpleDateFormat("mm:ss.S")};
    private static int[] numberFormats = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 37, 38, 39, 40, 41, 42, 43, 44, 48};
    private static NumberFormat[] javaNumberFormats = new NumberFormat[]{new DecimalFormat("0"), new DecimalFormat("0.00"), new DecimalFormat("#,##0"), new DecimalFormat("#,##0.00"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("0%"), new DecimalFormat("0.00%"), new DecimalFormat("0.00E00"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("#,##0;(#,##0)"), new DecimalFormat("$#,##0;($#,##0)"), new DecimalFormat("#,##0.00;(#,##0.00)"), new DecimalFormat("$#,##0.00;($#,##0.00)"), new DecimalFormat("##0.0E0")};
    public static final BiffType biff8 = new BiffType();
    public static final BiffType biff7 = new BiffType();
    private BiffType biffType;

    public XFRecord(Record t, BiffType bt) {
        super(t);
        this.biffType = bt;
        byte[] data = this.getRecord().getData();
        this.fontIndex = IntegerHelper.getInt(data[0], data[1]);
        this.formatIndex = IntegerHelper.getInt(data[2], data[3]);
        this.date = false;
        this.number = false;
        int i = 0;
        while (i < dateFormats.length) {
            if (this.formatIndex == dateFormats[i]) {
                this.date = true;
                this.dateFormat = javaDateFormats[i];
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < numberFormats.length) {
            if (this.formatIndex == numberFormats[i2]) {
                this.number = true;
                this.numberFormat = javaNumberFormats[i2];
            }
            ++i2;
        }
        this.initialized = false;
        this.read = true;
        this.formatInfoInitialized = false;
        this.copied = false;
    }

    public XFRecord(FontRecord fnt, DisplayFormat form) {
        super(Type.XF);
        this.initialized = false;
        this.locked = true;
        this.hidden = false;
        this.align = Alignment.GENERAL;
        this.valign = VerticalAlignment.BOTTOM;
        this.orientation = Orientation.HORIZONTAL;
        this.wrap = false;
        this.leftBorder = BorderLineStyle.NONE;
        this.rightBorder = BorderLineStyle.NONE;
        this.topBorder = BorderLineStyle.NONE;
        this.bottomBorder = BorderLineStyle.NONE;
        this.pattern = Pattern.NONE;
        this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        this.font = fnt;
        this.format = form;
        this.biffType = biff8;
        this.read = false;
        this.copied = false;
        this.formatInfoInitialized = true;
        Assert.verify(this.font != null);
        Assert.verify(this.format != null);
    }

    protected XFRecord(XFRecord fmt) {
        super(Type.XF);
        this.initialized = false;
        this.locked = fmt.locked;
        this.hidden = fmt.hidden;
        this.align = fmt.align;
        this.valign = fmt.valign;
        this.orientation = fmt.orientation;
        this.wrap = fmt.wrap;
        this.leftBorder = fmt.leftBorder;
        this.rightBorder = fmt.rightBorder;
        this.topBorder = fmt.topBorder;
        this.bottomBorder = fmt.bottomBorder;
        this.pattern = fmt.pattern;
        this.backgroundColour = fmt.backgroundColour;
        this.font = fmt.font;
        this.format = fmt.format;
        this.fontIndex = fmt.fontIndex;
        this.formatIndex = fmt.formatIndex;
        this.formatInfoInitialized = fmt.formatInfoInitialized;
        this.biffType = biff8;
        this.read = false;
        this.copied = true;
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public NumberFormat getNumberFormat() {
        return this.numberFormat;
    }

    public int getFormatRecord() {
        return this.formatIndex;
    }

    public boolean isDate() {
        return this.date;
    }

    public boolean isNumber() {
        return this.number;
    }

    public byte[] getData() {
        if (this.read && this.biffType == biff8) {
            return this.getRecord().getData();
        }
        if (this.biffType != biff8) {
            this.initializeFormatInformation();
        }
        byte[] data = new byte[20];
        IntegerHelper.getTwoBytes(this.fontIndex, data, 0);
        IntegerHelper.getTwoBytes(this.formatIndex, data, 2);
        int alignMask = this.align.getValue();
        if (this.wrap) {
            alignMask |= 8;
        }
        alignMask |= this.valign.getValue() << 4;
        IntegerHelper.getTwoBytes(alignMask |= this.orientation.getValue() << 8, data, 6);
        int borderMask = this.leftBorder.getValue();
        borderMask |= this.rightBorder.getValue() << 4;
        borderMask |= this.topBorder.getValue() << 8;
        IntegerHelper.getTwoBytes(borderMask |= this.bottomBorder.getValue() << 12, data, 10);
        if (borderMask != 0) {
            data[12] = 64;
            data[13] = 32;
            data[14] = 64;
            data[15] = 32;
        }
        IntegerHelper.getTwoBytes(this.pattern.getValue(), data, 16);
        int colourPaletteMask = this.backgroundColour.getValue();
        IntegerHelper.getTwoBytes(colourPaletteMask |= 0x2000, data, 18);
        IntegerHelper.getTwoBytes(this.options, data, 8);
        return data;
    }

    protected final boolean getLocked() {
        return this.locked;
    }

    protected final boolean getHidden() {
        return this.hidden;
    }

    public final void setLocked(boolean l) {
        this.locked = l;
    }

    protected final void setXFCellOptions(int opt) {
        this.options = opt;
    }

    protected void setXFAlignment(Alignment a) {
        Assert.verify(!this.initialized);
        this.align = a;
    }

    public Alignment getAlignment() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.align;
    }

    public VerticalAlignment getVerticalAlignment() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.valign;
    }

    public Orientation getOrientation() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.orientation;
    }

    protected void setXFBackground(Colour c, Pattern p) {
        Assert.verify(!this.initialized);
        this.backgroundColour = c;
        this.pattern = p;
    }

    public Colour getBackgroundColour() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.backgroundColour;
    }

    public Pattern getPattern() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.pattern;
    }

    protected void setXFVerticalAlignment(VerticalAlignment va) {
        Assert.verify(!this.initialized);
        this.valign = va;
    }

    protected void setXFOrientation(Orientation o) {
        Assert.verify(!this.initialized);
        this.orientation = o;
    }

    protected void setXFWrap(boolean w) {
        Assert.verify(!this.initialized);
        this.wrap = w;
    }

    public boolean getWrap() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.wrap;
    }

    protected void setXFBorder(Border b, BorderLineStyle ls) {
        Assert.verify(!this.initialized);
        if (b == Border.LEFT) {
            this.leftBorder = ls;
        } else if (b == Border.RIGHT) {
            this.rightBorder = ls;
        } else if (b == Border.TOP) {
            this.topBorder = ls;
        } else if (b == Border.BOTTOM) {
            this.bottomBorder = ls;
        }
    }

    public BorderLineStyle getBorder(Border border) {
        if (border == Border.NONE || border == Border.ALL) {
            return BorderLineStyle.NONE;
        }
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        if (border == Border.LEFT) {
            return this.leftBorder;
        }
        if (border == Border.RIGHT) {
            return this.rightBorder;
        }
        if (border == Border.TOP) {
            return this.topBorder;
        }
        if (border == Border.BOTTOM) {
            return this.bottomBorder;
        }
        return BorderLineStyle.NONE;
    }

    public final boolean hasBorders() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.leftBorder != BorderLineStyle.NONE || this.rightBorder != BorderLineStyle.NONE || this.topBorder != BorderLineStyle.NONE || this.bottomBorder != BorderLineStyle.NONE;
    }

    public final void initialize(int pos, FormattingRecords fr, Fonts fonts) throws NumFormatRecordsException {
        this.xfIndex = pos;
        this.formattingRecords = fr;
        if (this.read || this.copied) {
            this.initialized = true;
            return;
        }
        if (!this.font.isInitialized()) {
            fonts.addFont(this.font);
        }
        if (!this.format.isInitialized()) {
            fr.addFormat(this.format);
        }
        this.fontIndex = this.font.getFontIndex();
        this.formatIndex = this.format.getFormatIndex();
        this.initialized = true;
    }

    public final void uninitialize() {
        this.initialized = false;
    }

    public final int getXFIndex() {
        return this.xfIndex;
    }

    public final boolean isInitialized() {
        return this.initialized;
    }

    public final boolean isRead() {
        return this.read;
    }

    public Format getFormat() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.excelFormat;
    }

    public Font getFont() {
        if (!this.formatInfoInitialized) {
            this.initializeFormatInformation();
        }
        return this.font;
    }

    private void initializeFormatInformation() {
        this.excelFormat = this.formatIndex < BuiltInFormat.builtIns.length && BuiltInFormat.builtIns[this.formatIndex] != null ? BuiltInFormat.builtIns[this.formatIndex] : this.formattingRecords.getFormatRecord(this.formatIndex);
        this.font = this.formattingRecords.getFonts().getFont(this.fontIndex);
        byte[] data = this.getRecord().getData();
        int alignMask = IntegerHelper.getInt(data[6], data[7]);
        if ((alignMask & 8) != 0) {
            this.wrap = true;
        }
        this.align = Alignment.getAlignment(alignMask & 7);
        this.valign = VerticalAlignment.getAlignment(alignMask >> 4 & 7);
        this.orientation = Orientation.getOrientation(alignMask >> 8 & 0xFF);
        int borderMask = IntegerHelper.getInt(data[10], data[11]);
        this.leftBorder = BorderLineStyle.getStyle(borderMask & 7);
        this.rightBorder = BorderLineStyle.getStyle(borderMask >> 4 & 7);
        this.topBorder = BorderLineStyle.getStyle(borderMask >> 8 & 7);
        this.bottomBorder = BorderLineStyle.getStyle(borderMask >> 12 & 7);
        if (this.biffType == biff8) {
            int patternVal = IntegerHelper.getInt(data[16], data[17]);
            this.pattern = Pattern.getPattern(patternVal);
            int colourPaletteMask = IntegerHelper.getInt(data[18], data[19]);
            this.backgroundColour = Colour.getColour(colourPaletteMask & 0xFF);
            if (this.backgroundColour == Colour.UNKNOWN) {
                this.backgroundColour = Colour.DEFAULT_BACKGROUND;
            }
        } else {
            this.pattern = Pattern.NONE;
            this.backgroundColour = Colour.DEFAULT_BACKGROUND;
        }
        this.formatInfoInitialized = true;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XFRecord)) {
            return false;
        }
        XFRecord xfr = (XFRecord)o;
        if (this.read || xfr.read || !this.formatInfoInitialized || !xfr.formatInfoInitialized) {
            return false;
        }
        if (this.locked != xfr.locked || this.hidden != xfr.hidden) {
            return false;
        }
        if (this.align != xfr.align || this.valign != xfr.valign || this.orientation != xfr.orientation || this.wrap != xfr.wrap) {
            return false;
        }
        if (this.leftBorder != xfr.leftBorder || this.rightBorder != xfr.rightBorder || this.topBorder != xfr.topBorder || this.bottomBorder != xfr.bottomBorder) {
            return false;
        }
        if (this.backgroundColour != xfr.backgroundColour || this.pattern != xfr.pattern) {
            return false;
        }
        return this.font == xfr.font && this.format == xfr.format;
    }

    private static class BiffType {
        private BiffType() {
        }
    }
}

