/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import common.Assert;
import jxl.biff.CellReferenceHelper;
import jxl.biff.IntegerHelper;
import jxl.biff.formula.ExternalSheet;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;

class Area3d
extends Operand
implements ParsedThing {
    private int sheet;
    private int columnFirst;
    private int rowFirst;
    private int columnLast;
    private int rowLast;
    private boolean columnFirstRelative;
    private boolean rowFirstRelative;
    private boolean columnLastRelative;
    private boolean rowLastRelative;
    private ExternalSheet workbook;

    Area3d(ExternalSheet es) {
        this.workbook = es;
    }

    int getFirstColumn() {
        return this.columnFirst;
    }

    int getFirstRow() {
        return this.rowFirst;
    }

    int getLastColumn() {
        return this.columnLast;
    }

    int getLastRow() {
        return this.rowLast;
    }

    public int read(byte[] data, int pos) {
        this.sheet = IntegerHelper.getInt(data[pos], data[pos + 1]);
        this.rowFirst = IntegerHelper.getInt(data[pos + 2], data[pos + 3]);
        this.rowLast = IntegerHelper.getInt(data[pos + 4], data[pos + 5]);
        int columnMask = IntegerHelper.getInt(data[pos + 6], data[pos + 7]);
        this.columnFirst = columnMask & 0xFF;
        this.columnFirstRelative = (columnMask & 0x4000) != 0;
        this.rowFirstRelative = (columnMask & 0x8000) != 0;
        columnMask = IntegerHelper.getInt(data[pos + 8], data[pos + 9]);
        this.columnLast = columnMask & 0xFF;
        this.columnLastRelative = (columnMask & 0x4000) != 0;
        this.rowLastRelative = (columnMask & 0x8000) != 0;
        return 10;
    }

    public void getString(StringBuffer buf) {
        CellReferenceHelper.getCellReference(this.sheet, this.columnFirst, this.rowFirst, this.workbook, buf);
        buf.append(':');
        CellReferenceHelper.getCellReference(this.columnLast, this.rowLast, buf);
    }

    byte[] getBytes() {
        Assert.verify(false);
        return new byte[0];
    }
}

