/*
 * Decompiled with CFR 0.152.
 */
package jxl.read.biff;

import common.Assert;
import java.util.ArrayList;
import java.util.Iterator;
import jxl.Cell;
import jxl.CellType;
import jxl.SheetSettings;
import jxl.WorkbookSettings;
import jxl.biff.FormattingRecords;
import jxl.biff.Type;
import jxl.biff.chart.Chart;
import jxl.format.PageOrientation;
import jxl.format.PaperSize;
import jxl.read.biff.BOFRecord;
import jxl.read.biff.BaseSharedFormulaRecord;
import jxl.read.biff.BlankCell;
import jxl.read.biff.BooleanRecord;
import jxl.read.biff.BottomMarginRecord;
import jxl.read.biff.ColumnInfoRecord;
import jxl.read.biff.DateFormulaRecord;
import jxl.read.biff.DateRecord;
import jxl.read.biff.DimensionRecord;
import jxl.read.biff.ErrorRecord;
import jxl.read.biff.File;
import jxl.read.biff.FooterRecord;
import jxl.read.biff.FormulaRecord;
import jxl.read.biff.HeaderRecord;
import jxl.read.biff.HorizontalPageBreaksRecord;
import jxl.read.biff.HyperlinkRecord;
import jxl.read.biff.LabelRecord;
import jxl.read.biff.LabelSSTRecord;
import jxl.read.biff.LeftMarginRecord;
import jxl.read.biff.MergedCellsRecord;
import jxl.read.biff.MsoDrawingRecord;
import jxl.read.biff.MulBlankCell;
import jxl.read.biff.MulBlankRecord;
import jxl.read.biff.MulRKRecord;
import jxl.read.biff.NumberFormulaRecord;
import jxl.read.biff.NumberRecord;
import jxl.read.biff.NumberValue;
import jxl.read.biff.ObjRecord;
import jxl.read.biff.ProtectRecord;
import jxl.read.biff.RKHelper;
import jxl.read.biff.RKRecord;
import jxl.read.biff.RStringRecord;
import jxl.read.biff.RightMarginRecord;
import jxl.read.biff.RowRecord;
import jxl.read.biff.SSTRecord;
import jxl.read.biff.SetupRecord;
import jxl.read.biff.SharedFormulaRecord;
import jxl.read.biff.SheetImpl;
import jxl.read.biff.TopMarginRecord;
import jxl.read.biff.WorkbookParser;
import jxl.read.biff.WorkspaceInformationRecord;

final class SheetReader {
    private File excelFile;
    private SSTRecord sharedStrings;
    private BOFRecord workbookBof;
    private FormattingRecords formattingRecords;
    private int numRows;
    private int numCols;
    private Cell[][] cells;
    private int startPosition;
    private ArrayList rowProperties;
    private ArrayList columnInfosArray;
    private ArrayList sharedFormulas;
    private ArrayList hyperlinks;
    private MergedCellsRecord mergedCells;
    private ArrayList charts;
    private boolean nineteenFour;
    private HeaderRecord header;
    private FooterRecord footer;
    private int workspaceOptions;
    private int[] rowBreaks;
    private SheetSettings settings;
    private WorkbookSettings workbookSettings;
    private WorkbookParser workbook;
    private SheetImpl sheet;

    SheetReader(File f, SSTRecord sst, FormattingRecords fr, BOFRecord wb, boolean nf, WorkbookParser wp, int sp, SheetImpl sh) {
        this.excelFile = f;
        this.sharedStrings = sst;
        this.formattingRecords = fr;
        this.workbookBof = wb;
        this.columnInfosArray = new ArrayList();
        this.sharedFormulas = new ArrayList();
        this.hyperlinks = new ArrayList();
        this.rowProperties = new ArrayList(10);
        this.charts = new ArrayList();
        this.nineteenFour = nf;
        this.workbook = wp;
        this.startPosition = sp;
        this.sheet = sh;
        this.settings = new SheetSettings();
        this.workbookSettings = this.workbook.getSettings();
    }

    private void addCell(Cell cell) {
        if (cell.getRow() < this.numRows && cell.getColumn() < this.numCols) {
            Assert.verify(this.cells[cell.getRow()][cell.getColumn()] == null);
            this.cells[cell.getRow()][cell.getColumn()] = cell;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    final void read() {
        r = null;
        sharedFormula = null;
        sharedFormulaAdded = false;
        cont = true;
        this.excelFile.setPos(this.startPosition);
        msoRecord = null;
        objRecord = null;
        while (cont) {
            r = this.excelFile.next();
            if (r.getType() == Type.DIMENSION) {
                dr = null;
                dr = this.workbookBof.isBiff8() != false ? new DimensionRecord(r) : new DimensionRecord(r, DimensionRecord.biff7);
                this.numRows = dr.getNumberOfRows();
                this.numCols = dr.getNumberOfColumns();
                this.cells = new Cell[this.numRows][this.numCols];
            }
            if (r.getType() == Type.LABELSST) {
                label = new LabelSSTRecord(r, this.sharedStrings, this.formattingRecords, this.sheet);
                this.addCell(label);
            }
            if (r.getType() == Type.RK || r.getType() == Type.RK2) {
                rkr = new RKRecord(r, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(rkr.getXFIndex())) {
                    dc = new DateRecord(rkr, rkr.getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dc);
                } else {
                    this.addCell(rkr);
                }
            }
            if (r.getType() == Type.HLINK) {
                hr = new HyperlinkRecord(r, this.sheet);
                this.hyperlinks.add(hr);
            }
            if (r.getType() == Type.MERGEDCELLS) {
                Assert.verify(this.mergedCells == null);
                this.mergedCells = new MergedCellsRecord(r, this.sheet);
            }
            if (r.getType() == Type.MULRK) {
                mulrk = new MulRKRecord(r);
                num = mulrk.getNumberOfColumns();
                ixf = 0;
                i = 0;
                while (i < num) {
                    ixf = mulrk.getXFIndex(i);
                    nv = new NumberValue(mulrk.getRow(), mulrk.getFirstColumn() + i, RKHelper.getDouble(mulrk.getRKNumber(i)), ixf, this.formattingRecords, this.sheet);
                    if (this.formattingRecords.isDate(ixf)) {
                        dc = new DateRecord(nv, ixf, this.formattingRecords, this.nineteenFour, this.sheet);
                        this.addCell(dc);
                    } else {
                        nv.setNumberFormat(this.formattingRecords.getNumberFormat(ixf));
                        this.addCell(nv);
                    }
                    ++i;
                }
            }
            if (r.getType() == Type.NUMBER) {
                nr = new NumberRecord(r, this.formattingRecords, this.sheet);
                if (this.formattingRecords.isDate(nr.getXFIndex())) {
                    dc = new DateRecord(nr, nr.getXFIndex(), this.formattingRecords, this.nineteenFour, this.sheet);
                    this.addCell(dc);
                } else {
                    this.addCell(nr);
                }
            }
            if (r.getType() == Type.BOOLERR) {
                br = new BooleanRecord(r, this.formattingRecords, this.sheet);
                if (br.isError()) {
                    er = new ErrorRecord(br.getRecord(), this.formattingRecords, this.sheet);
                    this.addCell(er);
                } else {
                    this.addCell((Cell)br);
                }
            }
            if (r.getType() == Type.CONTINUE) {
                // empty if block
            }
            if (r.getType() == Type.NOTE) {
                // empty if block
            }
            if (r.getType() == Type.ARRAY) {
                // empty if block
            }
            if (r.getType() == Type.PROTECT) {
                pr = new ProtectRecord(r);
                this.settings.setProtected(pr.isProtected());
            }
            if (r.getType() == Type.SHAREDFORMULA) {
                sfr = new SharedFormulaRecord(r, sharedFormula, this.workbook, this.sheet);
                this.sharedFormulas.add(sfr);
                sharedFormula = null;
            }
            if (r.getType() == Type.FORMULA || r.getType() == Type.FORMULA2) {
                fr = new FormulaRecord(r, this.excelFile, this.formattingRecords, this.workbook, this.sheet);
                if (fr.isShared()) {
                    prevSharedFormula = sharedFormula;
                    sharedFormula = (BaseSharedFormulaRecord)fr.getFormula();
                    sharedFormulaAdded = this.addToSharedFormulas(sharedFormula);
                    if (sharedFormulaAdded) {
                        sharedFormula = null;
                    }
                    ** if (!sharedFormulaAdded && prevSharedFormula == null) goto lbl91
                }
                cell /* !! */  = fr.getFormula();
                if (fr.getFormula().getType() == CellType.NUMBER_FORMULA && this.formattingRecords.isDate((nfr = (NumberFormulaRecord)fr.getFormula()).getXFIndex())) {
                    cell /* !! */  = new DateFormulaRecord(nfr, this.formattingRecords, this.workbook, this.nineteenFour, this.sheet);
                }
                this.addCell(cell /* !! */ );
lbl-1000:
                // 1 sources

                {
                    // empty if block
                }
            }
lbl91:
            // 5 sources

            if (r.getType() == Type.LABEL) {
                lr /* !! */  = null;
                lr /* !! */  = this.workbookBof.isBiff8() != false ? new LabelRecord(r, this.formattingRecords, this.sheet) : new LabelRecord(r, this.formattingRecords, this.sheet, LabelRecord.biff7);
                this.addCell(lr /* !! */ );
            }
            if (r.getType() == Type.RSTRING) {
                lr /* !! */  = null;
                Assert.verify(this.workbookBof.isBiff8() == false);
                lr /* !! */  = new RStringRecord(r, this.formattingRecords, this.sheet, RStringRecord.biff7);
                this.addCell(lr /* !! */ );
            }
            if (r.getType() == Type.NAME) {
                // empty if block
            }
            if (r.getType() == Type.ROW && (!(rr = new RowRecord(r)).isDefaultHeight() || rr.isCollapsed() || rr.isZeroHeight())) {
                this.rowProperties.add(rr);
            }
            if (r.getType() == Type.BLANK) {
                bc = new BlankCell(r, this.formattingRecords, this.sheet);
                this.addCell(bc);
            }
            if (r.getType() == Type.MULBLANK) {
                mulblank = new MulBlankRecord(r);
                num = mulblank.getNumberOfColumns();
                ixf = 0;
                i = 0;
                while (i < num) {
                    ixf = mulblank.getXFIndex(i);
                    mbc = new MulBlankCell(mulblank.getRow(), mulblank.getFirstColumn() + i, ixf, this.formattingRecords, this.sheet);
                    this.addCell(mbc);
                    ++i;
                }
            }
            if (r.getType() == Type.COLINFO) {
                cir = new ColumnInfoRecord(r);
                this.columnInfosArray.add(cir);
            }
            if (r.getType() == Type.HEADER) {
                this.header = this.workbookBof.isBiff8() != false ? new HeaderRecord(r) : new HeaderRecord(r, HeaderRecord.biff7);
            }
            if (r.getType() == Type.FOOTER) {
                this.footer = this.workbookBof.isBiff8() != false ? new FooterRecord(r) : new FooterRecord(r, FooterRecord.biff7);
            }
            if (r.getType() == Type.SETUP) {
                sr = new SetupRecord(r);
                if (sr.isPortrait()) {
                    this.settings.setOrientation(PageOrientation.PORTRAIT);
                } else {
                    this.settings.setOrientation(PageOrientation.LANDSCAPE);
                }
                this.settings.setPaperSize(PaperSize.getPaperSize(sr.getPaperSize()));
                this.settings.setHeaderMargin(sr.getHeaderMargin());
                this.settings.setFooterMargin(sr.getFooterMargin());
                this.settings.setScaleFactor(sr.getScaleFactor());
                this.settings.setPageStart(sr.getPageStart());
                this.settings.setFitWidth(sr.getFitWidth());
                this.settings.setFitHeight(sr.getFitHeight());
                this.settings.setHorizontalPrintResolution(sr.getHorizontalPrintResolution());
                this.settings.setVerticalPrintResolution(sr.getVerticalPrintResolution());
            }
            if (r.getType() == Type.WSBOOL) {
                wir = new WorkspaceInformationRecord(r);
                this.workspaceOptions = wir.getOptions();
            }
            if (r.getType() == Type.LEFTMARGIN) {
                m = new LeftMarginRecord(r);
                this.settings.setLeftMargin(m.getMargin());
            }
            if (r.getType() == Type.RIGHTMARGIN) {
                m = new RightMarginRecord(r);
                this.settings.setRightMargin(m.getMargin());
            }
            if (r.getType() == Type.TOPMARGIN) {
                m = new TopMarginRecord(r);
                this.settings.setTopMargin(m.getMargin());
            }
            if (r.getType() == Type.BOTTOMMARGIN) {
                m = new BottomMarginRecord(r);
                this.settings.setBottomMargin(m.getMargin());
            }
            if (r.getType() == Type.HORIZONTALPAGEBREAKS) {
                dr = null;
                dr = this.workbookBof.isBiff8() != false ? new HorizontalPageBreaksRecord(r) : new HorizontalPageBreaksRecord(r, HorizontalPageBreaksRecord.biff7);
                this.rowBreaks = dr.getRowBreaks();
            }
            if (r.getType() == Type.OBJ) {
                objRecord = new ObjRecord(r);
            }
            if (r.getType() == Type.MSODRAWING) {
                msoRecord = new MsoDrawingRecord(r);
            }
            if (r.getType() == Type.BOF) {
                br = new BOFRecord(r);
                Assert.verify(br.isWorksheet() == false);
                startpos = this.excelFile.getPos() - r.getLength() - 4;
                r2 = this.excelFile.next();
                while (r2.getCode() != Type.EOF.value) {
                    r2 = this.excelFile.next();
                }
                if (br.isChart()) {
                    chart = new Chart(msoRecord, objRecord, startpos, this.excelFile.getPos(), this.excelFile, this.workbookSettings);
                    this.charts.add(chart);
                    msoRecord = null;
                    objRecord = null;
                }
            }
            if (r.getType() != Type.EOF) continue;
            cont = false;
        }
        this.excelFile.restorePos();
        i = this.sharedFormulas.iterator();
        while (i.hasNext()) {
            sfr = (SharedFormulaRecord)i.next();
            sfnr = sfr.getFormulas(this.formattingRecords, this.nineteenFour);
            sf = 0;
            while (sf < sfnr.length) {
                this.addCell(sfnr[sf]);
                ++sf;
            }
        }
        if (!sharedFormulaAdded && sharedFormula != null) {
            this.addCell(this.revertSharedFormula(sharedFormula));
        }
    }

    private boolean addToSharedFormulas(BaseSharedFormulaRecord fr) {
        Iterator i = this.sharedFormulas.iterator();
        boolean added = false;
        SharedFormulaRecord sfr = null;
        while (i.hasNext() && !added) {
            sfr = (SharedFormulaRecord)i.next();
            added = sfr.add(fr);
        }
        return added;
    }

    private Cell revertSharedFormula(BaseSharedFormulaRecord f) {
        FormulaRecord fr = new FormulaRecord(f.getRecord(), this.excelFile, this.formattingRecords, this.workbook, FormulaRecord.ignoreSharedFormula, this.sheet);
        Cell cell = fr.getFormula();
        if (fr.getFormula().getType() == CellType.NUMBER_FORMULA) {
            NumberFormulaRecord nfr = (NumberFormulaRecord)fr.getFormula();
            if (this.formattingRecords.isDate(fr.getXFIndex())) {
                cell = new DateFormulaRecord(nfr, this.formattingRecords, this.workbook, this.nineteenFour, this.sheet);
            }
        }
        return cell;
    }

    final int getNumRows() {
        return this.numRows;
    }

    final int getNumCols() {
        return this.numCols;
    }

    final Cell[][] getCells() {
        return this.cells;
    }

    final ArrayList getRowProperties() {
        return this.rowProperties;
    }

    final ArrayList getColumnInfosArray() {
        return this.columnInfosArray;
    }

    final ArrayList getHyperlinks() {
        return this.hyperlinks;
    }

    final ArrayList getCharts() {
        return this.charts;
    }

    final MergedCellsRecord getMergedCells() {
        return this.mergedCells;
    }

    final HeaderRecord getHeader() {
        return this.header;
    }

    final FooterRecord getFooter() {
        return this.footer;
    }

    final SheetSettings getSettings() {
        return this.settings;
    }

    final int[] getRowBreaks() {
        return this.rowBreaks;
    }

    final int getWorkspaceOptions() {
        return this.workspaceOptions;
    }
}

