/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.views.xslt;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.Result;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.StrutsException;
import org.apache.struts2.views.xslt.AdapterFactory;
import org.apache.struts2.views.xslt.ServletURIResolver;

public class XSLTResult
implements Result {
    private static final long serialVersionUID = 6424691441777176763L;
    private static final Logger LOG = LoggerFactory.getLogger(XSLTResult.class);
    public static final String DEFAULT_PARAM = "stylesheetLocation";
    private static final Map<String, Templates> templatesCache = new HashMap<String, Templates>();
    protected boolean noCache;
    private String stylesheetLocation;
    private String matchingPattern;
    private String excludingPattern;
    private String exposedValue;
    private int status = 200;
    private boolean parse;
    private AdapterFactory adapterFactory;

    public XSLTResult() {
    }

    public XSLTResult(String stylesheetLocation) {
        this();
        this.setStylesheetLocation(stylesheetLocation);
    }

    @Inject(value="struts.xslt.nocache")
    public void setNoCache(String val) {
        this.noCache = "true".equals(val);
    }

    public void setLocation(String location) {
        this.setStylesheetLocation(location);
    }

    public void setStylesheetLocation(String location) {
        if (location == null) {
            throw new IllegalArgumentException("Null location");
        }
        this.stylesheetLocation = location;
    }

    public String getStylesheetLocation() {
        return this.stylesheetLocation;
    }

    public String getExposedValue() {
        return this.exposedValue;
    }

    public void setExposedValue(String exposedValue) {
        this.exposedValue = exposedValue;
    }

    public String getMatchingPattern() {
        return this.matchingPattern;
    }

    public void setMatchingPattern(String matchingPattern) {
        this.matchingPattern = matchingPattern;
    }

    public String getExcludingPattern() {
        return this.excludingPattern;
    }

    public void setExcludingPattern(String excludingPattern) {
        this.excludingPattern = excludingPattern;
    }

    public String getStatus() {
        return String.valueOf(this.status);
    }

    public void setStatus(String status) {
        try {
            this.status = Integer.valueOf(status);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Status value not number " + e.getMessage(), e);
        }
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public void execute(ActionInvocation invocation) throws Exception {
        long startTime = System.currentTimeMillis();
        String location = this.getStylesheetLocation();
        if (this.parse) {
            ValueStack stack = ActionContext.getContext().getValueStack();
            location = TextParseUtil.translateVariables((String)location, (ValueStack)stack);
        }
        try {
            Transformer transformer;
            HttpServletResponse response = ServletActionContext.getResponse();
            response.setStatus(this.status);
            PrintWriter writer = response.getWriter();
            Templates templates = null;
            if (location != null) {
                templates = this.getTemplates(location);
                transformer = templates.newTransformer();
            } else {
                transformer = TransformerFactory.newInstance().newTransformer();
            }
            transformer.setURIResolver(this.getURIResolver());
            transformer.setErrorListener(new ErrorListener(){

                public void error(TransformerException exception) throws TransformerException {
                    throw new StrutsException("Error transforming result", exception);
                }

                public void fatalError(TransformerException exception) throws TransformerException {
                    throw new StrutsException("Fatal error transforming result", exception);
                }

                public void warning(TransformerException exception) throws TransformerException {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn(exception.getMessage(), (Throwable)exception, new String[0]);
                    }
                }
            });
            String mimeType = templates == null ? "text/xml" : templates.getOutputProperties().getProperty("media-type");
            if (mimeType == null) {
                mimeType = "text/html";
            }
            response.setContentType(mimeType);
            Object result = invocation.getAction();
            if (this.exposedValue != null) {
                ValueStack stack = invocation.getStack();
                result = stack.findValue(this.exposedValue);
            }
            Source xmlSource = this.getDOMSourceForStack(result);
            if (LOG.isDebugEnabled()) {
                LOG.debug("xmlSource = " + xmlSource, new String[0]);
            }
            transformer.transform(xmlSource, new StreamResult(writer));
            writer.flush();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Time:" + (System.currentTimeMillis() - startTime) + "ms", new String[0]);
            }
        }
        catch (Exception e) {
            if (LOG.isErrorEnabled()) {
                LOG.error("Unable to render XSLT Template, '#0'", (Throwable)e, new String[]{location});
            }
            throw e;
        }
    }

    protected AdapterFactory getAdapterFactory() {
        if (this.adapterFactory == null) {
            this.adapterFactory = new AdapterFactory();
        }
        return this.adapterFactory;
    }

    protected void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    protected URIResolver getURIResolver() {
        return new ServletURIResolver(ServletActionContext.getServletContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Templates getTemplates(String path) throws TransformerException, IOException {
        String pathFromRequest = ServletActionContext.getRequest().getParameter("xslt.location");
        if (pathFromRequest != null) {
            path = pathFromRequest;
        }
        if (path == null) {
            throw new TransformerException("Stylesheet path is null");
        }
        Templates templates = templatesCache.get(path);
        if (this.noCache || templates == null) {
            Map<String, Templates> map = templatesCache;
            synchronized (map) {
                URL resource = ServletActionContext.getServletContext().getResource(path);
                if (resource == null) {
                    throw new TransformerException("Stylesheet " + path + " not found in resources.");
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Preparing XSLT stylesheet templates: " + path, new String[0]);
                }
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setURIResolver(this.getURIResolver());
                templates = factory.newTemplates(new StreamSource(resource.openStream()));
                templatesCache.put(path, templates);
            }
        }
        return templates;
    }

    protected Source getDOMSourceForStack(Object value) throws IllegalAccessException, InstantiationException {
        return new DOMSource(this.getAdapterFactory().adaptDocument("result", value));
    }
}

