/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.server.endpoint.mapping;

import java.lang.reflect.Method;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerFactory;
import org.springframework.util.StringUtils;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.annotation.PayloadRoot;
import org.springframework.ws.server.endpoint.mapping.AbstractAnnotationMethodEndpointMapping;
import org.springframework.ws.server.endpoint.support.PayloadRootUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PayloadRootAnnotationMethodEndpointMapping
extends AbstractAnnotationMethodEndpointMapping<QName> {
    private static TransformerFactory transformerFactory = TransformerFactory.newInstance();

    @Override
    protected QName getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        return PayloadRootUtils.getPayloadRootQName(messageContext.getRequest().getPayloadSource(), transformerFactory);
    }

    @Override
    protected QName getLookupKeyForMethod(Method method) {
        PayloadRoot annotation = method.getAnnotation(PayloadRoot.class);
        if (annotation != null) {
            QName qname = StringUtils.hasLength((String)annotation.localPart()) && StringUtils.hasLength((String)annotation.namespace()) ? new QName(annotation.namespace(), annotation.localPart()) : new QName(annotation.localPart());
            return qname;
        }
        return null;
    }
}

