/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.springframework.util.Assert;
import org.springframework.xml.namespace.QNameUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

class AxiomHandler
implements ContentHandler,
LexicalHandler {
    private final OMFactory factory;
    private final List<OMContainer> elements = new ArrayList<OMContainer>();
    private Map<String, String> namespaces = new HashMap<String, String>();
    private final OMContainer container;
    private int charactersType = 4;

    AxiomHandler(OMContainer container, OMFactory factory) {
        Assert.notNull((Object)container, (String)"'container' must not be null");
        Assert.notNull((Object)factory, (String)"'factory' must not be null");
        this.factory = factory;
        this.container = container;
    }

    private OMContainer getParent() {
        if (!this.elements.isEmpty()) {
            return this.elements.get(this.elements.size() - 1);
        }
        return this.container;
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaces.put(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaces.remove(prefix);
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        OMContainer parent = this.getParent();
        OMElement element = this.factory.createOMElement(localName, null, parent);
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String prefix = entry.getKey();
            if (prefix.length() == 0) {
                element.declareDefaultNamespace(entry.getValue());
                continue;
            }
            element.declareNamespace(entry.getValue(), prefix);
        }
        QName qname = QNameUtils.toQName(uri, qName);
        element.setLocalName(qname.getLocalPart());
        element.setNamespace(element.findNamespace(qname.getNamespaceURI(), qname.getPrefix()));
        for (int i = 0; i < atts.getLength(); ++i) {
            QName attrName = QNameUtils.toQName(atts.getURI(i), atts.getQName(i));
            String value = atts.getValue(i);
            if (atts.getQName(i).startsWith("xmlns")) continue;
            OMNamespace namespace = this.factory.createOMNamespace(attrName.getNamespaceURI(), attrName.getPrefix());
            OMAttribute attribute = this.factory.createOMAttribute(attrName.getLocalPart(), namespace, value);
            element.addAttribute(attribute);
        }
        this.elements.add((OMContainer)element);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.elements.remove(this.elements.size() - 1);
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        String data = new String(ch, start, length);
        OMContainer parent = this.getParent();
        this.factory.createOMText(parent, data, this.charactersType);
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.charactersType = 6;
        this.characters(ch, start, length);
        this.charactersType = 4;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        OMContainer parent = this.getParent();
        this.factory.createOMProcessingInstruction(parent, target, data);
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        String content = new String(ch, start, length);
        OMContainer parent = this.getParent();
        this.factory.createOMComment(parent, content);
    }

    public void startCDATA() throws SAXException {
        this.charactersType = 12;
    }

    public void endCDATA() throws SAXException {
        this.charactersType = 4;
    }

    public void startEntity(String name) throws SAXException {
        if (!this.isPredefinedEntityReference(name)) {
            this.charactersType = 9;
        }
    }

    public void endEntity(String name) throws SAXException {
        this.charactersType = 4;
    }

    private boolean isPredefinedEntityReference(String name) {
        return "lt".equals(name) || "gt".equals(name) || "amp".equals(name) || "quot".equals(name) || "apos".equals(name);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }
}

