/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.security.callback;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.springframework.ws.soap.security.callback.AbstractCallbackHandler;

public class CallbackHandlerChain
extends AbstractCallbackHandler {
    private final CallbackHandler[] callbackHandlers;

    public CallbackHandlerChain(CallbackHandler[] callbackHandlers) {
        this.callbackHandlers = callbackHandlers;
    }

    public CallbackHandler[] getCallbackHandlers() {
        return this.callbackHandlers;
    }

    protected void handleInternal(Callback callback) throws IOException, UnsupportedCallbackException {
        boolean allUnsupported = true;
        for (CallbackHandler callbackHandler : this.callbackHandlers) {
            try {
                callbackHandler.handle(new Callback[]{callback});
                allUnsupported = false;
            }
            catch (UnsupportedCallbackException ex) {
                // empty catch block
            }
        }
        if (allUnsupported) {
            throw new UnsupportedCallbackException(callback);
        }
    }
}

