/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.coreframework.db.DB;
import com.coreframework.log.LogBody;
import com.coreframework.log.LogLevel;
import com.coreframework.log.Logger;
import com.coreframework.remoting.standard.Status;
import com.coreframework.remoting.standard.StatusHandler;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLongArray;

public class DBStatic
implements StatusHandler {
    private static final long serialVersionUID = -6302076517351299367L;
    public static final int INSERT_INDEX = 0;
    public static final int INSERT_TIME_INDEX = 1;
    public static final int UPDATE_INDEX = 2;
    public static final int UPDATE_TIME_INDEX = 3;
    public static final int QUERY_INDEX = 4;
    public static final int QUERY_TIME_INDEX = 5;
    static boolean queryLog = true;
    static boolean modifyLog = true;
    private AtomicLongArray array = new AtomicLongArray(6);
    private String db;
    private static ConcurrentHashMap<String, DBStatic> map = new ConcurrentHashMap();

    public DBStatic(String db) {
        this.db = db;
    }

    public static void addDB(String db) {
        DBStatic sta = new DBStatic(db);
        if (map.putIfAbsent(db, sta) == null) {
            Status.addHandler((String)("DB_" + db), (StatusHandler)sta);
        }
    }

    private static void modifyLog(LogBody body, long time, Exception e) {
        if (!modifyLog) {
            return;
        }
        body.set("log-version", (Object)"2");
        if (e != null) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            e.printStackTrace(w);
            body.set("exception", (Object)sw.toString());
            Logger.get().log(LogLevel.ERROR, "db-jar", body, DB.class);
        } else if (time > 3000L) {
            Logger.get().log(LogLevel.WARN, "db-jar", body, DB.class);
        } else {
            Logger.get().log(LogLevel.INFO, "db-jar", body, DB.class);
        }
    }

    private static void queryLog(LogBody body, long time, Exception e) {
        if (!queryLog) {
            return;
        }
        body.set("log-version", (Object)"2");
        if (e != null) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            e.printStackTrace(w);
            body.set("exception", (Object)sw.toString());
            Logger.get().log(LogLevel.ERROR, "db-jar", body, DB.class);
        } else if (time > 3000L) {
            Logger.get().log(LogLevel.WARN, "db-jar", body, DB.class);
        } else if (time > 1000L) {
            Logger.get().log(LogLevel.INFO, "db-jar", body, DB.class);
        } else {
            Logger.get().log(LogLevel.DEBUG, "db-jar", body, DB.class);
        }
    }

    public static void update(String db, long time_sql, LogBody body, Exception e) {
        if (db == null || db.isEmpty()) {
            System.out.println("db:" + db);
            return;
        }
        DBStatic sta = map.get(db);
        if (sta == null) {
            System.out.println(String.valueOf(db) + " not exist");
            return;
        }
        sta.array.incrementAndGet(2);
        sta.array.addAndGet(3, time_sql);
        body.set("db", (Object)db).set("sqltype", (Object)"update");
        DBStatic.modifyLog(body, time_sql, e);
    }

    public static void insert(String db, long time, LogBody body, Exception e) {
        if (db == null || db.isEmpty()) {
            System.out.println("db:" + db);
            return;
        }
        DBStatic sta = map.get(db);
        if (sta == null) {
            System.out.println(String.valueOf(db) + " not exist");
            return;
        }
        sta.array.incrementAndGet(0);
        sta.array.addAndGet(1, time);
        body.set("db", (Object)db).set("sqltype", (Object)"insert");
        DBStatic.modifyLog(body, time, e);
    }

    public static void query(String db, long time, LogBody body, Exception e) {
        if (db == null || db.isEmpty()) {
            System.out.println("db:" + db);
            return;
        }
        DBStatic sta = map.get(db);
        if (sta == null) {
            System.out.println(String.valueOf(db) + " not exist");
            return;
        }
        sta.array.incrementAndGet(4);
        sta.array.addAndGet(5, time);
        body.set("db", (Object)db).set("sqltype", (Object)"query");
        DBStatic.queryLog(body, time, e);
    }

    public Map<String, Number> status() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("insert", this.array.get(0));
        map.put("update", this.array.get(2));
        map.put("query", this.array.get(4));
        map.put("insertTime", this.array.get(1));
        map.put("updateTime", this.array.get(3));
        map.put("queryTime", this.array.get(5));
        long t = ((Number)map.get("insertTime")).longValue();
        double c = ((Number)map.get("insert")).doubleValue();
        map.put("avg_insert", c == 0.0 ? 0.0 : (double)t / c);
        t = ((Number)map.get("updateTime")).longValue();
        c = ((Number)map.get("update")).doubleValue();
        map.put("avg_update", c == 0.0 ? 0.0 : (double)t / c);
        t = ((Number)map.get("queryTime")).longValue();
        c = ((Number)map.get("query")).doubleValue();
        map.put("avg_query", c == 0.0 ? 0.0 : (double)t / c);
        map.putAll(DB.me().info(this.db));
        return map;
    }

    public static void main(String[] args) {
        DBStatic.addDB("db1");
        DBStatic.query("db1", 234L, LogBody.me().set("a", (Object)"1"), new Exception());
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

