/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils.handlers;

import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.RowProcessor;
import com.yihu.das.dbutils.handlers.AbstractListHandler;
import com.yihu.das.dbutils.handlers.ArrayHandler;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class MapListHandler
extends AbstractListHandler<Map<String, Object>> {
    private final RowProcessor convert;

    public MapListHandler() {
        this(ArrayHandler.ROW_PROCESSOR);
    }

    public MapListHandler(RowProcessor convert) {
        this.convert = convert;
    }

    @Override
    protected Map<String, Object> handleRow(ResultSet rs) throws SQLException {
        return this.convert.toMap(rs);
    }

    @Override
    public QueryResult<List<Map<String, Object>>> handle(ResultSet rs, int start, int pageSize, int rowCount) throws SQLException {
        ArrayList<Object> rows = new ArrayList<Object>();
        while (rs.next()) {
            rows.add(this.handleRow(rs));
        }
        QueryResult<List<Map<String, Object>>> qs = new QueryResult<List<Map<String, Object>>>();
        qs.setRowCount(rowCount);
        qs.setResult(rows);
        try {
            int pageCount = (int)Math.ceil((double)rowCount * 1.0 / (double)pageSize);
            qs.setPageCount(pageCount);
        }
        catch (Exception exception) {
            // empty catch block
        }
        qs.setPageSize(pageSize);
        return qs;
    }
}

