/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    private static final Map<Class<?>, Object> primitiveDefaults = new HashMap();

    static {
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
    }

    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        return this.createBean(rs, type, props, columnToProperty);
    }

    public <T> List<T> toBeanList(ResultSet rs, Class<T> type) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        if (!rs.next()) {
            return results;
        }
        PropertyDescriptor[] props = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props);
        do {
            results.add(this.createBean(rs, type, props, columnToProperty));
        } while (rs.next());
        return results;
    }

    private <T> T createBean(ResultSet rs, Class<T> type, PropertyDescriptor[] props, int[] columnToProperty) throws SQLException {
        T bean = this.newInstance(type);
        int i = 1;
        while (i < columnToProperty.length) {
            if (columnToProperty[i] != -1) {
                PropertyDescriptor prop = props[columnToProperty[i]];
                Class<?> propType = prop.getPropertyType();
                Object value = this.processColumn(rs, i, propType);
                if (propType != null && value == null && propType.isPrimitive()) {
                    value = primitiveDefaults.get(propType);
                }
                this.callSetter(bean, prop, value);
            }
            ++i;
        }
        return bean;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] params = setter.getParameterTypes();
        try {
            if (value != null && value instanceof java.util.Date) {
                if (params[0].getName().equals("java.sql.Date")) {
                    value = new Date(((java.util.Date)value).getTime());
                } else if (params[0].getName().equals("java.sql.Time")) {
                    value = new Time(((java.util.Date)value).getTime());
                } else if (params[0].getName().equals("java.sql.Timestamp")) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
            }
            if (!this.isCompatibleType(value, params[0])) {
                throw new SQLException("Cannot set " + prop.getName() + ": incompatible types.");
            }
            setter.invoke(target, value);
        }
        catch (IllegalArgumentException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
        catch (InvocationTargetException e) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e.getMessage());
        }
    }

    private boolean isCompatibleType(Object value, Class<?> type) {
        if (value == null || type.isInstance(value)) {
            return true;
        }
        if (type.equals(Integer.TYPE) && Integer.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Long.TYPE) && Long.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Double.TYPE) && Double.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Float.TYPE) && Float.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Short.TYPE) && Short.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Byte.TYPE) && Byte.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Character.TYPE) && Character.class.isInstance(value)) {
            return true;
        }
        return type.equals(Boolean.TYPE) && Boolean.class.isInstance(value);
    }

    protected <T> T newInstance(Class<T> c) throws SQLException {
        try {
            return c.newInstance();
        }
        catch (InstantiationException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new SQLException("Cannot create " + c.getName() + ": " + e.getMessage());
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c);
        }
        catch (IntrospectionException e) {
            throw new SQLException("Bean introspection failed: " + e.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        int col = 1;
        while (col <= cols) {
            String columnName = rsmd.getColumnLabel(col);
            if (columnName == null || columnName.length() == 0) {
                columnName = rsmd.getColumnName(col);
            }
            int i = 0;
            while (i < props.length) {
                if (columnName.equalsIgnoreCase(props[i].getName())) {
                    columnToProperty[col] = i;
                    break;
                }
                ++i;
            }
            ++col;
        }
        return columnToProperty;
    }

    protected Object processColumn(ResultSet rs, int index, Class<?> propType) throws SQLException {
        if (propType == null) {
            return new SQLException("\u5217" + index + ",\u7c7b\u578b\u4e3anull");
        }
        try {
            if (!propType.isPrimitive() && rs.getObject(index) == null) {
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        if (propType.equals(String.class)) {
            Object val = rs.getObject(index);
            if (val != null && val instanceof ClobImpl) {
                Reader reader;
                block18: {
                    reader = rs.getCharacterStream(index);
                    if (reader != null) break block18;
                    return null;
                }
                try {
                    StringBuffer sb = new StringBuffer();
                    char[] charbuf = new char[4096];
                    int j = reader.read(charbuf);
                    while (j > 0) {
                        sb.append(charbuf, 0, j);
                        j = reader.read(charbuf);
                    }
                    val = sb.toString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return rs.getString(index);
        }
        if (propType.equals(Integer.TYPE) || propType.equals(Integer.class)) {
            return rs.getInt(index);
        }
        if (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class)) {
            return rs.getBoolean(index);
        }
        if (propType.equals(Long.TYPE) || propType.equals(Long.class)) {
            return rs.getLong(index);
        }
        if (propType.equals(Double.TYPE) || propType.equals(Double.class)) {
            return rs.getDouble(index);
        }
        if (propType.equals(Float.TYPE) || propType.equals(Float.class)) {
            return Float.valueOf(rs.getFloat(index));
        }
        if (propType.equals(Short.TYPE) || propType.equals(Short.class)) {
            return rs.getShort(index);
        }
        if (propType.equals(Byte.TYPE) || propType.equals(Byte.class)) {
            return rs.getByte(index);
        }
        if (propType.equals(Timestamp.class)) {
            return rs.getTimestamp(index);
        }
        return rs.getObject(index);
    }
}

