/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils;

import com.coreframework.db.DB;
import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.AbstractQueryRunner;
import com.yihu.das.dbutils.ResultSetHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner() {
    }

    public QueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public QueryRunner(DataSource ds) {
        super(ds);
    }

    public QueryRunner(DataSource ds, boolean pmdKnownBroken) {
        super(ds, pmdKnownBroken);
    }

    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        return this.batch(conn, false, sql, params);
    }

    public int[] batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.batch(conn, true, sql, params);
    }

    private int[] batch(Connection conn, boolean closeConn, String sql, Object[][] params) throws SQLException {
        int[] rows;
        block14: {
            if (conn == null) {
                throw new SQLException("Null connection");
            }
            if (sql == null) {
                if (closeConn) {
                    this.close(conn);
                }
                throw new SQLException("Null SQL statement");
            }
            if (params == null) {
                if (closeConn) {
                    this.close(conn);
                }
                throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
            }
            PreparedStatement stmt = null;
            rows = null;
            try {
                try {
                    stmt = this.prepareStatement(conn, sql);
                    int i = 0;
                    while (i < params.length) {
                        this.fillStatement(stmt, params[i]);
                        stmt.addBatch();
                        ++i;
                    }
                    rows = stmt.executeBatch();
                }
                catch (SQLException e) {
                    this.rethrow(e, sql, (Object[])params);
                    this.close(stmt);
                    if (closeConn) {
                        this.close(conn);
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
                throw throwable;
            }
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }

    public <T> QueryResult<T> queryCore(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, int rowCount, int start, int pageSize, Object ... params) throws SQLException {
        QueryResult<T> result;
        block18: {
            if (DB.isShowSql()) {
                System.out.println(sql);
            }
            PreparedStatement stmt = null;
            ResultSet rs = null;
            result = null;
            try {
                try {
                    stmt = pageSize > 0 ? conn.prepareStatement(sql, 1004, 1007) : conn.prepareStatement(sql);
                    this.fillStatement(stmt, params);
                    rs = this.wrap(stmt.executeQuery());
                    result = rowCount > 0 ? rsh.handle(rs, start, pageSize, rowCount) : (pageSize > 0 ? rsh.handle(rs, start, pageSize) : new QueryResult<T>(rsh.handle(rs)));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    this.rethrow(e, sql, params);
                    try {
                        this.close(rs);
                        break block18;
                    }
                    finally {
                        this.close(stmt);
                        if (closeConn) {
                            this.close(conn);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                try {
                    this.close(rs);
                }
                finally {
                    this.close(stmt);
                    if (closeConn) {
                        this.close(conn);
                    }
                }
                throw throwable;
            }
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
        return result;
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, false, sql, null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, false, sql, param);
    }

    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        return this.update(conn, false, sql, params);
    }

    public int update(String sql) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, null);
    }

    public int update(String sql, Object param) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, param);
    }

    public int update(String sql, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, params);
    }

    public int update(Connection conn, boolean closeConn, String sql, Object ... params) throws SQLException {
        int rows;
        block12: {
            if (conn == null) {
                throw new SQLException("Null connection");
            }
            if (DB.isShowSql()) {
                System.out.println(sql);
            }
            if (sql == null) {
                if (closeConn) {
                    this.close(conn);
                }
                throw new SQLException("Null SQL statement");
            }
            PreparedStatement stmt = null;
            rows = 0;
            try {
                try {
                    stmt = this.prepareStatement(conn, sql);
                    this.fillStatement(stmt, params);
                    rows = stmt.executeUpdate();
                }
                catch (SQLException e) {
                    this.rethrow(e, sql, params);
                    this.close(stmt);
                    if (closeConn) {
                        this.close(conn);
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
                throw throwable;
            }
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }
}

