/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.das.dbutils.handlers;

import com.common.json.JSONArray;
import com.common.json.JSONException;
import com.common.json.JSONObject;
import com.coreframework.db.QueryResult;
import com.yihu.das.dbutils.JsonConfig;
import com.yihu.das.dbutils.ResultSetHandler;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import net.sourceforge.jtds.jdbc.ClobImpl;

public class JsonHandler
implements ResultSetHandler<JSONObject> {
    private JsonConfig cfg;
    private boolean dealNull;

    public JsonHandler() {
        this.dealNull = false;
    }

    public JsonHandler(JsonConfig cfg) {
        this.dealNull = false;
        this.cfg = cfg;
    }

    public JsonHandler(JsonConfig cfg, boolean dealNull) {
        this.dealNull = true;
        this.cfg = cfg;
    }

    @Override
    public JSONObject handle(ResultSet rs) throws SQLException {
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        JSONObject tmp = null;
        while (rs.next()) {
            tmp = this.toJson(rs);
            if (this.cfg.getRowHandler() != null) {
                this.cfg.getRowHandler().handler(tmp);
            }
            if (this.cfg.isSingleResult()) {
                return tmp;
            }
            array.put((Object)tmp);
        }
        try {
            result.put(this.cfg.getResultPropertyName(), (Object)array);
        }
        catch (JSONException e) {
            throw new SQLException(e.getMessage());
        }
        return result;
    }

    @Override
    public QueryResult<JSONObject> handle(ResultSet rs, int start, int pageSize) throws SQLException {
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        QueryResult<JSONObject> qr = new QueryResult<JSONObject>();
        qr.setStart(start);
        qr.setPageSize(pageSize);
        int c = 0;
        if (pageSize > 1000) {
            pageSize = 1000;
        }
        if (!rs.last()) {
            try {
                result.put(this.cfg.getResultPropertyName(), (Object)array);
                result.put(this.cfg.getTotalPropertyName(), 0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            qr.setResult(result);
            return qr;
        }
        int rowCount = rs.getRow();
        if (pageSize > rowCount) {
            pageSize = rowCount;
        }
        int pageCount = (rowCount + pageSize) / pageSize;
        qr.setPageCount(pageCount);
        qr.setRowCount(rowCount);
        if (pageCount <= 0) {
            try {
                result.put(this.cfg.getResultPropertyName(), (Object)array);
                result.put(this.cfg.getTotalPropertyName(), rowCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
            qr.setResult(result);
            return qr;
        }
        int current = start;
        if (!rs.absolute(start == 0 ? 1 : current + 1)) {
            try {
                result.put(this.cfg.getResultPropertyName(), (Object)array);
                result.put(this.cfg.getTotalPropertyName(), rowCount);
            }
            catch (Exception exception) {
                // empty catch block
            }
            qr.setResult(result);
            return qr;
        }
        do {
            JSONObject json = this.toJson(rs);
            if (this.cfg.getRowHandler() != null) {
                this.cfg.getRowHandler().handler(json);
            }
            array.put((Object)json);
        } while (++c < pageSize && rs.next());
        try {
            result.put(this.cfg.getResultPropertyName(), (Object)array);
            result.put(this.cfg.getTotalPropertyName(), rowCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
        qr.setResult(result);
        return qr;
    }

    public boolean isDealNull() {
        return this.dealNull;
    }

    public void setDealNull(boolean dealNull) {
        this.dealNull = dealNull;
    }

    public JSONObject toJson(ResultSet rs) throws SQLException {
        JSONObject json = new JSONObject();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        int i = 1;
        while (i <= cols) {
            if (!"_row_nr_".equalsIgnoreCase(rsmd.getColumnName(i))) {
                Object val = rs.getObject(i);
                if (val != null && val instanceof ClobImpl) {
                    Reader reader2;
                    block13: {
                        reader2 = rs.getCharacterStream(i);
                        if (reader2 != null) break block13;
                        return null;
                    }
                    try {
                        StringBuffer sb = new StringBuffer();
                        char[] charbuf = new char[4096];
                        int j = reader2.read(charbuf);
                        while (j > 0) {
                            sb.append(charbuf, 0, j);
                            j = reader2.read(charbuf);
                        }
                        val = sb.toString();
                    }
                    catch (Exception reader2) {
                        // empty catch block
                    }
                }
                try {
                    if (this.cfg.isColumnNameAsKey()) {
                        if (this.cfg.isColumnNameLower()) {
                            json.put(rsmd.getColumnName(i).toLowerCase(), this.dealNull ? (val == null ? "" : val) : val);
                        } else {
                            json.put(rsmd.getColumnName(i), this.dealNull ? (val == null ? "" : val) : val);
                        }
                    }
                    if (this.cfg.getKeys() != null) {
                        json.put(this.cfg.getKeys()[i - 1], this.dealNull ? (val == null ? "" : val) : val);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    throw new SQLException(e.getMessage());
                }
            }
            ++i;
        }
        return json;
    }

    @Override
    public QueryResult<JSONObject> handle(ResultSet rs, int start, int pageSize, int rowCount) throws SQLException {
        JSONObject result = new JSONObject();
        JSONArray array = new JSONArray();
        QueryResult<JSONObject> qr = new QueryResult<JSONObject>();
        qr.setStart(start);
        qr.setPageSize(pageSize);
        JSONObject tmp = null;
        while (rs.next()) {
            tmp = this.toJson(rs);
            if (this.cfg.getRowHandler() != null) {
                this.cfg.getRowHandler().handler(tmp);
            }
            if (this.cfg.isSingleResult()) {
                qr.setResult(tmp);
                return qr;
            }
            array.put((Object)tmp);
        }
        try {
            result.put(this.cfg.getResultPropertyName(), (Object)array);
            result.put(this.cfg.getTotalPropertyName(), rowCount);
            qr.setResult(result);
        }
        catch (JSONException e) {
            throw new SQLException(e.getMessage());
        }
        return qr;
    }
}

