/*
 * Decompiled with CFR 0.152.
 */
package jcifs.util;

import java.io.IOException;
import java.io.InputStream;

public class MimeMap {
    private static final int IN_SIZE = 7000;
    private static final int ST_START = 1;
    private static final int ST_COMM = 2;
    private static final int ST_TYPE = 3;
    private static final int ST_GAP = 4;
    private static final int ST_EXT = 5;
    private byte[] in = new byte[7000];
    private int inLen;

    public MimeMap() throws IOException {
        int n;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("jcifs/util/mime.map");
        this.inLen = 0;
        while ((n = is.read(this.in, this.inLen, 7000 - this.inLen)) != -1) {
            this.inLen += n;
        }
        if (this.inLen < 100 || this.inLen == 7000) {
            throw new IOException("Error reading jcifs/util/mime.map resource");
        }
        is.close();
    }

    public String getMimeType(String extension) throws IOException {
        return this.getMimeType(extension, "application/octet-stream");
    }

    public String getMimeType(String extension, String def) throws IOException {
        byte[] type = new byte[128];
        byte[] buf = new byte[16];
        byte[] ext = extension.toLowerCase().getBytes("ASCII");
        int state = 1;
        int i = 0;
        int x = 0;
        int t = 0;
        block10: for (int off = 0; off < this.inLen; ++off) {
            byte ch = this.in[off];
            switch (state) {
                case 1: {
                    if (ch == 32 || ch == 9) continue block10;
                    if (ch == 35) {
                        state = 2;
                        continue block10;
                    }
                    state = 3;
                }
                case 3: {
                    if (ch == 32 || ch == 9) {
                        state = 4;
                        continue block10;
                    }
                    type[t++] = ch;
                    continue block10;
                }
                case 2: {
                    if (ch != 10) continue block10;
                    i = 0;
                    x = 0;
                    t = 0;
                    state = 1;
                    continue block10;
                }
                case 4: {
                    if (ch == 32 || ch == 9) continue block10;
                    state = 5;
                }
                case 5: {
                    switch (ch) {
                        case 9: 
                        case 10: 
                        case 32: 
                        case 35: {
                            for (i = 0; i < x && x == ext.length && buf[i] == ext[i]; ++i) {
                            }
                            if (i == ext.length) {
                                return new String(type, 0, t, "ASCII");
                            }
                            if (ch == 35) {
                                state = 2;
                            } else if (ch == 10) {
                                i = 0;
                                x = 0;
                                t = 0;
                                state = 1;
                            }
                            x = 0;
                            continue block10;
                        }
                    }
                    buf[x++] = ch;
                }
            }
        }
        return def;
    }
}

