/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.openplatform.service;

import com.yihu.openplatform.service.AppKeyService;
import com.yihu.openplatform.service.SignAndPost;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class UrlCheck
extends Thread {
    public static ConcurrentHashMap<String, Integer> failUrlMap = new ConcurrentHashMap();
    public static int MaxErrorNum = 10;
    public static int SleepTime = 10000;
    private static int counter = 0;

    @Override
    public void run() {
        block16: while (true) {
            try {
                if (++counter >= 30) {
                    failUrlMap.clear();
                    counter = 0;
                    continue;
                }
                try {
                    HashMap<String, Integer> tempUrl = new HashMap<String, Integer>();
                    tempUrl.putAll(failUrlMap);
                    Set urls = tempUrl.keySet();
                    Iterator itr = urls.iterator();
                    while (true) {
                        if (!itr.hasNext()) continue block16;
                        try {
                            String url = (String)itr.next();
                            if (failUrlMap.get(url) != null && failUrlMap.get(url) < MaxErrorNum) continue;
                            boolean available = UrlCheck.isNetFileAvailable(url);
                            if (available) {
                                if (AppKeyService.isDebug) {
                                    System.out.println("url:" + url + " ,checked:available,start push");
                                }
                                failUrlMap.remove(url);
                                continue;
                            }
                            if (!AppKeyService.isDebug) continue;
                            System.out.println("url:" + url + " ,checked:invalid,stop push");
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            finally {
                try {
                    Thread.sleep(SleepTime);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            break;
        }
    }

    public static boolean isUrlCanUse(String strUrl) {
        boolean result = true;
        try {
            if (failUrlMap.get(strUrl) != null && failUrlMap.get(strUrl) > MaxErrorNum) {
                result = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void removeErrorUrl(String strUrl) {
        try {
            if (failUrlMap.containsKey(strUrl)) {
                failUrlMap.remove(strUrl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addUrlErrorNum(String strUrl) {
        try {
            if (failUrlMap.containsKey(strUrl)) {
                failUrlMap.put(strUrl, failUrlMap.get(strUrl) + 1);
            } else {
                failUrlMap.put(strUrl, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean isNetFileAvailable(String strUrl) {
        try {
            SignAndPost.httpPost(strUrl, null);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

