/*
 * Decompiled with CFR 0.152.
 */
package com.yihu.openplatform.utils;

import com.yihu.monitor.sdk.NetworkUtil;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public final class DictConfigUtil {
    private static DictConfigUtil instance = null;
    private static final String cfg = "sys.xml";
    private String centerServerUrl;
    private String appId;

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getCenterServerUrl() {
        return this.centerServerUrl;
    }

    private DictConfigUtil() throws Exception {
        this.init();
    }

    private void init() throws Exception {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(cfg);
            SAXReader reader = new SAXReader();
            Document doc = reader.read(inputStream);
            String centerServerUrl = doc.getRootElement().elementTextTrim("CenterServerUrl");
            if (centerServerUrl != null && !"".equals(centerServerUrl)) {
                this.centerServerUrl = centerServerUrl;
            }
            try {
                this.appId = doc.getRootElement().elementTextTrim("AppId");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            inputStream.close();
            if (this.centerServerUrl != null && this.centerServerUrl.equalsIgnoreCase("auto")) {
                String localIp = NetworkUtil.getLocalIP();
                System.out.println("localIp=" + localIp);
                this.centerServerUrl = localIp.startsWith("10.") || localIp.startsWith("192.168.192") ? "10.0.100.154:2181,10.0.101.127:2181,10.0.101.128:2181" : "172.18.20.21:2181,172.18.20.65:2181,172.18.20.65:2182";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DictConfigUtil getInstance() throws Exception {
        if (instance == null) {
            instance = new DictConfigUtil();
        }
        return instance;
    }

    public static void create() throws Exception {
        instance = new DictConfigUtil();
    }
}

