/*
 * Decompiled with CFR 0.152.
 */
package com.coreframework.db;

import com.common.json.JSONObject;
import com.coreframework.db.BatchSql;
import com.coreframework.db.CaseInsensitiveHashMap;
import com.coreframework.db.Combox;
import com.coreframework.db.DBStatic;
import com.coreframework.db.DatabaseEnum;
import com.coreframework.db.Exp;
import com.coreframework.db.ExpGroup;
import com.coreframework.db.FileTypeFilter;
import com.coreframework.db.FileWatch;
import com.coreframework.db.JDataSet;
import com.coreframework.db.JdbcConnection;
import com.coreframework.db.MySQLDialect;
import com.coreframework.db.Operation;
import com.coreframework.db.OracleDialect;
import com.coreframework.db.Order;
import com.coreframework.db.QueryResult;
import com.coreframework.db.SQLServer2005Dialect;
import com.coreframework.db.Sql;
import com.coreframework.db.SqlNameEnum;
import com.coreframework.db.TableEnum;
import com.coreframework.db.Version;
import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import com.coreframework.util.PropUtils;
import com.coreframework.util.SysConfig;
import com.yihu.config.ConfigReader;
import com.yihu.config.DbCfgCache;
import com.yihu.configcenter.vo.ConnectionPoolProperty;
import com.yihu.das.dbutils.JsonConfig;
import com.yihu.das.dbutils.QueryRunner;
import com.yihu.das.dbutils.ResultSetHandler;
import com.yihu.das.dbutils.handlers.ArrayHandler;
import com.yihu.das.dbutils.handlers.ArrayListHandler;
import com.yihu.das.dbutils.handlers.BeanHandler;
import com.yihu.das.dbutils.handlers.BeanListHandler;
import com.yihu.das.dbutils.handlers.JDataSetHandler;
import com.yihu.das.dbutils.handlers.JsonHandler;
import com.yihu.das.dbutils.handlers.ListHandler;
import com.yihu.das.dbutils.handlers.MapHandler;
import com.yihu.das.dbutils.handlers.MapListHandler;
import com.yihu.das.dbutils.handlers.ScalarHandler;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PausableConnectionFactory;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class DB {
    private static DB instance = null;
    private static final String cfg = "das-client.xml";
    private static boolean useLimitSql = false;
    private static boolean showSql = false;
    private static String RESULT = "result";
    private static String ERROR = "FAIL";
    private static String SUCCESS = "SUCCESS";
    private static String CONID = "conid";
    public static final String SQLTYPE = "sqltype";
    private static final String TIME = "time";
    public static final String DB_LOG = "db-jar";
    public static final String EXCEPTION = "exception";
    private static final String TIME_TOTAL = "time_total";
    private static final String SQLSERVER_DriverClass = "net.sourceforge.jtds.jdbc.Driver";
    private static final String ORACLE_DriverClass = "oracle.jdbc.driver.OracleDriver";
    private static final String MYSQL_DriverClass = "com.mysql.jdbc.Driver";
    private static final QueryRunner queryRunner;
    private static final ConcurrentHashMap<String, DB> instanceMap;
    public static JDataSetHandler jDataSetHandler;
    public static JsonHandler jsonHandler;
    public static JsonHandler jsonHandler2;
    public static ScalarHandler scalarHandler;
    public static ListHandler<Object> listHandler;
    public static MapHandler mapHandler;
    public static MapListHandler mapListHandler;
    public static ArrayHandler arrayHandler;
    public static ArrayListHandler arrayListHandler;
    private final CaseInsensitiveHashMap sqlMap = new CaseInsensitiveHashMap();
    private final CaseInsensitiveHashMap poolMap = new CaseInsensitiveHashMap();
    private String das_url;

    static {
        Version.print();
        instance = new DB(cfg);
        instanceMap = new ConcurrentHashMap();
        Thread t = new Thread(new FileWatch());
        t.setName("A-SqlConfigWatch-Thread");
        t.start();
        queryRunner = new QueryRunner();
        jDataSetHandler = new JDataSetHandler();
        jsonHandler = new JsonHandler(JsonConfig.defaultConfig);
        jsonHandler2 = new JsonHandler(JsonConfig.defaultConfig, true);
        scalarHandler = new ScalarHandler();
        listHandler = new ListHandler();
        mapHandler = new MapHandler();
        mapListHandler = new MapListHandler();
        arrayHandler = new ArrayHandler();
        arrayListHandler = new ArrayListHandler();
    }

    public void pauseCreateConnection(String dbName, boolean paused) {
        Object database = this.poolMap.get(dbName);
        if (database == null) {
            System.out.println(String.valueOf(dbName) + " have not created");
            return;
        }
        if (!BasicDataSource.class.isInstance(database)) {
            System.out.println(String.valueOf(dbName) + " is not a BasicDataSource object");
            return;
        }
        BasicDataSource ds = (BasicDataSource)database;
        ConnectionFactory factory = ds.getDriverConnectionFactory();
        if (!PausableConnectionFactory.class.isInstance(factory)) {
            System.out.println(String.valueOf(dbName) + " is null or not a PausableConnectionFactory object");
            return;
        }
        ((PausableConnectionFactory)PausableConnectionFactory.class.cast(factory)).setPaused(paused);
        System.out.println(String.valueOf(dbName) + ".paused seted to " + paused);
    }

    public static void queryLogEnabled(boolean log) {
        DBStatic.queryLog = log;
    }

    public static void modifyLogEnabled(boolean log) {
        DBStatic.modifyLog = log;
    }

    public static boolean isShowSql() {
        return showSql;
    }

    public static void setShowSql(boolean showSql) {
        DB.showSql = showSql;
    }

    public static boolean isUseLimitSql() {
        return useLimitSql;
    }

    public static void setUseLimitSql(boolean useLimitSql) {
        DB.useLimitSql = useLimitSql;
    }

    public synchronized HashMap<String, String> info() {
        HashMap<String, String> jsonMap = new HashMap<String, String>();
        for (String dbName : this.poolMap.keySet()) {
            BasicDataSource ds = (BasicDataSource)this.poolMap.get(dbName);
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            map.put("active", ds.getNumActive());
            map.put("idle", ds.getNumIdle());
            map.put("minIdle", ds.getMinIdle());
            map.put("maxIdle", ds.getMaxIdle());
            map.put("maxActive", ds.getMaxActive());
            jsonMap.put(dbName, new JSONObject(map).toString());
        }
        return jsonMap;
    }

    private Document getDocument(File file) {
        try {
            SAXReader reader = new SAXReader();
            Document doc = reader.read(file);
            return doc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void load(File file) {
        Document moduleDoc = this.getDocument(file);
        if (moduleDoc == null) {
            return;
        }
        List list = moduleDoc.getRootElement().element("Sqls").elements("Sql");
        if (list != null) {
            Element e = null;
            for (Object object : list) {
                e = (Element)object;
                this.putSql(file.getName(), e.attributeValue("name").trim(), e.getTextTrim());
            }
        }
    }

    private void putSql(String fileName, String name, String value) {
        if (name == null || name.equals("")) {
            return;
        }
        this.sqlMap.put(name, value);
    }

    private void loadSqlCfgFiles() {
        File[] files;
        File directory;
        URL url = Thread.currentThread().getContextClassLoader().getResource("");
        if (url != null) {
            String path = url.getPath();
            try {
                path = URLDecoder.decode(path, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            directory = new File(path);
            files = directory.listFiles(new FileTypeFilter(".sql.xml"));
            if (files != null) {
                this.filesLoad(files);
                return;
            }
        }
        String tmp = this.getClass().getResource("").getPath();
        try {
            tmp = URLDecoder.decode(tmp, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        directory = new File(tmp);
        tmp = String.valueOf(directory.getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getParentFile().getPath().replaceAll("file:", "")) + "\\lib\\classes";
        directory = new File(tmp);
        files = directory.listFiles(new FileTypeFilter(".sql.xml"));
        this.filesLoad(files);
    }

    private void filesLoad(File[] files) {
        if (files == null) {
            System.out.println("\u65e0*.sql.xml\u6587\u4ef6");
            return;
        }
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                this.load(files[i]);
                ++i;
            }
        }
    }

    public String getSql(String name) {
        return (String)this.sqlMap.get(name);
    }

    private DB(String cfgName) {
        try {
            PropUtils.loadFromSysXml();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            InputStream inputStream = Sql.class.getClassLoader().getResourceAsStream(cfgName);
            if (inputStream != null) {
                List list;
                Element sqls;
                SAXReader reader = new SAXReader();
                Document doc = reader.read(inputStream);
                this.das_url = doc.getRootElement().elementTextTrim("das-url");
                if (this.das_url == null || this.das_url.isEmpty()) {
                    this.das_url = SysConfig.getCenterServerUrl();
                }
                if ((sqls = doc.getRootElement().element("Sqls")) != null && (list = sqls.elements("Sql")) != null) {
                    Element e = null;
                    for (Object object : list) {
                        e = (Element)object;
                        this.putSql(cfgName, e.attributeValue("name"), e.getTextTrim());
                    }
                }
                inputStream.close();
            }
            if (this.das_url == null) {
                this.das_url = SysConfig.getCenterServerUrl();
            }
            if (this.das_url == null) {
                System.out.println("das_url does not exist,you need call addDataSource() to add datasource");
            }
            this.loadSqlCfgFiles();
            if (this.das_url != null) {
                ConfigReader.me((String)this.das_url).loadDbCfg();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static DB me() {
        return instance;
    }

    public static DB me(String cfgName) {
        DB db = instanceMap.get(cfgName);
        if (db != null) {
            return db;
        }
        instanceMap.putIfAbsent(cfgName, new DB(cfgName));
        return instanceMap.get(cfgName);
    }

    private PropertyDescriptor[] getPropertyDescriptor(Class<?> c) throws Exception {
        BeanInfo beaninfo = Introspector.getBeanInfo(c);
        return beaninfo.getPropertyDescriptors();
    }

    public void addDataSource(String alias, String DatabaseName, String ip, int port, String username, String password) {
        this.addDataSourceCore(alias, DatabaseName, ip, port, username, password, SQLSERVER_DriverClass);
    }

    public void addDataSourceOracle(String alias, String DatabaseName, String ip, int port, String username, String password) {
        this.addDataSourceCore(alias, DatabaseName, ip, port, username, password, ORACLE_DriverClass);
    }

    public void addDataSourceMySQL(String alias, String DatabaseName, String ip, int port, String username, String password) {
        this.addDataSourceCore(alias, DatabaseName, ip, port, username, password, MYSQL_DriverClass);
    }

    private void addDataSourceCore(String alias, String DatabaseName, String ip, int port, String username, String password, String driverClassName) {
        this.poolMap.remove(alias);
        BasicDataSource ds = new BasicDataSource();
        ds.setMaxActive(150);
        ds.setDriverClassName(driverClassName);
        if (driverClassName.equalsIgnoreCase(ORACLE_DriverClass)) {
            ds.setUrl("jdbc:oracle:thin:@" + ip + ":" + port + ":" + DatabaseName);
            ds.setValidationQuery("select 1 from dual");
        } else if (driverClassName.equalsIgnoreCase(MYSQL_DriverClass)) {
            ds.setUrl("jdbc:mysql://" + ip + ":" + port + "/" + DatabaseName + "?useOldAliasMetadataBehavior=true");
            ds.setValidationQuery("select 1 ");
        } else {
            ds.setUrl("jdbc:jtds:sqlserver://" + ip + ":" + port + ";DatabaseName=" + DatabaseName);
            ds.setValidationQuery("select 1 ");
        }
        ds.setUsername(username);
        ds.setPassword(password);
        ds.setMinIdle(4);
        ds.setMaxIdle(100);
        ds.setMaxWait(8000L);
        ds.setTimeBetweenEvictionRunsMillis(2000L);
        ds.setMinEvictableIdleTimeMillis(60000L);
        this.poolMap.put(alias, ds);
        DBStatic.addDB(alias);
        System.out.println("\u624b\u52a8\u6dfb\u52a0\u4e86\u6570\u636e\u6e90:" + ip + ":" + port + "," + DatabaseName);
    }

    public Sql createSelect(Object obj, TableEnum table) throws SQLException {
        return this.createSelect(obj, table, null, null, null);
    }

    public Sql createSelect(Object obj, TableEnum table, String owner) throws SQLException {
        return this.createSelect(obj, table, owner, null, null);
    }

    public Sql createSelect(Object obj, TableEnum table, String owner, String columns) throws SQLException {
        return this.createSelect(obj, table, owner, columns, null);
    }

    public Sql createSelect(Object obj, TableEnum table, Order order) throws SQLException {
        return this.createSelect(obj, table, null, null, order);
    }

    public Sql createSelect(Object obj, TableEnum table, String owner, Order order) throws SQLException {
        return this.createSelect(obj, table, owner, null, order);
    }

    public Sql createSelect(Object obj, TableEnum table, String owner, String columns, Order order) throws SQLException {
        try {
            return this.asExpGroup(obj).applyToSelect(owner == null ? table.toString() : String.valueOf(owner) + "." + table.toString(), columns, order);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SQLException(e.getMessage());
        }
    }

    public Sql createInsertSql(Object obj, TableEnum table) throws SQLException {
        return this.createInsertSql(obj, table, null);
    }

    public Sql createInsertSql(Object obj, TableEnum table, String owner) throws SQLException {
        try {
            return this.asExpGroup(obj).applyToInsert(owner == null ? table.toString() : String.valueOf(owner) + "." + table.toString());
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    public Sql createUpdateSql(Object obj, TableEnum table, String whereString) throws SQLException {
        return this.createUpdateSql(obj, null, table, whereString);
    }

    public Sql createUpdateSql(Object obj, String owner, TableEnum table, String whereString) throws SQLException {
        return this.createUpdateSql(obj, owner, table, whereString, true);
    }

    public Sql createUpdateSql(Object obj, String owner, TableEnum table, String whereString, boolean ignoreEmpty) throws SQLException {
        try {
            return this.asExpGroup(obj, ignoreEmpty).applyToSets(owner == null ? table.toString() : String.valueOf(owner) + "." + table.toString(), whereString);
        }
        catch (Exception e) {
            throw new SQLException(e.getMessage());
        }
    }

    private ExpGroup asExpGroup(Object obj) throws Exception {
        return this.asExpGroup(obj, true);
    }

    private ExpGroup asExpGroup(Object obj, boolean ignoreEmpty) throws Exception {
        PropertyDescriptor[] p;
        ExpGroup cnd = new ExpGroup();
        PropertyDescriptor[] propertyDescriptorArray = p = this.getPropertyDescriptor(obj.getClass());
        int n = p.length;
        int n2 = 0;
        while (n2 < n) {
            Method m;
            Object value;
            PropertyDescriptor propertyDescriptor = propertyDescriptorArray[n2];
            if (!(propertyDescriptor.getName().equals("class") || (value = (m = propertyDescriptor.getReadMethod()).invoke(obj, new Object[0])) == null || value instanceof String && ignoreEmpty && ((String)value).equals(""))) {
                cnd.put(new Exp(propertyDescriptor.getName(), Operation.equal, value));
            }
            ++n2;
        }
        return cnd;
    }

    public Sql createSql(SqlNameEnum sqlName) {
        return new Sql((String)this.sqlMap.get(sqlName.toString()));
    }

    public BatchSql createBatchSql(SqlNameEnum sqlName) {
        return new BatchSql((String)this.sqlMap.get(sqlName.toString()));
    }

    private <T> QueryResult<T> queryExt(DatabaseEnum dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize) {
        return this.queryExt(null, dbName, sql, rsh, start, pageSize);
    }

    private <T> QueryResult<T> queryExt(DatabaseEnum dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize, boolean needTotalNum) {
        return this.queryExt(null, dbName, sql, rsh, start, pageSize, needTotalNum);
    }

    public <T> QueryResult<T> queryExt(String dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize) {
        return this.queryExt(null, dbName, sql, rsh, start, pageSize);
    }

    private <T> QueryResult<T> queryExt(JdbcConnection conn, String dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize) {
        return this.queryExt(conn, dbName, sql, rsh, start, pageSize, false);
    }

    private <T> QueryResult<T> queryExt(JdbcConnection conn, String dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize, boolean needTotalNum) {
        long begin = System.currentTimeMillis();
        long conid = -1L;
        String result = SUCCESS;
        Exception ex = null;
        long time_sql = -1L;
        boolean isCreate = true;
        if (conn != null) {
            isCreate = false;
        }
        String sqlString = null;
        try {
            String countSql = null;
            if (sql.isUseLimitSql() && pageSize > 0) {
                if (conn == null) {
                    conn = this.getConnection(dbName);
                }
                conid = conn.getConnid();
                BasicDataSource ds = (BasicDataSource)this.poolMap.get(dbName);
                if (ds.getDriverClassName().equalsIgnoreCase(ORACLE_DriverClass)) {
                    sqlString = OracleDialect.getLimitString(sql.getSqlString(), start, start + pageSize);
                    countSql = OracleDialect.getCountSql(sql.getSqlString());
                } else if (ds.getDriverClassName().equalsIgnoreCase(MYSQL_DriverClass)) {
                    sqlString = MySQLDialect.getLimitString(sql.getSqlString(), start, pageSize);
                    countSql = MySQLDialect.getCountSql(sql.getSqlString());
                } else {
                    sqlString = SQLServer2005Dialect.getLimitString(sql.getSqlString(), start, start + pageSize);
                    countSql = SQLServer2005Dialect.getCountSql(sql.getSqlString());
                }
                conn.addSql(sql);
                if (isCreate) {
                    conn.startTimer();
                }
                if (rsh instanceof JsonHandler || needTotalNum) {
                    QueryResult<Object> countQR = queryRunner.queryCore(conn.getConn(), false, countSql, scalarHandler, -1, 0, 0, sql.getParamValueList());
                    if (countQR.getCode() != 1) {
                        QueryResult queryResult = new QueryResult(-1, countQR.getMessage());
                        return queryResult;
                    }
                    int count = -1;
                    if (countQR.getResult() != null) {
                        if (countQR.getResult() instanceof BigDecimal) {
                            BigDecimal tmp = (BigDecimal)countQR.getResult();
                            count = tmp.intValue();
                        } else {
                            try {
                                count = ((Long)countQR.getResult()).intValue();
                            }
                            catch (Exception e) {
                                count = (Integer)countQR.getResult();
                            }
                        }
                    }
                    long sql_begin = System.currentTimeMillis();
                    QueryResult<T> ret = queryRunner.queryCore(conn.getConn(), false, sqlString, rsh, count, 0, pageSize, sql.getParamValueList());
                    time_sql = System.currentTimeMillis() - sql_begin;
                    QueryResult<T> queryResult = ret;
                    return queryResult;
                }
                long sql_begin = System.currentTimeMillis();
                QueryResult<T> ret = queryRunner.queryCore(conn.getConn(), false, sqlString, rsh, -1, 0, 1000, sql.getParamValueList());
                time_sql = System.currentTimeMillis() - sql_begin;
                QueryResult<T> queryResult = ret;
                return queryResult;
            }
            sqlString = sql.getSqlString();
            if (conn == null) {
                conn = this.getConnection(dbName);
            }
            conid = conn.getConnid();
            conn.addSql(sql);
            if (isCreate) {
                conn.startTimer();
            }
            long sql_begin = System.currentTimeMillis();
            QueryResult<T> ret = queryRunner.queryCore(conn.getConn(), false, sqlString, rsh, -1, start, pageSize, sql.getParamValueList());
            time_sql = System.currentTimeMillis() - sql_begin;
            QueryResult<T> queryResult = ret;
            return queryResult;
        }
        catch (Exception e) {
            ex = e;
            result = ERROR;
            e.printStackTrace();
            QueryResult queryResult = new QueryResult(-1, e.getMessage());
            return queryResult;
        }
        finally {
            if (isCreate && conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            long time = System.currentTimeMillis() - begin;
            DBStatic.query(dbName, time_sql, LogBody.me().set(TIME_TOTAL, (Object)time).set(TIME, (Object)time_sql).set(RESULT, (Object)result).set(CONID, (Object)conid).set("sql", (Object)sqlString).set("param", (Object)sql.getValues()), ex);
        }
    }

    private <T> QueryResult<T> queryExt(JdbcConnection conn, DatabaseEnum dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize) {
        return this.queryExt(conn, dbName.toString(), sql, rsh, start, pageSize);
    }

    private <T> QueryResult<T> queryExt(JdbcConnection conn, DatabaseEnum dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize, boolean needTotalNum) {
        return this.queryExt(conn, dbName.toString(), sql, rsh, start, pageSize, needTotalNum);
    }

    public Object[] queryForObjectArray(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Object[]> qr = this.queryExt(dbName, sql, arrayHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public Object[] queryForObjectArray(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Object[]> qr = this.queryExt(conn, dbName, sql, arrayHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public List<Object[]> queryForList(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<List<Object[]>> qr = this.queryExt(dbName, sql, arrayListHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public List<Object[]> queryForList(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<List<Object[]>> qr = this.queryExt(conn, dbName, sql, arrayListHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public List<Object[]> queryForList(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<List<Object[]>> qr = this.queryExt(dbName, sql, arrayListHandler, start, pageSize, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public List<Object[]> queryForList(JdbcConnection conn, DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<List<Object[]>> qr = this.queryExt(conn, dbName, sql, arrayListHandler, start, pageSize, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public QueryResult<List<Object[]>> queryForListExt(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        return this.queryExt(dbName, sql, arrayListHandler, start, pageSize, true);
    }

    public QueryResult<List<Object[]>> queryForListExt(JdbcConnection conn, DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        return this.queryExt(conn, dbName, sql, arrayListHandler, start, pageSize, true);
    }

    public List<Object> queryForScalarList(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Object> qr = this.queryExt(dbName, sql, listHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return (List)qr.getResult();
    }

    public List<Object> queryForScalarList(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Object> qr = this.queryExt(conn, dbName, sql, listHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return (List)qr.getResult();
    }

    public List<Object> queryForScalarList(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<Object> qr = this.queryExt(dbName, sql, listHandler, start, pageSize, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return (List)qr.getResult();
    }

    public List<Object> queryForScalarList(JdbcConnection conn, DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<Object> qr = this.queryExt(conn, dbName, sql, listHandler, start, pageSize, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return (List)qr.getResult();
    }

    public QueryResult<List<Object>> queryForScalarListExt(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        return this.queryExt(dbName, sql, listHandler, start, pageSize, true);
    }

    public QueryResult<List<Object>> queryForScalarListExt(JdbcConnection conn, DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        return this.queryExt(conn, dbName, sql, listHandler, start, pageSize, true);
    }

    public Map<String, Object> queryForMap(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Map<String, Object>> qr = this.queryExt(dbName, sql, mapHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public Map<String, Object> queryForMap(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Map<String, Object>> qr = this.queryExt(conn, dbName, sql, mapHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(dbName, sql, jsonHandler, 0, 0, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(conn, dbName, sql, jsonHandler, 0, 0, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(DatabaseEnum dbName, Sql sql, JsonConfig cfg) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(dbName, sql, new JsonHandler(cfg), 0, 0, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(JdbcConnection conn, DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(conn, dbName, sql, jsonHandler, start, pageSize, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(dbName, sql, jsonHandler, start, pageSize, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(DatabaseEnum dbName, Sql sql, int start, int pageSize, boolean useDefaultValue) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(dbName, sql, useDefaultValue ? jsonHandler2 : jsonHandler, start, pageSize, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForJson(DatabaseEnum dbName, Sql sql, int start, int pageSize, JsonConfig cfg) throws SQLException {
        QueryResult<JSONObject> qr = this.queryExt(dbName, sql, new JsonHandler(cfg), start, pageSize, true);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JSONObject queryForCombox(DatabaseEnum dbName, Sql sql, String valueField, String displayField) throws SQLException {
        Combox combox = new Combox(valueField, displayField);
        return this.queryForCombox(dbName, sql, combox);
    }

    public JSONObject queryForCombox(DatabaseEnum dbName, Sql sql, Combox combox) throws SQLException {
        JSONObject json = this.queryForJson(dbName, sql);
        if (json == null) {
            return json;
        }
        if (combox != null) {
            try {
                JSONObject first = new JSONObject();
                first.put(combox.getValueField(), (Object)combox.getValue());
                first.put(combox.getDisplayField(), (Object)combox.getText());
                first.put("selected", combox.isSelected());
                json.getJSONArray("result").insert(0, (Object)first);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return json;
    }

    public QueryResult<JSONObject> queryForJsonExt(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        return this.queryExt(dbName, sql, jsonHandler, start, pageSize, true);
    }

    public List<Map<String, Object>> queryForMapList(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<List<Map<String, Object>>> qr = this.queryExt(dbName, sql, mapListHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public List<Map<String, Object>> queryForMapList(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<List<Map<String, Object>>> qr = this.queryExt(conn, dbName, sql, mapListHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public List<Map<String, Object>> queryForMapList(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        QueryResult<List<Map<String, Object>>> qr = this.queryExt(dbName, sql, mapListHandler, start, pageSize, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public QueryResult<List<Map<String, Object>>> queryForMapListExt(DatabaseEnum dbName, Sql sql, int start, int pageSize) throws SQLException {
        return this.queryExt(dbName, sql, mapListHandler, start, pageSize, true);
    }

    public <T> T queryForBean(DatabaseEnum dbName, Sql sql, Class<T> c) throws SQLException {
        QueryResult<T> qr = this.queryExt(dbName, sql, new BeanHandler<T>(c), 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public <T> T queryForBean(JdbcConnection conn, DatabaseEnum dbName, Sql sql, Class<T> c) throws SQLException {
        QueryResult<T> qr = this.queryExt(conn, dbName, sql, new BeanHandler<T>(c), 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public <T> List<T> queryForBeanList(DatabaseEnum dbName, Sql sql, Class<T> c) throws SQLException {
        QueryResult<T> result = this.queryExt(dbName, sql, new BeanListHandler<T>(c), 0, 0, false);
        if (result.getCode() != 1) {
            throw new SQLException(result.getMessage());
        }
        return (List)result.getResult();
    }

    public <T> List<T> queryForBeanList(JdbcConnection conn, DatabaseEnum dbName, Sql sql, Class<T> c) throws SQLException {
        QueryResult<T> result = this.queryExt(conn, dbName, sql, new BeanListHandler<T>(c), 0, 0, false);
        if (result.getCode() != 1) {
            throw new SQLException(result.getMessage());
        }
        return (List)result.getResult();
    }

    public <T> List<T> queryForBeanList(DatabaseEnum dbName, Sql sql, Class<T> c, int start, int pageSize) throws SQLException {
        QueryResult<T> result = this.queryExt(dbName, sql, new BeanListHandler<T>(c), start, pageSize, false);
        if (result.getCode() != 1) {
            throw new SQLException(result.getMessage());
        }
        return (List)result.getResult();
    }

    public <T> QueryResult<List<T>> queryForBeanListExt(DatabaseEnum dbName, Sql sql, Class<T> c, int start, int pageSize) throws SQLException {
        return this.queryExt(dbName, sql, new BeanListHandler<T>(c), start, pageSize, true);
    }

    public JDataSet queryForJDataSet(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<JDataSet> qr = this.queryExt(dbName, sql, jDataSetHandler, 0, 0);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public Object queryForObject(DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Object> qr = this.queryExt(dbName, sql, scalarHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public Object queryForObject(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        QueryResult<Object> qr = this.queryExt(conn, dbName, sql, scalarHandler, 0, 0, false);
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public Integer queryForInteger(DatabaseEnum dbName, Sql sql) throws SQLException {
        Object v = this.queryForObject(dbName, sql);
        if (v != null) {
            if (v instanceof Long) {
                return ((Long)v).intValue();
            }
            if (v instanceof BigDecimal) {
                return ((BigDecimal)v).intValue();
            }
        }
        return (Integer)v;
    }

    public Integer queryForInteger(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        Object v = this.queryForObject(conn, dbName, sql);
        if (v != null) {
            if (v instanceof Long) {
                return ((Long)v).intValue();
            }
            if (v instanceof BigDecimal) {
                return ((BigDecimal)v).intValue();
            }
        }
        return (Integer)v;
    }

    public Float queryForFloat(DatabaseEnum dbName, Sql sql) throws SQLException {
        BigDecimal v = (BigDecimal)this.queryForObject(dbName, sql);
        if (v != null) {
            return Float.valueOf(v.floatValue());
        }
        return null;
    }

    public Float queryForFloat(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        BigDecimal v = (BigDecimal)this.queryForObject(conn, dbName, sql);
        if (v != null) {
            return Float.valueOf(v.floatValue());
        }
        return null;
    }

    public Double queryForDouble(DatabaseEnum dbName, Sql sql) throws SQLException {
        BigDecimal v = (BigDecimal)this.queryForObject(dbName, sql);
        if (v != null) {
            return v.doubleValue();
        }
        return null;
    }

    public Double queryForDouble(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        BigDecimal v = (BigDecimal)this.queryForObject(conn, dbName, sql);
        if (v != null) {
            return v.doubleValue();
        }
        return null;
    }

    public Timestamp queryForTimestamp(DatabaseEnum dbName, Sql sql) throws SQLException {
        Timestamp v = (Timestamp)this.queryForObject(dbName, sql);
        return v;
    }

    public Timestamp queryForTimestamp(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        Timestamp v = (Timestamp)this.queryForObject(conn, dbName, sql);
        return v;
    }

    public Date queryForDate(DatabaseEnum dbName, Sql sql) throws SQLException {
        Timestamp v = (Timestamp)this.queryForObject(dbName, sql);
        if (v != null) {
            return new Date(v.getTime());
        }
        return null;
    }

    public Date queryForDate(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        Timestamp v = (Timestamp)this.queryForObject(conn, dbName, sql);
        if (v != null) {
            return new Date(v.getTime());
        }
        return null;
    }

    public String queryForString(DatabaseEnum dbName, Sql sql) throws SQLException {
        return (String)this.queryForObject(dbName, sql);
    }

    public String queryForString(JdbcConnection conn, DatabaseEnum dbName, Sql sql) throws SQLException {
        return (String)this.queryForObject(conn, dbName, sql);
    }

    public <T> T query(DatabaseEnum dbName, Sql sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(dbName, sql, rsh, 0, 0);
    }

    public <T> T query(DatabaseEnum dbName, Sql sql, ResultSetHandler<T> rsh, int start, int pageSize) throws SQLException {
        QueryResult<T> qr = this.queryExt(dbName, sql, rsh, start, pageSize);
        if (qr == null) {
            return null;
        }
        if (qr.getCode() != 1) {
            throw new SQLException(qr.getMessage());
        }
        return qr.getResult();
    }

    public JdbcConnection getConnection(DatabaseEnum dbName) throws SQLException {
        return this.getConnection(dbName.toString());
    }

    private synchronized BasicDataSource createDataSource(String dbName) throws SQLException {
        BasicDataSource ds = (BasicDataSource)this.poolMap.get(dbName);
        if (ds != null) {
            return ds;
        }
        if (this.das_url == null) {
            throw new SQLException("you need call addDataSource() in absence of zookeeper");
        }
        ConnectionPoolProperty cp = DbCfgCache.me().get(dbName.toString());
        if (cp == null) {
            System.out.println("cp==null," + dbName.toString());
            DbCfgCache.me().printMapping();
        }
        String[] ipPort = cp.getIpUrl().split(":");
        ds = new BasicDataSource();
        ds.setMaxActive(cp.getMaxConnet());
        ds.setDriverClassName(cp.getDriverName());
        if (cp.getDriverName().equalsIgnoreCase(ORACLE_DriverClass)) {
            ds.setUrl("jdbc:oracle:thin:@" + ipPort[0] + ":" + ipPort[1] + ":" + cp.getDataName());
        } else if (cp.getDriverName().equalsIgnoreCase(MYSQL_DriverClass)) {
            ds.setUrl("jdbc:mysql://" + ipPort[0] + ":" + ipPort[1] + "/" + cp.getDataName() + "?useOldAliasMetadataBehavior=true");
        } else {
            ds.setUrl("jdbc:jtds:sqlserver://" + ipPort[0] + ":" + ipPort[1] + ";DatabaseName=" + cp.getDataName());
        }
        ds.setUsername(cp.getUserName());
        ds.setPassword(cp.getPassword());
        ds.setValidationQuery(cp.getSqlTest());
        ds.setMinIdle(cp.getMinIdle());
        int maxIdle = cp.getMinIdle() * 2;
        if (maxIdle > cp.getMaxConnet()) {
            maxIdle = cp.getMaxConnet();
        }
        ds.setMaxIdle(maxIdle);
        ds.setMaxWait(cp.getMaxliveTime());
        ds.setTestOnBorrow(Boolean.getBoolean(String.valueOf(dbName) + ".testOnBorrow"));
        ds.setTestOnReturn(Boolean.getBoolean(String.valueOf(dbName) + ".testOnReturn"));
        ds.setTestWhileIdle(true);
        ds.setRemoveAbandoned(true);
        ds.setRemoveAbandonedTimeout(Integer.getInteger(String.valueOf(dbName) + ".abandonedTimeout", 30));
        ds.setLogAbandoned(true);
        ds.setTimeBetweenEvictionRunsMillis(Long.getLong("db.timeBetweenEvictionRunsMillis", 30000L));
        ds.setMinEvictableIdleTimeMillis(Long.getLong("db.minEvictableIdleTimeMillis", 60000L));
        try {
            ds.setLogWriter(new PrintWriter(System.out));
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.poolMap.put(dbName.toString(), ds);
        DBStatic.addDB(dbName);
        return ds;
    }

    public JdbcConnection getConnection(String dbName) throws SQLException {
        try {
            BasicDataSource ds = (BasicDataSource)this.poolMap.get(dbName);
            if (ds == null && this.das_url != null) {
                ds = this.createDataSource(dbName);
            }
            if (ds == null) {
                throw new SQLException("Not find:" + dbName.toString());
            }
            return new JdbcConnection(ds.getConnection(), dbName);
        }
        catch (SQLException ex) {
            StringWriter sw = new StringWriter();
            PrintWriter w = new PrintWriter(sw);
            ex.printStackTrace(w);
            Logger.get().error("DAC-CON", LogBody.me().set("msg", (Object)sw.toString()));
            throw ex;
        }
    }

    public int update(DatabaseEnum dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            int n = this.update(jdbcConn, sql);
            return n;
        }
        finally {
            jdbcConn.close();
        }
    }

    public int update(String dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            jdbcConn.startTimer();
            int n = this.update(jdbcConn, sql);
            return n;
        }
        finally {
            jdbcConn.close();
        }
    }

    public int update(JdbcConnection conn, Sql sql) throws SQLException {
        long begin = System.currentTimeMillis();
        long conid = -1L;
        int k = -1;
        String result = SUCCESS;
        SQLException ex = null;
        long time_sql = -1L;
        if (conn != null) {
            conn.addSql(sql);
        }
        try {
            conid = conn.getConnid();
            long sql_begin = System.currentTimeMillis();
            k = queryRunner.update(conn.getConn(), sql.getSqlString(), sql.getParamValueList());
            time_sql = System.currentTimeMillis() - sql_begin;
            int n = k;
            return n;
        }
        catch (SQLException e) {
            ex = e;
            result = ERROR;
            e.printStackTrace();
            throw e;
        }
        finally {
            long time = System.currentTimeMillis() - begin;
            DBStatic.update(conn.getDb(), time_sql, LogBody.me().set(TIME_TOTAL, (Object)time).set(TIME, (Object)time_sql).set(RESULT, (Object)result).set("updated", (Object)k).set(CONID, (Object)conid).set("type", (Object)"update").set("sql", (Object)sql.getSqlString()).set("param", (Object)sql.getValues()), ex);
        }
    }

    public int insert(DatabaseEnum dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            int n = this.insert(jdbcConn, sql, true);
            return n;
        }
        finally {
            jdbcConn.close();
        }
    }

    public int insert(DatabaseEnum dbName, Sql sql, boolean hasGeneratedKey) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            int n = this.insert(jdbcConn, sql, hasGeneratedKey);
            return n;
        }
        finally {
            jdbcConn.close();
        }
    }

    public int[] batchInsert(DatabaseEnum dbName, BatchSql batchSql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            jdbcConn.setAutoCommit(false);
            int[] i = this.batchInsert(jdbcConn, batchSql);
            jdbcConn.commit();
            int[] nArray = i;
            return nArray;
        }
        finally {
            jdbcConn.close();
        }
    }

    public int insert(String dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            jdbcConn.startTimer();
            int n = this.insert(jdbcConn, sql, true);
            return n;
        }
        finally {
            jdbcConn.close();
        }
    }

    public long insertReturnGeneratedKey(DatabaseEnum dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            jdbcConn.startTimer();
            long l = this.insert2(jdbcConn, sql);
            return l;
        }
        finally {
            jdbcConn.close();
        }
    }

    public long insertReturnGeneratedKey(String dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            jdbcConn.startTimer();
            long l = this.insert2(jdbcConn, sql);
            return l;
        }
        finally {
            jdbcConn.close();
        }
    }

    public long insertReturnGeneratedKey(JdbcConnection conn, Sql sql) throws SQLException {
        return this.insert2(conn, sql);
    }

    public String insertReturnPK(DatabaseEnum dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            jdbcConn = this.getConnection(dbName);
            jdbcConn.startTimer();
            Object value = this.insertReturnPK(jdbcConn, sql);
            if (value instanceof Integer) {
                String string = ((Integer)value).toString();
                return string;
            }
            String string = (String)value;
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            jdbcConn.close();
        }
    }

    public Object insertReturnObjectPK(DatabaseEnum dbName, Sql sql) throws SQLException {
        JdbcConnection jdbcConn = null;
        try {
            Object value;
            jdbcConn = this.getConnection(dbName);
            Object object = value = this.insertReturnPK(jdbcConn, sql);
            return object;
        }
        finally {
            jdbcConn.close();
        }
    }

    public void execProcedure(Sql sql, DatabaseEnum dbName) throws SQLException {
        JdbcConnection conn = null;
        try {
            try {
                conn = this.getConnection(dbName);
                conn.setAutoCommit(true);
                CallableStatement proc = conn.getConn().prepareCall("{call " + sql.getSqlString() + " }");
                if (sql.getParamValueList() != null) {
                    int i = 0;
                    while (i < sql.getParamValueList().length) {
                        proc.setObject(i + 1, sql.getParamValueList()[i]);
                        ++i;
                    }
                }
                proc.executeUpdate();
            }
            catch (Exception e) {
                throw new SQLException(e);
            }
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public int execProcedureAsInt(Sql sql, DatabaseEnum dbName, int outParameterIndex) throws SQLException {
        JdbcConnection conn = null;
        try {
            conn = this.getConnection(dbName);
            conn.setAutoCommit(true);
            CallableStatement proc = conn.getConn().prepareCall("{call " + sql.getSqlString() + " }");
            if (sql.getParamValueList() != null) {
                int i = 0;
                while (i < sql.getParamValueList().length) {
                    proc.setObject(i + 1, sql.getParamValueList()[i]);
                    ++i;
                }
            }
            proc.registerOutParameter(outParameterIndex, 4);
            proc.execute();
            int n = proc.getInt(outParameterIndex);
            return n;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        finally {
            try {
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public int insert(JdbcConnection conn, Sql sql, boolean hasGeneratedKey) throws SQLException {
        long begin = System.currentTimeMillis();
        long conid = -1L;
        int k = -1;
        String result = SUCCESS;
        conn.addSql(sql);
        Statement stmt = null;
        ResultSet rs = null;
        SQLException ex = null;
        long time_sql = -1L;
        try {
            conid = conn.getConnid();
            stmt = hasGeneratedKey ? conn.getConn().prepareStatement(sql.getSqlString(), 1) : conn.getConn().prepareStatement(sql.getSqlString());
            if (sql.getParamValueList() != null) {
                int i = 0;
                while (i < sql.getParamValueList().length) {
                    stmt.setObject(i + 1, sql.getParamValueList()[i]);
                    ++i;
                }
            }
            long sql_begin = System.currentTimeMillis();
            k = stmt.executeUpdate();
            time_sql = System.currentTimeMillis() - sql_begin;
            if (hasGeneratedKey) {
                rs = stmt.getGeneratedKeys();
                if (rs != null && rs.next()) {
                    int n = rs.getInt(1);
                    return n;
                }
                return 0;
            }
            int n = k;
            return n;
        }
        catch (SQLException e) {
            ex = e;
            result = ERROR;
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            long time = System.currentTimeMillis() - begin;
            DBStatic.insert(conn.getDb(), time_sql, LogBody.me().set(TIME_TOTAL, (Object)time).set(TIME, (Object)time_sql).set(RESULT, (Object)result).set("insert", (Object)k).set(CONID, (Object)conid).set("sql", (Object)sql.getSqlString()).set("param", (Object)sql.getValues()), ex);
        }
    }

    public int insert(JdbcConnection conn, Sql sql) throws SQLException {
        return this.insert(conn, sql, true);
    }

    public int[] batchInsert(JdbcConnection conn, BatchSql batchSql) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = conn.getConn().prepareStatement(batchSql.getSqlString());
            if (batchSql.getParamValueList() != null) {
                for (Object[] objects : batchSql.getParamValueList()) {
                    int i = 0;
                    while (i < objects.length) {
                        stmt.setObject(i + 1, objects[i]);
                        ++i;
                    }
                    stmt.addBatch();
                }
            }
            int[] nArray = stmt.executeBatch();
            return nArray;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    @Deprecated
    public long insert2(JdbcConnection conn, Sql sql) throws SQLException {
        long begin = System.currentTimeMillis();
        long conid = -1L;
        int k = -1;
        String result = SUCCESS;
        conn.addSql(sql);
        PreparedStatement stmt = null;
        ResultSet rs = null;
        SQLException ex = null;
        long time_sql = -1L;
        try {
            stmt = conn.getConn().prepareStatement(sql.getSqlString(), 1);
            conid = conn.getConnid();
            if (sql.getParamValueList() != null) {
                int i = 0;
                while (i < sql.getParamValueList().length) {
                    stmt.setObject(i + 1, sql.getParamValueList()[i]);
                    ++i;
                }
            }
            long sql_begin = System.currentTimeMillis();
            k = stmt.executeUpdate();
            time_sql = System.currentTimeMillis() - sql_begin;
            rs = stmt.getGeneratedKeys();
            if (rs != null && rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            return 0L;
        }
        catch (SQLException e) {
            ex = e;
            result = ERROR;
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            long time = System.currentTimeMillis() - begin;
            DBStatic.insert(conn.getDb(), time_sql, LogBody.me().set(TIME, (Object)time_sql).set(TIME_TOTAL, (Object)time).set("insert", (Object)k).set(RESULT, (Object)result).set(CONID, (Object)conid).set("sql", (Object)sql.getSqlString()).set("param", (Object)sql.getValues()), ex);
        }
    }

    public Object insertReturnPK(JdbcConnection conn, Sql sql) throws SQLException {
        long begin = System.currentTimeMillis();
        long conid = -1L;
        int k = -1;
        String result = SUCCESS;
        conn.addSql(sql);
        Statement stmt = null;
        ResultSet rs = null;
        SQLException ex = null;
        long time_sql = -1L;
        try {
            conid = conn.getConnid();
            stmt = conn.getConn().prepareStatement(sql.getSqlString(), 1);
            if (sql.getParamValueList() != null) {
                int i = 0;
                while (i < sql.getParamValueList().length) {
                    stmt.setObject(i + 1, sql.getParamValueList()[i]);
                    ++i;
                }
            }
            long sql_begin = System.currentTimeMillis();
            k = stmt.executeUpdate();
            time_sql = System.currentTimeMillis() - sql_begin;
            rs = stmt.getGeneratedKeys();
            if (rs != null && rs.next()) {
                Object obj;
                Object object = obj = rs.getObject(1);
                return object;
            }
            Integer n = 0;
            return n;
        }
        catch (SQLException e) {
            ex = e;
            result = ERROR;
            e.printStackTrace();
            throw e;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            long time = System.currentTimeMillis() - begin;
            DBStatic.insert(conn.getDb(), time_sql, LogBody.me().set(TIME_TOTAL, (Object)time).set(TIME, (Object)time_sql).set("insert", (Object)k).set(RESULT, (Object)result).set(CONID, (Object)conid).set("sql", (Object)sql.getSqlString()).set("param", (Object)sql.getValues()), ex);
        }
    }

    public Map<String, Number> info(String db) {
        HashMap<String, Number> map = new HashMap<String, Number>();
        BasicDataSource ds = (BasicDataSource)this.poolMap.get(db);
        if (ds == null) {
            return map;
        }
        map.put("active", ds.getNumActive());
        map.put("idle", ds.getNumIdle());
        map.put("minIdle", ds.getMinIdle());
        map.put("maxIdle", ds.getMaxIdle());
        map.put("maxActive", ds.getMaxActive());
        return map;
    }
}

