/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import com.coreframework.log.LogBody;
import com.coreframework.log.Logger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.commons.dbcp.DriverConnectionFactory;

public class PausableConnectionFactory
extends DriverConnectionFactory {
    private volatile boolean paused = false;

    public PausableConnectionFactory(Driver driver, String connectUri, Properties props) {
        super(driver, connectUri, props);
    }

    @Override
    public Connection createConnection() throws SQLException {
        if (this.paused) {
            throw new SQLException("cannot open new connection because you have paused it !!!!!!!!!!!!!!!!!!!!!!!!!!");
        }
        Exception ex = null;
        try {
            Connection connection = super.createConnection();
            return connection;
        }
        catch (SQLException e) {
            ex = e;
            throw e;
        }
        catch (RuntimeException e) {
            ex = e;
            throw e;
        }
        finally {
            LogBody body = LogBody.me().set("create_conn", (Object)this._connectUri);
            if (ex != null) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                ex.printStackTrace(w);
                body.set("exception", (Object)sw.toString());
                Logger.get().error("db-jar", body);
            } else {
                Logger.get().debug("db-jar", body);
            }
        }
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }
}

