/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.replication;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.shard.ShardId;

public class ReplicationRequest<T extends ReplicationRequest>
extends ActionRequest<T>
implements IndicesRequest {
    public static final TimeValue DEFAULT_TIMEOUT = new TimeValue(1L, TimeUnit.MINUTES);
    protected ShardId shardId;
    protected TimeValue timeout = DEFAULT_TIMEOUT;
    protected String index;
    private WriteConsistencyLevel consistencyLevel = WriteConsistencyLevel.DEFAULT;
    private volatile boolean canHaveDuplicates = false;

    public ReplicationRequest() {
    }

    public ReplicationRequest(ActionRequest request) {
        super(request);
    }

    public ReplicationRequest(ActionRequest request, ShardId shardId) {
        super(request);
        this.index = shardId.getIndex();
        this.shardId = shardId;
    }

    protected ReplicationRequest(T request) {
        this(request, (ActionRequest)request);
    }

    protected ReplicationRequest(T request, ActionRequest originalRequest) {
        super(originalRequest);
        this.timeout = ((ReplicationRequest)request).timeout();
        this.index = ((ReplicationRequest)request).index();
        this.consistencyLevel = ((ReplicationRequest)request).consistencyLevel();
    }

    void setCanHaveDuplicates() {
        this.canHaveDuplicates = true;
    }

    public boolean canHaveDuplicates() {
        return this.canHaveDuplicates;
    }

    public final T timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (T)this;
    }

    public final T timeout(String timeout) {
        return this.timeout(TimeValue.parseTimeValue(timeout, null, this.getClass().getSimpleName() + ".timeout"));
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public String index() {
        return this.index;
    }

    public final T index(String index) {
        this.index = index;
        return (T)this;
    }

    @Override
    public String[] indices() {
        return new String[]{this.index};
    }

    @Override
    public IndicesOptions indicesOptions() {
        return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
    }

    public WriteConsistencyLevel consistencyLevel() {
        return this.consistencyLevel;
    }

    @Nullable
    public ShardId shardId() {
        return this.shardId;
    }

    public final T consistencyLevel(WriteConsistencyLevel consistencyLevel) {
        this.consistencyLevel = consistencyLevel;
        return (T)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.index == null) {
            validationException = ValidateActions.addValidationError("index is missing", validationException);
        }
        return validationException;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.shardId = in.readBoolean() ? ShardId.readShardId(in) : null;
        this.consistencyLevel = WriteConsistencyLevel.fromId(in.readByte());
        this.timeout = TimeValue.readTimeValue(in);
        this.index = in.readString();
        this.canHaveDuplicates = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (this.shardId != null) {
            out.writeBoolean(true);
            this.shardId.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        out.writeByte(this.consistencyLevel.id());
        this.timeout.writeTo(out);
        out.writeString(this.index);
        out.writeBoolean(this.canHaveDuplicates);
    }

    public T setShardId(ShardId shardId) {
        this.shardId = shardId;
        return (T)this;
    }

    public String toString() {
        if (this.shardId != null) {
            return this.shardId.toString();
        }
        return this.index;
    }
}

