/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaDataIndexStateService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlocks
extends AbstractDiffable<ClusterBlocks> {
    public static final ClusterBlocks EMPTY_CLUSTER_BLOCK;
    public static final ClusterBlocks PROTO;
    private final ImmutableSet<ClusterBlock> global;
    private final ImmutableMap<String, ImmutableSet<ClusterBlock>> indicesBlocks;
    private final ImmutableLevelHolder[] levelHolders;

    ClusterBlocks(ImmutableSet<ClusterBlock> global, ImmutableMap<String, ImmutableSet<ClusterBlock>> indicesBlocks) {
        this.global = global;
        this.indicesBlocks = indicesBlocks;
        this.levelHolders = new ImmutableLevelHolder[ClusterBlockLevel.values().length];
        for (ClusterBlockLevel level : ClusterBlockLevel.values()) {
            ImmutableSet.Builder globalBuilder = ImmutableSet.builder();
            for (ClusterBlock block : global) {
                if (!block.contains(level)) continue;
                globalBuilder.add((Object)block);
            }
            ImmutableMap.Builder indicesBuilder = ImmutableMap.builder();
            for (Map.Entry entry : indicesBlocks.entrySet()) {
                ImmutableSet.Builder indexBuilder = ImmutableSet.builder();
                for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                    if (!block.contains(level)) continue;
                    indexBuilder.add((Object)block);
                }
                indicesBuilder.put(entry.getKey(), (Object)indexBuilder.build());
            }
            this.levelHolders[level.id()] = new ImmutableLevelHolder((ImmutableSet<ClusterBlock>)globalBuilder.build(), (ImmutableMap<String, ImmutableSet<ClusterBlock>>)indicesBuilder.build());
        }
    }

    public ImmutableSet<ClusterBlock> global() {
        return this.global;
    }

    public ImmutableMap<String, ImmutableSet<ClusterBlock>> indices() {
        return this.indicesBlocks;
    }

    public ImmutableSet<ClusterBlock> global(ClusterBlockLevel level) {
        return this.levelHolders[level.id()].global();
    }

    public ImmutableMap<String, ImmutableSet<ClusterBlock>> indices(ClusterBlockLevel level) {
        return this.levelHolders[level.id()].indices();
    }

    public boolean disableStatePersistence() {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.disableStatePersistence()) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlock block) {
        return this.global.contains((Object)block);
    }

    public boolean hasGlobalBlock(int blockId) {
        for (ClusterBlock clusterBlock : this.global) {
            if (clusterBlock.id() != blockId) continue;
            return true;
        }
        return false;
    }

    public boolean hasGlobalBlock(ClusterBlockLevel level) {
        return this.global(level).size() > 0;
    }

    public boolean hasGlobalBlock(RestStatus status) {
        for (ClusterBlock clusterBlock : this.global) {
            if (!clusterBlock.status().equals((Object)status)) continue;
            return true;
        }
        return false;
    }

    public boolean hasIndexBlock(String index, ClusterBlock block) {
        return this.indicesBlocks.containsKey((Object)index) && ((ImmutableSet)this.indicesBlocks.get((Object)index)).contains((Object)block);
    }

    public void globalBlockedRaiseException(ClusterBlockLevel level) throws ClusterBlockException {
        ClusterBlockException blockException = this.globalBlockedException(level);
        if (blockException != null) {
            throw blockException;
        }
    }

    public ClusterBlockException globalBlockedException(ClusterBlockLevel level) {
        if (this.global(level).isEmpty()) {
            return null;
        }
        return new ClusterBlockException((ImmutableSet<ClusterBlock>)ImmutableSet.copyOf(this.global(level)));
    }

    public void indexBlockedRaiseException(ClusterBlockLevel level, String index) throws ClusterBlockException {
        ClusterBlockException blockException = this.indexBlockedException(level, index);
        if (blockException != null) {
            throw blockException;
        }
    }

    public ClusterBlockException indexBlockedException(ClusterBlockLevel level, String index) {
        if (!this.indexBlocked(level, index)) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.global(level));
        ImmutableSet indexBlocks = (ImmutableSet)this.indices(level).get((Object)index);
        if (indexBlocks != null) {
            builder.addAll((Iterable)indexBlocks);
        }
        return new ClusterBlockException((ImmutableSet<ClusterBlock>)builder.build());
    }

    public boolean indexBlocked(ClusterBlockLevel level, String index) {
        if (!this.global(level).isEmpty()) {
            return true;
        }
        ImmutableSet indexBlocks = (ImmutableSet)this.indices(level).get((Object)index);
        return indexBlocks != null && !indexBlocks.isEmpty();
    }

    public ClusterBlockException indicesBlockedException(ClusterBlockLevel level, String[] indices) {
        boolean indexIsBlocked = false;
        for (String index : indices) {
            if (!this.indexBlocked(level, index)) continue;
            indexIsBlocked = true;
        }
        if (!indexIsBlocked) {
            return null;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(this.global(level));
        for (String index : indices) {
            ImmutableSet indexBlocks = (ImmutableSet)this.indices(level).get((Object)index);
            if (indexBlocks == null) continue;
            builder.addAll((Iterable)indexBlocks);
        }
        return new ClusterBlockException((ImmutableSet<ClusterBlock>)builder.build());
    }

    public String prettyPrint() {
        if (this.global.isEmpty() && this.indices().isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("blocks: \n");
        if (!this.global.isEmpty()) {
            sb.append("   _global_:\n");
            for (ClusterBlock block : this.global) {
                sb.append("      ").append(block);
            }
        }
        for (Map.Entry entry : this.indicesBlocks.entrySet()) {
            sb.append("   ").append((String)entry.getKey()).append(":\n");
            for (ClusterBlock block : (ImmutableSet)entry.getValue()) {
                sb.append("      ").append(block);
            }
        }
        sb.append("\n");
        return sb.toString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        ClusterBlocks.writeBlockSet(this.global, out);
        out.writeVInt(this.indicesBlocks.size());
        for (Map.Entry entry : this.indicesBlocks.entrySet()) {
            out.writeString((String)entry.getKey());
            ClusterBlocks.writeBlockSet((ImmutableSet<ClusterBlock>)((ImmutableSet)entry.getValue()), out);
        }
    }

    private static void writeBlockSet(ImmutableSet<ClusterBlock> blocks, StreamOutput out) throws IOException {
        out.writeVInt(blocks.size());
        for (ClusterBlock block : blocks) {
            block.writeTo(out);
        }
    }

    @Override
    public ClusterBlocks readFrom(StreamInput in) throws IOException {
        ImmutableSet<ClusterBlock> global = ClusterBlocks.readBlockSet(in);
        ImmutableMap.Builder indicesBuilder = ImmutableMap.builder();
        int size = in.readVInt();
        for (int j = 0; j < size; ++j) {
            indicesBuilder.put((Object)in.readString().intern(), ClusterBlocks.readBlockSet(in));
        }
        return new ClusterBlocks(global, (ImmutableMap<String, ImmutableSet<ClusterBlock>>)indicesBuilder.build());
    }

    private static ImmutableSet<ClusterBlock> readBlockSet(StreamInput in) throws IOException {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        int size = in.readVInt();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)ClusterBlock.readClusterBlock(in));
        }
        return builder.build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PROTO = EMPTY_CLUSTER_BLOCK = new ClusterBlocks((ImmutableSet<ClusterBlock>)ImmutableSet.of(), (ImmutableMap<String, ImmutableSet<ClusterBlock>>)ImmutableMap.of());
    }

    public static class Builder {
        private Set<ClusterBlock> global = Sets.newHashSet();
        private Map<String, Set<ClusterBlock>> indices = Maps.newHashMap();

        public Builder blocks(ClusterBlocks blocks) {
            this.global.addAll((Collection<ClusterBlock>)blocks.global());
            for (Map.Entry entry : blocks.indices().entrySet()) {
                if (!this.indices.containsKey(entry.getKey())) {
                    this.indices.put((String)entry.getKey(), Sets.newHashSet());
                }
                this.indices.get(entry.getKey()).addAll((Collection)entry.getValue());
            }
            return this;
        }

        public Builder addBlocks(IndexMetaData indexMetaData) {
            if (indexMetaData.getState() == IndexMetaData.State.CLOSE) {
                this.addIndexBlock(indexMetaData.getIndex(), MetaDataIndexStateService.INDEX_CLOSED_BLOCK);
            }
            if (indexMetaData.getSettings().getAsBoolean("index.blocks.read_only", (Boolean)false).booleanValue()) {
                this.addIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_READ_ONLY_BLOCK);
            }
            if (indexMetaData.getSettings().getAsBoolean("index.blocks.read", (Boolean)false).booleanValue()) {
                this.addIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_READ_BLOCK);
            }
            if (indexMetaData.getSettings().getAsBoolean("index.blocks.write", (Boolean)false).booleanValue()) {
                this.addIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_WRITE_BLOCK);
            }
            if (indexMetaData.getSettings().getAsBoolean("index.blocks.metadata", (Boolean)false).booleanValue()) {
                this.addIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_METADATA_BLOCK);
            }
            return this;
        }

        public Builder updateBlocks(IndexMetaData indexMetaData) {
            this.removeIndexBlock(indexMetaData.getIndex(), MetaDataIndexStateService.INDEX_CLOSED_BLOCK);
            this.removeIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_READ_ONLY_BLOCK);
            this.removeIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_READ_BLOCK);
            this.removeIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_WRITE_BLOCK);
            this.removeIndexBlock(indexMetaData.getIndex(), IndexMetaData.INDEX_METADATA_BLOCK);
            return this.addBlocks(indexMetaData);
        }

        public Builder addGlobalBlock(ClusterBlock block) {
            this.global.add(block);
            return this;
        }

        public Builder removeGlobalBlock(ClusterBlock block) {
            this.global.remove(block);
            return this;
        }

        public Builder addIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                this.indices.put(index, Sets.newHashSet());
            }
            this.indices.get(index).add(block);
            return this;
        }

        public Builder removeIndexBlocks(String index) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.remove(index);
            return this;
        }

        public Builder removeIndexBlock(String index, ClusterBlock block) {
            if (!this.indices.containsKey(index)) {
                return this;
            }
            this.indices.get(index).remove(block);
            if (this.indices.get(index).isEmpty()) {
                this.indices.remove(index);
            }
            return this;
        }

        public ClusterBlocks build() {
            ImmutableMap.Builder indicesBuilder = ImmutableMap.builder();
            for (Map.Entry<String, Set<ClusterBlock>> entry : this.indices.entrySet()) {
                indicesBuilder.put((Object)entry.getKey(), (Object)ImmutableSet.copyOf((Collection)entry.getValue()));
            }
            return new ClusterBlocks((ImmutableSet<ClusterBlock>)ImmutableSet.copyOf(this.global), (ImmutableMap<String, ImmutableSet<ClusterBlock>>)indicesBuilder.build());
        }

        public static ClusterBlocks readClusterBlocks(StreamInput in) throws IOException {
            return PROTO.readFrom(in);
        }
    }

    static class ImmutableLevelHolder {
        static final ImmutableLevelHolder EMPTY = new ImmutableLevelHolder((ImmutableSet<ClusterBlock>)ImmutableSet.of(), (ImmutableMap<String, ImmutableSet<ClusterBlock>>)ImmutableMap.of());
        private final ImmutableSet<ClusterBlock> global;
        private final ImmutableMap<String, ImmutableSet<ClusterBlock>> indices;

        ImmutableLevelHolder(ImmutableSet<ClusterBlock> global, ImmutableMap<String, ImmutableSet<ClusterBlock>> indices) {
            this.global = global;
            this.indices = indices;
        }

        public ImmutableSet<ClusterBlock> global() {
            return this.global;
        }

        public ImmutableMap<String, ImmutableSet<ClusterBlock>> indices() {
            return this.indices;
        }
    }
}

