/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress.lzf;

import com.ning.compress.lzf.ChunkDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.IndexInput;
import org.elasticsearch.common.compress.CompressedIndexInput;
import org.elasticsearch.common.compress.lzf.LZFCompressor;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;

@Deprecated
public class LZFCompressedIndexInput
extends CompressedIndexInput {
    private final ChunkDecoder decoder;
    private byte[] inputBuffer;

    public LZFCompressedIndexInput(IndexInput in, ChunkDecoder decoder) throws IOException {
        super(in);
        this.decoder = decoder;
        this.uncompressed = new byte[65535];
        this.uncompressedLength = 65535;
        this.inputBuffer = new byte[65535];
    }

    @Override
    protected void readHeader(IndexInput in) throws IOException {
        byte[] header = new byte[LZFCompressor.LUCENE_HEADER.length];
        in.readBytes(header, 0, header.length, false);
        if (!Arrays.equals(header, LZFCompressor.LUCENE_HEADER)) {
            throw new IOException("wrong lzf compressed header [" + Arrays.toString(header) + "]");
        }
    }

    @Override
    protected int uncompress(IndexInput in, byte[] out) throws IOException {
        return this.decoder.decodeChunk((InputStream)new InputStreamIndexInput(in, Long.MAX_VALUE), this.inputBuffer, out);
    }

    @Override
    protected void doClose() throws IOException {
    }

    @Override
    public IndexInput clone() {
        LZFCompressedIndexInput cloned = (LZFCompressedIndexInput)super.clone();
        cloned.inputBuffer = new byte[65535];
        return cloned;
    }

    public IndexInput slice(String description, long offset, long length) throws IOException {
        return BufferedIndexInput.wrap((String)description, (IndexInput)this, (long)offset, (long)length);
    }
}

