/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.search.function.CombineFunction;

abstract class CustomBoostFactorScorer
extends Scorer {
    final Scorer scorer;
    final float maxBoost;
    final CombineFunction scoreCombiner;
    Float minScore;
    NextDoc nextDoc;

    CustomBoostFactorScorer(Weight w, Scorer scorer, float maxBoost, CombineFunction scoreCombiner, Float minScore) throws IOException {
        super(w);
        this.nextDoc = minScore == null ? new AnyNextDoc() : new MinScoreNextDoc();
        this.scorer = scorer;
        this.maxBoost = maxBoost;
        this.scoreCombiner = scoreCombiner;
        this.minScore = minScore;
    }

    public int docID() {
        return this.scorer.docID();
    }

    public int advance(int target) throws IOException {
        return this.nextDoc.advance(target);
    }

    public int nextDoc() throws IOException {
        return this.nextDoc.nextDoc();
    }

    public abstract float innerScore() throws IOException;

    public float score() throws IOException {
        return this.nextDoc.score();
    }

    public int freq() throws IOException {
        return this.scorer.freq();
    }

    public long cost() {
        return this.scorer.cost();
    }

    public class AnyNextDoc
    implements NextDoc {
        @Override
        public int nextDoc() throws IOException {
            return CustomBoostFactorScorer.this.scorer.nextDoc();
        }

        @Override
        public float score() throws IOException {
            return CustomBoostFactorScorer.this.innerScore();
        }

        @Override
        public int advance(int target) throws IOException {
            return CustomBoostFactorScorer.this.scorer.advance(target);
        }
    }

    public class MinScoreNextDoc
    implements NextDoc {
        float currentScore = -3.4028235E38f;

        @Override
        public int nextDoc() throws IOException {
            int doc;
            do {
                if ((doc = CustomBoostFactorScorer.this.scorer.nextDoc()) == Integer.MAX_VALUE) {
                    return doc;
                }
                this.currentScore = CustomBoostFactorScorer.this.innerScore();
            } while (this.currentScore < CustomBoostFactorScorer.this.minScore.floatValue());
            return doc;
        }

        @Override
        public float score() throws IOException {
            return this.currentScore;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc = CustomBoostFactorScorer.this.scorer.advance(target);
            if (doc == Integer.MAX_VALUE) {
                return doc;
            }
            this.currentScore = CustomBoostFactorScorer.this.innerScore();
            if (this.currentScore < CustomBoostFactorScorer.this.minScore.floatValue()) {
                return CustomBoostFactorScorer.this.scorer.nextDoc();
            }
            return doc;
        }
    }

    public static interface NextDoc {
        public int advance(int var1) throws IOException;

        public int nextDoc() throws IOException;

        public float score() throws IOException;
    }
}

