/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.zen.fd;

import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportService;

public abstract class FaultDetection
extends AbstractComponent {
    public static final String SETTING_CONNECT_ON_NETWORK_DISCONNECT = "discovery.zen.fd.connect_on_network_disconnect";
    public static final String SETTING_PING_INTERVAL = "discovery.zen.fd.ping_interval";
    public static final String SETTING_PING_TIMEOUT = "discovery.zen.fd.ping_timeout";
    public static final String SETTING_PING_RETRIES = "discovery.zen.fd.ping_retries";
    public static final String SETTING_REGISTER_CONNECTION_LISTENER = "discovery.zen.fd.register_connection_listener";
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    protected final TransportService transportService;
    protected final boolean registerConnectionListener;
    protected final FDConnectionListener connectionListener;
    protected final boolean connectOnNetworkDisconnect;
    protected final TimeValue pingInterval;
    protected final TimeValue pingRetryTimeout;
    protected final int pingRetryCount;

    public FaultDetection(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterName clusterName) {
        super(settings);
        this.threadPool = threadPool;
        this.transportService = transportService;
        this.clusterName = clusterName;
        this.connectOnNetworkDisconnect = settings.getAsBoolean(SETTING_CONNECT_ON_NETWORK_DISCONNECT, (Boolean)false);
        this.pingInterval = settings.getAsTime(SETTING_PING_INTERVAL, TimeValue.timeValueSeconds(1L));
        this.pingRetryTimeout = settings.getAsTime(SETTING_PING_TIMEOUT, TimeValue.timeValueSeconds(30L));
        this.pingRetryCount = settings.getAsInt(SETTING_PING_RETRIES, (Integer)3);
        this.registerConnectionListener = settings.getAsBoolean(SETTING_REGISTER_CONNECTION_LISTENER, (Boolean)true);
        this.connectionListener = new FDConnectionListener();
        if (this.registerConnectionListener) {
            transportService.addConnectionListener(this.connectionListener);
        }
    }

    public void close() {
        this.transportService.removeConnectionListener(this.connectionListener);
    }

    abstract void handleTransportDisconnect(DiscoveryNode var1);

    private class FDConnectionListener
    implements TransportConnectionListener {
        private FDConnectionListener() {
        }

        @Override
        public void onNodeConnected(DiscoveryNode node) {
        }

        @Override
        public void onNodeDisconnected(DiscoveryNode node) {
            FaultDetection.this.handleTransportDisconnect(node);
        }
    }
}

