/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.cache.request;

import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.cache.request.RequestCacheStats;
import org.elasticsearch.index.shard.AbstractIndexShardComponent;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.cache.request.IndicesRequestCache;

public class ShardRequestCache
extends AbstractIndexShardComponent
implements RemovalListener<IndicesRequestCache.Key, IndicesRequestCache.Value> {
    final CounterMetric evictionsMetric = new CounterMetric();
    final CounterMetric totalMetric = new CounterMetric();
    final CounterMetric hitCount = new CounterMetric();
    final CounterMetric missCount = new CounterMetric();

    public ShardRequestCache(ShardId shardId, Settings indexSettings) {
        super(shardId, indexSettings);
    }

    public RequestCacheStats stats() {
        return new RequestCacheStats(this.totalMetric.count(), this.evictionsMetric.count(), this.hitCount.count(), this.missCount.count());
    }

    public void onHit() {
        this.hitCount.inc();
    }

    public void onMiss() {
        this.missCount.inc();
    }

    public void onCached(IndicesRequestCache.Key key, IndicesRequestCache.Value value) {
        this.totalMetric.inc(key.ramBytesUsed() + value.ramBytesUsed());
    }

    public void onRemoval(RemovalNotification<IndicesRequestCache.Key, IndicesRequestCache.Value> removalNotification) {
        if (removalNotification.wasEvicted()) {
            this.evictionsMetric.inc();
        }
        long dec = 0L;
        if (removalNotification.getKey() != null) {
            dec += ((IndicesRequestCache.Key)removalNotification.getKey()).ramBytesUsed();
        }
        if (removalNotification.getValue() != null) {
            dec += ((IndicesRequestCache.Value)removalNotification.getValue()).ramBytesUsed();
        }
        this.totalMetric.dec(dec);
    }
}

