/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

public class ContentPath {
    private Type pathType;
    private final char delimiter;
    private final StringBuilder sb;
    private final int offset;
    private int index = 0;
    private String[] path = new String[10];

    public ContentPath() {
        this(0);
    }

    public ContentPath(int offset) {
        this.delimiter = (char)46;
        this.sb = new StringBuilder();
        this.offset = offset;
        this.reset();
    }

    public void reset() {
        this.index = 0;
    }

    public void add(String name) {
        this.path[this.index++] = name;
        if (this.index == this.path.length) {
            String[] newPath = new String[this.path.length + 10];
            System.arraycopy(this.path, 0, newPath, 0, this.path.length);
            this.path = newPath;
        }
    }

    public void remove() {
        this.path[this.index--] = null;
    }

    public String pathAsText(String name) {
        if (this.pathType == Type.JUST_NAME) {
            return name;
        }
        return this.fullPathAsText(name);
    }

    public String fullPathAsText(String name) {
        this.sb.setLength(0);
        for (int i = this.offset; i < this.index; ++i) {
            this.sb.append(this.path[i]).append(this.delimiter);
        }
        this.sb.append(name);
        return this.sb.toString();
    }

    public Type pathType() {
        return this.pathType;
    }

    public void pathType(Type type) {
        this.pathType = type;
    }

    public static enum Type {
        JUST_NAME,
        FULL;

    }
}

